/*
 * Decompiled with CFR 0.152.
 */
package jtp.util;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDF;
import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jtp.util.PropertyUtils;

public class RDFObjectFactory {
    protected Model model;
    public static final String JAVA_NS = "http://ksl.stanford.edu/software/jtp/java-config.daml#";
    protected Property CLASS_NAME;
    protected Property STRING_CONTENTS;
    protected Property PROPERTY_NAME;
    protected Property ELEMENTS;
    protected Property DEFINING_OBJECT;
    protected Property DEFINING_PROPERTY;
    protected Resource OBJECT;
    protected Resource PROPERTY;
    protected Resource PROPERTY_VALUE;
    protected Map resourceTable = new HashMap();
    static /* synthetic */ Class class$java$lang$String;

    public RDFObjectFactory(Model model) {
        this.model = model;
        this.OBJECT = model.createResource("http://ksl.stanford.edu/software/jtp/java-config.daml#Object");
        this.CLASS_NAME = model.createProperty("http://ksl.stanford.edu/software/jtp/java-config.daml#className");
        this.STRING_CONTENTS = model.createProperty("http://ksl.stanford.edu/software/jtp/java-config.daml#stringContents");
        this.PROPERTY = model.createResource("http://ksl.stanford.edu/software/jtp/java-config.daml#Property");
        this.PROPERTY_NAME = model.createProperty("http://ksl.stanford.edu/software/jtp/java-config.daml#propertyName");
        this.ELEMENTS = model.createProperty("http://ksl.stanford.edu/software/jtp/java-config.daml#elements");
        this.PROPERTY_VALUE = model.createResource("http://ksl.stanford.edu/software/jtp/java-config.daml#PropertyValue");
        this.DEFINING_OBJECT = model.createProperty("http://ksl.stanford.edu/software/jtp/java-config.daml#definingObject");
        this.DEFINING_PROPERTY = model.createProperty("http://ksl.stanford.edu/software/jtp/java-config.daml#definingProperty");
    }

    public Map getResourceTable() {
        return this.resourceTable;
    }

    public Object get(Resource resource) {
        return this.resourceTable.get(this.makeKey(resource));
    }

    public Object put(Resource resource, Object object) {
        return this.resourceTable.put(this.makeKey(resource), object);
    }

    public Model getModel() {
        return this.model;
    }

    public Collection getPropertyValues(Property property, Resource resource) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        NodeIterator nodeIterator = this.model.listObjectsOfProperty(resource, property);
        while (nodeIterator.hasNext()) {
            arrayList.add(nodeIterator.next());
        }
        return arrayList;
    }

    public RDFNode getSinglePropertyValue(Property property, Resource resource) {
        Collection collection = this.getPropertyValues(property, resource);
        switch (collection.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (RDFNode)collection.iterator().next();
            }
        }
        throw new IllegalArgumentException("More than one value retrieved for property -- subject " + property + " -- " + resource);
    }

    public Object readObject(Resource resource) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Iterator iterator = this.getPropertyValues(this.CLASS_NAME, resource).iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        Class<?> clazz = Class.forName(((Literal)iterator.next()).getString());
        Class clazz2 = class$java$lang$String == null ? (class$java$lang$String = RDFObjectFactory.class$("java.lang.String")) : class$java$lang$String;
        Method method = null;
        try {
            method = clazz.getDeclaredMethod("valueOf", clazz2);
            if ((method.getModifiers() & 8) == 0) {
                method = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (((class$java$lang$String == null ? (class$java$lang$String = RDFObjectFactory.class$("java.lang.String")) : class$java$lang$String).equals(clazz) || method != null) && (iterator = this.getPropertyValues(this.STRING_CONTENTS, resource).iterator()).hasNext()) {
            String string = ((Literal)iterator.next()).getString();
            if ((class$java$lang$String == null ? (class$java$lang$String = RDFObjectFactory.class$("java.lang.String")) : class$java$lang$String).equals(clazz)) {
                return string;
            }
            return method.invoke(clazz, (Object[])new String[]{string});
        }
        return clazz.newInstance();
    }

    public Object readPropertyValue(Resource resource) throws ClassNotFoundException, IntrospectionException, InstantiationException, IllegalAccessException, InvocationTargetException {
        this.put(resource, null);
        Object object = this.interpret(this.getSinglePropertyValue(this.DEFINING_OBJECT, resource));
        if (object == null) {
            throw new IllegalArgumentException("No defining object for java:PropertyValue " + resource);
        }
        Resource resource2 = (Resource)this.getSinglePropertyValue(this.DEFINING_PROPERTY, resource);
        if (resource2 == null) {
            throw new IllegalArgumentException("No defining property for java:PropertyValue " + resource);
        }
        RDFNode rDFNode = this.getSinglePropertyValue(this.PROPERTY_NAME, resource2);
        if (rDFNode == null) {
            throw new IllegalArgumentException("No property name defined for java:Property " + resource2);
        }
        Method method = PropertyUtils.findGetter(object, ((Literal)rDFNode).getString());
        Object object2 = method.invoke(object, new Object[0]);
        this.put(resource, object2);
        return object2;
    }

    public void readObjects() throws ClassNotFoundException, IntrospectionException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Object object;
        Object object2;
        Property property;
        Collection collection;
        Property property2;
        String string;
        Object object3;
        Resource resource;
        ResIterator resIterator = this.model.listSubjectsWithProperty(RDF.type, (RDFNode)this.OBJECT);
        while (resIterator.hasNext()) {
            resource = resIterator.nextResource();
            object3 = this.readObject(resource);
            this.put(resource, object3);
        }
        resource = this.model.listSubjectsWithProperty(RDF.type, (RDFNode)this.PROPERTY);
        while (resource.hasNext()) {
            object3 = resource.nextResource();
            string = ((Literal)this.getSinglePropertyValue(this.PROPERTY_NAME, (Resource)object3)).getString();
            property2 = this.model.getProperty(object3.getURI());
            if (property2 == null) {
                System.out.println(property2 + " is not a property!");
                continue;
            }
            collection = this.model.listSubjectsWithProperty(property2);
            while (collection.hasNext()) {
                Resource resource2 = collection.nextResource();
                property = this.getSinglePropertyValue(property2, resource2);
                object2 = this.interpret((RDFNode)resource2);
                object = PropertyUtils.findSetter(object2, string);
                Object object4 = this.interpret((RDFNode)property);
                ((Method)object).invoke(object2, object4);
            }
        }
        object3 = this.model.listSubjectsWithProperty(this.ELEMENTS);
        while (object3.hasNext()) {
            string = object3.nextResource();
            property2 = this.getSinglePropertyValue(this.ELEMENTS, (Resource)string);
            collection = (Collection)this.interpret((RDFNode)string);
            int n = 1;
            while ((object2 = this.getSinglePropertyValue(property = RDF.li((int)n), (Resource)property2)) != null) {
                object = this.interpret((RDFNode)object2);
                collection.add(object);
                ++n;
            }
        }
    }

    public Object interpret(RDFNode rDFNode) throws ClassNotFoundException, IntrospectionException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (rDFNode instanceof Resource) {
            Resource resource = (Resource)rDFNode;
            String string = this.makeKey(resource);
            if (!this.resourceTable.containsKey(string)) {
                Object object;
                if (this.model.contains(resource, RDF.type, (RDFNode)this.PROPERTY_VALUE) && (object = this.readPropertyValue(resource)) != null) {
                    return object;
                }
                return null;
            }
            return this.resourceTable.get(string);
        }
        String string = null;
        if (rDFNode instanceof Literal) {
            Literal literal = (Literal)rDFNode;
            Object object = literal.getValue();
            if (!(object instanceof String)) {
                return object;
            }
            string = literal.getString().trim();
        } else {
            string = rDFNode.toString().trim();
        }
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Long.valueOf(string);
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    return Float.valueOf(string);
                }
                catch (NumberFormatException numberFormatException3) {
                    try {
                        return Double.valueOf(string);
                    }
                    catch (NumberFormatException numberFormatException4) {
                        if ("true".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string)) {
                            return Boolean.valueOf(string);
                        }
                        return string;
                    }
                }
            }
        }
    }

    private final String makeKey(Resource resource) {
        return resource.isAnon() ? resource.getId().toString() : resource.getURI();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

