/*
 * Decompiled with CFR 0.152.
 */
package jtp.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;

public class PropertyUtils {
    public static Method findGetter(Object object, String string) throws IntrospectionException {
        Method method = null;
        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        int n = 0;
        while (n < propertyDescriptorArray.length) {
            if (propertyDescriptorArray[n].getName().equals(string) && (method = propertyDescriptorArray[n].getReadMethod()) == null) break;
            ++n;
        }
        return method;
    }

    public static Method findSetter(Object object, String string) throws IntrospectionException {
        Method method = null;
        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        int n = 0;
        while (n < propertyDescriptorArray.length) {
            if (propertyDescriptorArray[n].getName().equals(string) && (method = propertyDescriptorArray[n].getWriteMethod()) == null) break;
            ++n;
        }
        return method;
    }

    public static void copyProperty(Object object, String string, Object object2) {
        PropertyUtils.copyProperty(object, string, object2, string);
    }

    public static Object getProperty(Object object, String string) {
        try {
            Method method = PropertyUtils.findGetter(object, string);
            if (method == null) {
                throw new IllegalArgumentException("Getter method not found for property \"" + string + "\" of the following object: " + object);
            }
            return method.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception.toString());
        }
    }

    public static void setProperty(Object object, String string, Object object2) {
        try {
            Method method = PropertyUtils.findSetter(object, string);
            if (method == null) {
                throw new IllegalArgumentException("Setter method not found for property \"" + string + "\" of the following object: " + object);
            }
            method.invoke(object, object2);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception.toString());
        }
    }

    public static void copyProperty(Object object, String string, Object object2, String string2) {
        PropertyUtils.setProperty(object2, string2, PropertyUtils.getProperty(object, string));
    }
}

