/*
 * Decompiled with CFR 0.152.
 */
package jtp.util;

import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jtp.util.PropertyExporter;
import jtp.util.PropertyUtils;
import jtp.util.UnexpectedException;

public class PropertyBinding
implements PropertyChangeListener,
VetoableChangeListener {
    String tgtPropName;
    String srcPropName;
    Object source;
    Object target;
    Method setter;

    public PropertyBinding(Object object, String string) throws IntrospectionException {
        this(object, string, null, string);
    }

    public PropertyBinding(Object object, String string, Object object2) throws IntrospectionException {
        this(object, string, object2, string);
    }

    public PropertyBinding(Object object, String string, Object object2, String string2) throws IntrospectionException {
        this.target = object;
        this.tgtPropName = string;
        this.source = object2;
        this.srcPropName = string2;
        this.setter = PropertyUtils.findSetter(object, string);
        if (this.setter == null) {
            throw new NullPointerException("No setter method: target property name " + string + ", target object class " + object.getClass().getName());
        }
    }

    public void updateValue() throws InvocationTargetException, IllegalAccessException, IntrospectionException {
        Object object;
        if (this.source instanceof PropertyExporter && (object = (PropertyExporter)this.source).hasProperty(this.srcPropName)) {
            this.setter.invoke(this.target, object.getValue(this.srcPropName));
            return;
        }
        object = PropertyUtils.findGetter(this.source, this.srcPropName);
        if (object == null) {
            throw new NullPointerException("No getter method: source property name " + this.srcPropName + ", source object class " + this.source.getClass().getName());
        }
        this.setter.invoke(this.target, ((Method)object).invoke(this.source, new Object[0]));
    }

    protected void updateValue(PropertyChangeEvent propertyChangeEvent) throws InvocationTargetException, IllegalAccessException {
        if (this.source != null && propertyChangeEvent.getSource() != this.source) {
            return;
        }
        if (!this.srcPropName.equals(propertyChangeEvent.getPropertyName())) {
            return;
        }
        this.setter.invoke(this.target, propertyChangeEvent.getNewValue());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        try {
            this.updateValue(propertyChangeEvent);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UnexpectedException(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnexpectedException(illegalAccessException);
        }
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        try {
            this.updateValue(propertyChangeEvent);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new PropertyVetoException("Exception while setting property: " + invocationTargetException.toString(), propertyChangeEvent);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnexpectedException(illegalAccessException);
        }
    }
}

