/*
 * Decompiled with CFR 0.152.
 */
package jtp.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import jtp.util.ObjectStorage;

public class FileObjectStorage
implements ObjectStorage,
Serializable {
    protected File file;
    protected transient RandomAccessFile raf;
    protected transient InputStream in;
    protected transient OutputStream out;
    private boolean readOnly = false;

    public FileObjectStorage(File file) throws IOException {
        this(file, false);
    }

    public FileObjectStorage(File file, boolean bl) throws IOException {
        this.readOnly = bl;
        this.setFile(file);
        this.in = new Input();
        this.out = new Output();
    }

    public synchronized long storeObject(Object object) throws IOException {
        if (this.raf == null) {
            this.initRandomAccessFile();
        }
        long l = this.raf.length();
        try {
            this.raf.seek(l);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.out);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            return l;
        }
        catch (IOException iOException) {
            this.raf.seek(l);
            throw iOException;
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
        this.raf = null;
    }

    public synchronized Object retrieveObjectAt(long l) throws IOException {
        Object object;
        if (this.raf == null) {
            this.initRandomAccessFile();
        }
        this.raf.seek(l);
        ObjectInputStream objectInputStream = new ObjectInputStream(this.in);
        try {
            object = objectInputStream.readObject();
            Object var6_5 = null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                throw new IOException("Class not found: " + classNotFoundException.getMessage());
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                objectInputStream.close();
                throw throwable;
            }
        }
        objectInputStream.close();
        return object;
    }

    private final void initRandomAccessFile() throws IOException {
        this.raf = new RandomAccessFile(this.file, this.isReadOnly() ? "r" : "rw");
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.in = new Input();
        this.out = new Output();
    }

    class Input
    extends InputStream {
        Input() {
        }

        public int read() throws IOException {
            return FileObjectStorage.this.raf.read();
        }
    }

    class Output
    extends OutputStream {
        Output() {
        }

        public void write(int n) throws IOException {
            FileObjectStorage.this.raf.write(n);
        }
    }
}

