/*
 * Decompiled with CFR 0.152.
 */
package jtp.undo;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import jtp.undo.MultipleTellEdit;
import jtp.undo.Snapshot;

public class SnapshotUndoManager
extends UndoManager {
    public Snapshot getSnapshot() {
        if (this.edits.isEmpty()) {
            return new Snapshot(null);
        }
        return new Snapshot(this.editToBeUndone());
    }

    public void revertToSnapshot(Snapshot snapshot) throws CannotUndoException {
        UndoableEdit undoableEdit = snapshot.getEdit();
        UndoableEdit undoableEdit2 = null;
        if (!this.canUndo()) {
            if (undoableEdit == null) {
                return;
            }
            throw new CannotUndoException();
        }
        if (undoableEdit != null) {
            boolean bl = false;
            ListIterator listIterator = this.edits.listIterator(this.edits.size());
            while (listIterator.hasPrevious() && !bl) {
                boolean bl2 = bl = undoableEdit == listIterator.previous();
            }
            if (!bl) {
                throw new CannotUndoException();
            }
            listIterator.next();
            if (listIterator.hasNext()) {
                undoableEdit2 = (UndoableEdit)listIterator.next();
            }
        }
        if (undoableEdit == null && !this.edits.isEmpty()) {
            this.undoTo((UndoableEdit)this.edits.elementAt(0));
        } else if (undoableEdit2 != null && undoableEdit2.canUndo()) {
            this.undoTo(undoableEdit2);
        }
    }

    public List getObjectsToldSinceSnapshot(Snapshot snapshot) {
        UndoableEdit undoableEdit = snapshot.getEdit();
        ListIterator listIterator = null;
        if (undoableEdit != null) {
            boolean bl = false;
            listIterator = this.edits.listIterator(this.edits.size());
            while (listIterator.hasPrevious() && !bl) {
                boolean bl2 = bl = undoableEdit == listIterator.previous();
            }
            if (!bl) {
                throw new IllegalArgumentException("Invalid snapshot.");
            }
            listIterator.next();
        } else {
            listIterator = this.edits.listIterator();
        }
        LinkedList linkedList = new LinkedList();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            if (!(e instanceof MultipleTellEdit)) continue;
            ((MultipleTellEdit)e).collectToldObjects(linkedList);
        }
        return linkedList;
    }
}

