/*
 * Decompiled with CFR 0.152.
 */
package jtp.ui.rs;

import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParsePosition;
import jtp.fol.CNFSentence;
import jtp.fol.Clause;
import jtp.fol.Literal;
import jtp.fol.Symbol;
import jtp.fol.Variable;
import jtp.ui.rs.UnambiguousFormat;

public abstract class SentenceFormat
extends Format {
    UnambiguousFormat symbolFormat = new UnambiguousFormat();
    UnambiguousFormat variableFormat = new UnambiguousFormat();
    private static final String SYMBOL_PATTERN = "{0}";
    private static final String VARIABLE_PATTERN = "<font color=\"#008000\">{0}</font>";
    Format keywordFormat = new MessageFormat("<font color=\"#800000\">{0}</font>");

    public SentenceFormat() {
        this.symbolFormat.setNameFormat(new SymbolNameFormat());
        this.symbolFormat.setUnambiguousNameFormatter(new MessageFormat(SYMBOL_PATTERN));
        this.variableFormat.setNameFormat(new VariableNameFormat());
        this.variableFormat.setUnambiguousNameFormatter(new MessageFormat(VARIABLE_PATTERN));
    }

    public Format getKeywordFormat() {
        return this.keywordFormat;
    }

    public void setKeywordFormat(Format format) {
        this.keywordFormat = format;
    }

    public UnambiguousFormat getSymbolFormat() {
        return this.symbolFormat;
    }

    public UnambiguousFormat getVariableFormat() {
        return this.variableFormat;
    }

    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Literal) {
            return this.format((Literal)object, stringBuffer, null);
        }
        if (object instanceof Clause) {
            return this.format((Clause)object, stringBuffer, null);
        }
        if (object instanceof CNFSentence) {
            return this.format((CNFSentence)object, stringBuffer, null);
        }
        if (object instanceof Symbol) {
            return this.symbolFormat.format(object, stringBuffer, null);
        }
        if (object instanceof Variable) {
            return this.variableFormat.format(object, stringBuffer, null);
        }
        if (object instanceof String) {
            return stringBuffer.append('\"').append(object).append('\"');
        }
        return stringBuffer.append(object);
    }

    public abstract StringBuffer format(CNFSentence var1, StringBuffer var2, FieldPosition var3);

    public abstract StringBuffer format(Clause var1, StringBuffer var2, FieldPosition var3);

    public abstract StringBuffer format(Literal var1, StringBuffer var2, FieldPosition var3);

    protected abstract StringBuffer formatKeyword(String var1, StringBuffer var2);

    public Object parseObject(String string, ParsePosition parsePosition) {
        throw new UnsupportedOperationException();
    }

    static class VariableNameFormat
    extends Format {
        VariableNameFormat() {
        }

        public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            return stringBuffer.append('?').append(((Variable)object).getName());
        }

        public Object parseObject(String string, ParsePosition parsePosition) {
            throw new UnsupportedOperationException();
        }
    }

    static class SymbolNameFormat
    extends Format {
        SymbolNameFormat() {
        }

        public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            return stringBuffer.append(((Symbol)object).getName());
        }

        public Object parseObject(String string, ParsePosition parsePosition) {
            throw new UnsupportedOperationException();
        }
    }
}

