/*
 * Decompiled with CFR 0.152.
 */
package jtp.ui.rs;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Format;
import java.util.StringTokenizer;
import javax.swing.JEditorPane;
import jtp.fol.CNFSentence;
import jtp.fol.SubstUtils;
import jtp.proof.Proof;
import jtp.ui.AnswerUtil;
import jtp.ui.rs.KIFSentenceFormat;
import jtp.ui.rs.VariableBindingsFormat;

public class RSDetailsPane
extends JEditorPane {
    Format goalFormat = new KIFSentenceFormat();
    VariableBindingsFormat varsFormat = new VariableBindingsFormat(this.goalFormat);
    Proof proof;

    public RSDetailsPane() {
        this.setContentType("text/html");
        this.setEditable(false);
        this.addPropertyChangeListener("proof", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getNewValue() != propertyChangeEvent.getOldValue()) {
                    RSDetailsPane.this.rebuildDocument();
                }
            }
        });
        this.addPropertyChangeListener("goalFormat", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RSDetailsPane.this.varsFormat.setElementFormat(RSDetailsPane.this.getGoalFormat());
                RSDetailsPane.this.rebuildDocument();
            }
        });
    }

    public Format getGoalFormat() {
        return this.goalFormat;
    }

    public void setGoalFormat(Format format) {
        this.goalFormat = format;
        this.firePropertyChange("goalFormat", this.goalFormat, this.goalFormat);
    }

    public Proof getProof() {
        return this.proof;
    }

    public void setProof(Proof proof) {
        this.proof = proof;
        this.firePropertyChange("proof", this.proof, this.proof);
    }

    public void rebuildDocument() {
        Proof proof = this.getProof();
        if (proof == null) {
            this.setText("");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><font size=\"+1\"><b>Conclusion:</b></font><p>");
        Object object = proof.getGoal();
        if (object instanceof CNFSentence) {
            object = SubstUtils.deReferenceSentence((CNFSentence)object);
        }
        this.goalFormat.format(object, stringBuffer, null).append("<hr>");
        if (!proof.getSubGoals().isEmpty()) {
            stringBuffer.append("<b>Subgoals:</b><p><ol>");
            int n = 0;
            while (n < proof.getSubGoals().size()) {
                stringBuffer.append("<li>");
                this.goalFormat.format(proof.getSubGoals().get(n), stringBuffer, null);
                if (n >= proof.getSubProofs().size()) {
                    stringBuffer.append(" - <i>not proved</i>");
                }
                stringBuffer.append("</li>");
                ++n;
            }
            stringBuffer.append("</ol>");
        } else {
            stringBuffer.append("<i>No subgoals.</i>");
        }
        if (!proof.getBindings().isEmpty()) {
            stringBuffer.append("<hr><b>Variable bindings:</b><p><ul>");
            this.varsFormat.format(proof.getBindings(), stringBuffer, null);
            stringBuffer.append("</ul>");
        }
        String string = proof.getInference().toString(proof);
        try {
            string = AnswerUtil.shortenNS(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuffer.append("<p><pre>");
        RSDetailsPane.appendHTML(stringBuffer, string).append("</pre>");
        stringBuffer.append("</html>");
        this.setText(stringBuffer.toString());
    }

    private static StringBuffer appendHTML(StringBuffer stringBuffer, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "<>&", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("<".equals(string2)) {
                stringBuffer.append("&lt;");
                continue;
            }
            if (">".equals(string2)) {
                stringBuffer.append("&gt;");
                continue;
            }
            if ("&".equals(string2)) {
                stringBuffer.append("&amp;");
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer;
    }
}

