/*
 * Decompiled with CFR 0.152.
 */
package jtp.ui.rs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import jtp.fol.Unifyable;
import jtp.fol.kif.SymbolFormat;
import jtp.proof.Proof;
import jtp.proof.transform.IdenticalSubgoalTransformer;
import jtp.proof.transform.ProofTransformingEngine;
import jtp.proof.transform.UnrolledRulesTransformer;
import jtp.rs.RSUtils;
import jtp.ui.rs.CompleteEnglishSentenceFormat;
import jtp.ui.rs.GoalTree;
import jtp.ui.rs.KIFSentenceFormat;
import jtp.ui.rs.RSDetailsPane;

public class RSBrowser
extends JPanel {
    List proofStack = new ArrayList();
    Proof rs;
    GoalTree gt;
    RSDetailsPane details;
    JTabbedPane tabs;
    Format eng = new CompleteEnglishSentenceFormat();
    KIFSentenceFormat brief = new KIFSentenceFormat();
    KIFSentenceFormat full = new KIFSentenceFormat();
    JMenuBar menuBar = new JMenuBar();
    ProofTransformingEngine simplifier = new ProofTransformingEngine();
    public static final String ALL_VARS_TITLE = "All variables";
    static /* synthetic */ Class class$javax$swing$JSplitPane;

    public JTabbedPane getTabs() {
        return this.tabs;
    }

    public RSBrowser() {
        this.setLayout(new BorderLayout());
        this.full.getSymbolFormat().setNameFormat(new SymbolFormat());
        this.gt = new GoalTree();
        this.details = new RSDetailsPane();
        this.gt.setGoalFormat(this.brief);
        this.details.setGoalFormat(this.brief);
        this.gt.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath treePath = RSBrowser.this.gt.getSelectionPath();
                if (treePath == null || !(treePath.getLastPathComponent() instanceof Proof)) {
                    return;
                }
                RSBrowser.this.details.setProof((Proof)treePath.getLastPathComponent());
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.gt);
        jScrollPane.setPreferredSize(new Dimension(200, 400));
        this.tabs = new JTabbedPane();
        this.tabs.addTab("Details", new JScrollPane(this.details));
        this.tabs.setSelectedIndex(0);
        this.tabs.setPreferredSize(new Dimension(300, 400));
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, this.tabs);
        try {
            Method method = (class$javax$swing$JSplitPane == null ? (class$javax$swing$JSplitPane = RSBrowser.class$("javax.swing.JSplitPane")) : class$javax$swing$JSplitPane).getDeclaredMethod("setResizeWeight", Double.TYPE);
            method.invoke((Object)jSplitPane, new Double(0.6666666666666666));
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        this.add((Component)jSplitPane, "Center");
        this.configureMenuBar();
        this.gt.configureMenu(this.getMenuBar());
        this.createNavigationMenu();
        this.addPropertyChangeListener("proof", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Proof proof = RSBrowser.this.getProof();
                RSBrowser.this.details.setProof(proof);
                RSBrowser.this.gt.setRootProof(proof);
                RSBrowser.this.createAllVarsView(proof);
            }
        });
        this.simplifier.getTransformers().add(new IdenticalSubgoalTransformer());
        this.simplifier.getTransformers().add(0, new UnrolledRulesTransformer());
    }

    public Proof getProof() {
        return this.rs;
    }

    public void setProof(Proof proof) {
        if (this.rs != null) {
            this.proofStack.add(this.rs);
        }
        this.rs = proof;
        this.firePropertyChange("proof", this.rs, this.rs);
    }

    public void popProof() {
        Proof proof;
        if (this.proofStack.isEmpty()) {
            throw new IllegalStateException();
        }
        this.rs = proof = (Proof)this.proofStack.remove(this.proofStack.size() - 1);
        this.firePropertyChange("proof", this.rs, this.rs);
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    protected void createAllVarsView(Proof proof) {
        Object object;
        Map map = RSUtils.getRecursiveBindings(proof, new HashMap());
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setContentType("text/html");
        jEditorPane.setEditable(false);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><font size=\"+1\"><b>All variables</b></font><p><ol>");
        if (proof instanceof Unifyable) {
            object = ((Unifyable)((Object)proof)).getVariables(new HashSet(map.size() * 2));
            object.removeAll(map.keySet());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                map.put(iterator.next(), null);
            }
        }
        this.details.varsFormat.format(map, stringBuffer, null);
        stringBuffer.append("</ol></html>");
        jEditorPane.setText(stringBuffer.toString());
        object = new JScrollPane(jEditorPane);
        int n = this.tabs.indexOfTab(ALL_VARS_TITLE);
        if (n < 0) {
            this.tabs.addTab(ALL_VARS_TITLE, (Component)object);
        } else {
            this.tabs.setComponentAt(n, (Component)object);
        }
    }

    protected void createNavigationMenu() {
        final JMenuItem jMenuItem = new JMenuItem("Back");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RSBrowser.this.popProof();
            }
        });
        JMenu jMenu = RSBrowser.getSubMenu(this.getMenuBar(), "Navigation");
        jMenu.add(jMenuItem);
        final JMenuItem jMenuItem2 = new JMenuItem("Zoom");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Proof proof = RSBrowser.this.details.getProof();
                if (proof != null) {
                    RSBrowser.this.setProof(proof);
                } else {
                    JOptionPane.showMessageDialog(RSBrowser.this, "No proof selected", "Error", 0);
                }
            }
        });
        jMenu.add(jMenuItem2);
        final JMenuItem jMenuItem3 = new JMenuItem("Simplify");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Proof proof = RSBrowser.this.simplifier.transform(RSBrowser.this.getProof());
                if (proof != RSBrowser.this.getProof()) {
                    RSBrowser.this.setProof(proof);
                } else {
                    JOptionPane.showMessageDialog(RSBrowser.this, "No simplification possible", "Sorry", 2);
                }
            }
        });
        jMenu.add(jMenuItem3);
        this.addPropertyChangeListener("proof", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                jMenuItem.setEnabled(!RSBrowser.this.proofStack.isEmpty());
                jMenuItem3.setEnabled(RSBrowser.this.getProof() != null);
            }
        });
        this.details.addPropertyChangeListener("proof", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Proof proof = RSBrowser.this.details.getProof();
                jMenuItem2.setEnabled(proof != null && proof != RSBrowser.this.getProof());
            }
        });
    }

    public static final JMenu getSubMenu(JMenuBar jMenuBar, String string) {
        int n = 0;
        while (n < jMenuBar.getMenuCount()) {
            if (string.equals(jMenuBar.getMenu(n).getText())) {
                return jMenuBar.getMenu(n);
            }
            ++n;
        }
        JMenu jMenu = new JMenu(string);
        jMenuBar.add(jMenu);
        return jMenu;
    }

    protected void configureMenuBar() {
        JMenuBar jMenuBar = this.getMenuBar();
        JMenu jMenu = RSBrowser.getSubMenu(jMenuBar, "File");
        JMenuItem jMenuItem = new JMenuItem("Close");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Container container = RSBrowser.this.getTopLevelAncestor();
                if (container instanceof Window) {
                    ((Window)container).dispose();
                }
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Quit");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        jMenu = RSBrowser.getSubMenu(jMenuBar, "View");
        JMenu jMenu2 = new JMenu("Sentence format");
        ButtonGroup buttonGroup = new ButtonGroup();
        jMenuItem = new JRadioButtonMenuItem("KIF (brief package names)", true);
        jMenuItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (((AbstractButton)itemEvent.getSource()).isSelected()) {
                    RSBrowser.this.details.setGoalFormat(RSBrowser.this.brief);
                    RSBrowser.this.gt.setGoalFormat(RSBrowser.this.brief);
                }
            }
        });
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = new JRadioButtonMenuItem("KIF (full package names)", false);
        jMenuItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (((AbstractButton)itemEvent.getSource()).isSelected()) {
                    RSBrowser.this.details.setGoalFormat(RSBrowser.this.full);
                    RSBrowser.this.gt.setGoalFormat(RSBrowser.this.full);
                }
            }
        });
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = new JRadioButtonMenuItem("English", false);
        jMenuItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (((AbstractButton)itemEvent.getSource()).isSelected()) {
                    RSBrowser.this.details.setGoalFormat(RSBrowser.this.eng);
                    RSBrowser.this.gt.setGoalFormat(RSBrowser.this.eng);
                }
            }
        });
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenu.add(jMenu2);
        jMenuBar.add(jMenu);
    }

    public static void show(Proof proof) {
        RSBrowser rSBrowser = new RSBrowser();
        rSBrowser.setProof(proof);
        JDialog jDialog = new JDialog((Frame)null, "Proof for " + proof.getGoal(), true);
        jDialog.getContentPane().add(rSBrowser);
        jDialog.setJMenuBar(rSBrowser.getMenuBar());
        jDialog.pack();
        jDialog.show();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

