/*
 * Decompiled with CFR 0.152.
 */
package jtp.ui.rs;

import java.text.FieldPosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import jtp.fol.CNFSentence;
import jtp.fol.Clause;
import jtp.fol.DefaultCNFSentence;
import jtp.fol.DefaultClause;
import jtp.fol.DefaultLiteral;
import jtp.fol.Literal;
import jtp.ui.rs.SentenceFormat;

public class KIFSentenceFormat
extends SentenceFormat {
    public StringBuffer format(Literal literal, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (!literal.isPositive()) {
            this.formatKeyword("not", stringBuffer);
        }
        stringBuffer.append('(');
        this.symbolFormat.format(literal.getRelation(), stringBuffer, null);
        if (!literal.getArgs().isEmpty()) {
            stringBuffer.append(' ');
        }
        this.formatSpacedList(literal.getArgs(), stringBuffer);
        stringBuffer.append(')');
        if (!literal.isPositive()) {
            stringBuffer.append(')');
        }
        return stringBuffer;
    }

    public StringBuffer format(Clause clause, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (clause.literals().size() == 1) {
            return this.format((Literal)clause.literals().iterator().next(), stringBuffer, null);
        }
        ArrayList<Literal> arrayList = new ArrayList<Literal>();
        ArrayList<DefaultLiteral> arrayList2 = new ArrayList<DefaultLiteral>();
        Iterator iterator = clause.literals().iterator();
        while (iterator.hasNext()) {
            Literal literal = (Literal)iterator.next();
            if (literal.isPositive()) {
                arrayList.add(literal);
                continue;
            }
            arrayList2.add(new DefaultLiteral(literal.getRelation(), literal.getArgs(), true));
        }
        if (!arrayList.isEmpty() && !arrayList2.isEmpty()) {
            this.formatKeyword("&lt;=", stringBuffer);
            this.format(new DefaultClause(arrayList), stringBuffer, null).append(' ');
            return this.format(new DefaultCNFSentence(arrayList2), stringBuffer, null).append(')');
        }
        this.formatKeyword("or", stringBuffer);
        return this.formatSpacedList(clause.literals(), stringBuffer).append(')');
    }

    public StringBuffer format(CNFSentence cNFSentence, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (cNFSentence.clauses().size() == 1) {
            return this.format((Clause)cNFSentence.clauses().iterator().next(), stringBuffer, null);
        }
        this.formatKeyword("and", stringBuffer);
        return this.formatSpacedList(cNFSentence.clauses(), stringBuffer).append(')');
    }

    protected StringBuffer formatKeyword(String string, StringBuffer stringBuffer) {
        stringBuffer.append('(');
        this.getKeywordFormat().format(new Object[]{string}, stringBuffer, null);
        return stringBuffer.append(' ');
    }

    protected StringBuffer formatSpacedList(Collection collection, StringBuffer stringBuffer) {
        Iterator iterator = collection.iterator();
        if (iterator.hasNext()) {
            this.format(iterator.next(), stringBuffer, null);
        }
        while (iterator.hasNext()) {
            stringBuffer.append(' ');
            this.format(iterator.next(), stringBuffer, null);
        }
        return stringBuffer;
    }
}

