/*
 * Decompiled with CFR 0.152.
 */
package jtp.ui.rs;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Format;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jtp.fol.CNFSentence;
import jtp.fol.SubstUtils;
import jtp.proof.Proof;
import jtp.ui.rs.KIFSentenceFormat;
import jtp.ui.rs.RSBrowser;

public class GoalTree
extends JTree {
    Format goalFormat;
    Proof rootProof;

    public GoalTree() {
        this.setGoalFormat(new KIFSentenceFormat());
        this.setCellRenderer(new Renderer());
        this.expand(Integer.MAX_VALUE);
        this.addPropertyChangeListener("goalFormat", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Proof proof = GoalTree.this.getRootProof();
                if (proof != null) {
                    GoalTree.this.setModel(new Model(proof));
                    GoalTree.this.expand(Integer.MAX_VALUE);
                }
            }
        });
        this.addPropertyChangeListener("rootProof", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                GoalTree.this.setModel(new Model((Proof)propertyChangeEvent.getNewValue()));
                GoalTree.this.expand(Integer.MAX_VALUE);
            }
        });
    }

    public Format getGoalFormat() {
        return this.goalFormat;
    }

    public void setGoalFormat(Format format) {
        this.goalFormat = format;
        this.firePropertyChange("goalFormat", this.goalFormat, this.goalFormat);
    }

    public Proof getRootProof() {
        return this.rootProof;
    }

    public void setRootProof(Proof proof) {
        this.rootProof = proof;
        this.firePropertyChange("rootProof", this.rootProof, this.rootProof);
    }

    public void configureMenu(JMenuBar jMenuBar) {
        JMenu jMenu = new JMenu("Expand tree");
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("All", true);
        jRadioButtonMenuItem.addItemListener(new ExpansionListener(Integer.MAX_VALUE));
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        int n = 1;
        while (n <= 10) {
            jRadioButtonMenuItem = new JRadioButtonMenuItem(String.valueOf(n), false);
            jRadioButtonMenuItem.addItemListener(new ExpansionListener(n));
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
            ++n;
        }
        RSBrowser.getSubMenu(jMenuBar, "View").add(jMenu);
    }

    private void expand(TreePath treePath, int n) {
        if (n == 0) {
            this.makeVisible(treePath);
            this.collapsePath(treePath);
            return;
        }
        Object object = treePath.getLastPathComponent();
        int n2 = this.getModel().getChildCount(object);
        if (n == 1 || n > 1 && n2 == 0) {
            this.makeVisible(treePath);
            this.expandPath(treePath);
        }
        int n3 = 0;
        while (n3 < n2) {
            this.expand(treePath.pathByAddingChild(this.getModel().getChild(object, n3)), n - 1);
            ++n3;
        }
    }

    public void expand(int n) {
        this.expand(new TreePath(this.getModel().getRoot()), n);
    }

    public String getPathID(TreePath treePath) {
        StringBuffer stringBuffer = new StringBuffer("RS");
        Object object = treePath.getPathComponent(0);
        int n = 1;
        while (n < treePath.getPathCount()) {
            int n2;
            Object object2;
            block3: {
                object2 = treePath.getPathComponent(n);
                int n3 = this.getModel().getChildCount(object);
                n2 = 0;
                while (n2 < n3) {
                    if (object2 != this.getModel().getChild(object, n2)) {
                        ++n2;
                        continue;
                    }
                    break block3;
                }
                throw new IllegalArgumentException("Not a legal path");
            }
            stringBuffer.append('.').append(n2);
            object = object2;
            ++n;
        }
        return stringBuffer.toString();
    }

    public TreePath buildFromID(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (!"RS".equals(stringTokenizer.nextToken())) {
            throw new IllegalArgumentException("Expected RS prefix for path ID");
        }
        Object object = this.getModel().getRoot();
        TreePath treePath = new TreePath(object);
        while (stringTokenizer.hasMoreTokens()) {
            int n = Integer.parseInt(stringTokenizer.nextToken());
            Object object2 = this.getModel().getChild(object, n);
            treePath = treePath.pathByAddingChild(object2);
            object = object2;
        }
        return treePath;
    }

    class Renderer
    extends DefaultTreeCellRenderer {
        Renderer() {
            this.setClosedIcon(null);
            this.setOpenIcon(null);
            this.setLeafIcon(null);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Object object2;
            if (object instanceof Proof) {
                object2 = ((Proof)object).getGoal();
                if (object2 instanceof CNFSentence) {
                    object2 = SubstUtils.deReferenceSentence((CNFSentence)object2);
                }
                this.setForeground(Color.black);
            } else {
                object2 = object;
                this.setForeground(Color.red);
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html>");
            GoalTree.this.getGoalFormat().format(object2, stringBuffer, null);
            stringBuffer.append("</html>");
            return super.getTreeCellRendererComponent(jTree, stringBuffer.toString(), bl, bl2, bl3, n, bl4);
        }
    }

    static class Model
    implements TreeModel {
        Proof rootRS;

        Model(Proof proof) {
            this.rootRS = proof;
        }

        public Object getChild(Object object, int n) {
            if (!(object instanceof Proof)) {
                return null;
            }
            Proof proof = (Proof)object;
            if (n < 0 || n >= proof.getSubGoals().size()) {
                return null;
            }
            if (n >= proof.getSubProofs().size()) {
                return proof.getSubGoals().get(n);
            }
            return proof.getSubProofs().get(n);
        }

        public int getChildCount(Object object) {
            if (object instanceof Proof) {
                return ((Proof)object).getSubGoals().size();
            }
            return 0;
        }

        public boolean isLeaf(Object object) {
            return this.getChildCount(object) == 0;
        }

        public Object getRoot() {
            return this.rootRS;
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
            throw new UnsupportedOperationException("The GoalTree is immutable");
        }

        public int getIndexOfChild(Object object, Object object2) {
            int n = 0;
            while (n < this.getChildCount(object)) {
                if (this.getChild(object, n) == object2) {
                    return n;
                }
                ++n;
            }
            throw new IllegalArgumentException(object2 + " is not a child of " + object);
        }

        public void addTreeModelListener(TreeModelListener treeModelListener) {
        }

        public void removeTreeModelListener(TreeModelListener treeModelListener) {
        }
    }

    private class ExpansionListener
    implements ItemListener {
        int expLevel;

        ExpansionListener(int n) {
            this.expLevel = n;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() != 1) {
                return;
            }
            GoalTree.this.expand(this.expLevel);
        }
    }
}

