/*
 * Decompiled with CFR 0.152.
 */
package jtp.ui.rs;

import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jtp.fol.CNFSentence;
import jtp.fol.Clause;
import jtp.fol.DefaultClause;
import jtp.fol.Literal;
import jtp.fol.Symbol;
import jtp.fol.Unifyable;
import jtp.frame.vocab.DAML;
import jtp.frame.vocab.RDF;
import jtp.frame.vocab.RDFS;
import jtp.frame.vocab.StandardFrames;
import jtp.ui.rs.SentenceFormat;

public class EnglishSentenceFormat
extends SentenceFormat {
    Map templates = new HashMap();
    MessageFormat defaultFormat = new MessageFormat("{1} has a {0} {2}");
    MessageFormat nonSymbolFormat = new MessageFormat("{1} has a value {2} for property {0}");
    String indent = "  ";
    static final String SUMO_URL = "http://reliant.teknowledge.com/DAML/SUMO.daml#";

    public EnglishSentenceFormat(boolean bl) {
        this();
        if (bl) {
            this.symbolFormat.setNameFormat(new MixedCaseToSpacesSymbolNameFormat());
        }
    }

    public EnglishSentenceFormat() {
        this.addTemplate(Symbol.newSymbol("="), "{1} is equal to {2}");
        this.addTemplate(RDF.type, "{1} is a {2}");
        this.addTemplate(RDFS.subClassOf, "every {1} is a {2}");
        this.addTemplate(DAML.subClassOf, "every {1} is a {2}");
        this.addTemplate(DAML.equivalentTo, "{1} and {2} are the same");
        this.addTemplate(DAML.sameClassAs, "{1} and {2} are the same class");
        this.addTemplate(DAML.samePropertyAs, "{1} and {2} are the same property");
        this.addTemplate(DAML.sameIndividualAs, "{1} and {2} are the same individual");
        this.addTemplate(RDFS.subPropertyOf, "{2} is a sub-property of {1}");
        this.addTemplate(DAML.disjointWith, "{1} is disjoint with {2}");
        this.addTemplate(DAML.complementOf, "{1} is the complement of {2}");
        this.addTemplate(DAML.inverseOf, "{1} is the inverse of {2}");
        this.addTemplate(DAML.onProperty, "{1} restricts the property {2}");
        this.addTemplate(DAML.item, "{2} is an item of list {1}");
        this.addTemplate(DAML.first, "{2} is the first item of the list {1}");
        this.addTemplate(DAML.rest, "{2} is the rest of the list {1}");
        this.addTemplate(DAML.toClass, "{1} restricts the property to have only values of type {2}");
        this.addTemplate(DAML.hasValue, "{1} restricts the property to have a value of {2}");
        this.addTemplate(DAML.hasClass, "{1} restricts the property to have at least one value of type {2}");
        this.addTemplate(DAML.hasClassQ, "{1} places a restriction on the number of values of type {2} for the property");
        this.addTemplate(DAML.cardinality, "{1} restricts the property to have exactly {2} values");
        this.addTemplate(DAML.minCardinality, "{1} restricts the property to have a minimum of {2} values");
        this.addTemplate(DAML.maxCardinality, "{1} restricts the property to have a maximum of {2} values");
        this.addTemplate(DAML.cardinalityQ, "{1} restricts the property to have exactly {2} values of the particular type");
        this.addTemplate(DAML.minCardinalityQ, "{1} restricts the property to have a minimum of {2} values of the particular type");
        this.addTemplate(DAML.maxCardinalityQ, "{1} restricts the property to have a maximum of {2} values of the particular type");
        this.addTemplate(RDFS.domain, "only types of {2} can have values for {1}");
        this.addTemplate(RDFS.range, "only types of {2} can be values for {1}");
        this.addTemplate(DAML.differentIndividualFrom, "{1} and {2} are different things, i.e., they cannot be equivalent");
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String string) {
        this.indent = string;
    }

    public void addTemplate(Symbol symbol, String string) {
        this.templates.put(symbol, new MessageFormat(string));
    }

    public void setDefaultTemplate(String string) {
        this.defaultFormat = new MessageFormat(string);
    }

    public StringBuffer format(CNFSentence cNFSentence, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (cNFSentence.clauses().size() == 1) {
            return this.format((Clause)cNFSentence.clauses().iterator().next(), stringBuffer, fieldPosition);
        }
        Iterator iterator = cNFSentence.clauses().iterator();
        stringBuffer.append("all of the following is true:\n");
        int n = stringBuffer.length();
        this.format((Clause)iterator.next(), stringBuffer, fieldPosition);
        EnglishSentenceFormat.indent(stringBuffer, this.indent, n);
        while (iterator.hasNext()) {
            stringBuffer.append(",\nand ");
            n = stringBuffer.length();
            this.format((Clause)iterator.next(), stringBuffer, fieldPosition);
            EnglishSentenceFormat.indent(stringBuffer, this.indent, n);
        }
        return stringBuffer;
    }

    public StringBuffer format(Clause clause, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        Literal literal;
        if (clause.literals().size() == 1) {
            return this.format((Literal)clause.literals().iterator().next(), stringBuffer, fieldPosition);
        }
        ArrayList<Literal> arrayList = new ArrayList<Literal>();
        ArrayList<Literal> arrayList2 = new ArrayList<Literal>();
        Iterator iterator = clause.literals().iterator();
        while (iterator.hasNext()) {
            literal = (Literal)iterator.next();
            if (literal.isPositive()) {
                arrayList.add(literal);
                continue;
            }
            arrayList2.add(literal);
        }
        if (arrayList2.isEmpty()) {
            stringBuffer.append("either ");
            return this.formatLiteralList(arrayList, stringBuffer, "or");
        }
        if (arrayList.isEmpty()) {
            stringBuffer.append("one of the following must be false:\neither ");
            return this.formatLiteralList(arrayList2, stringBuffer, "or");
        }
        if (arrayList.size() == 1) {
            literal = (Literal)arrayList.get(0);
            this.format(literal, stringBuffer, fieldPosition);
            stringBuffer.append('\n' + (literal.getArgs() instanceof Unifyable ? "when" : "if") + ' ');
            return this.formatLiteralList(arrayList2, stringBuffer, "and");
        }
        this.format(new DefaultClause(arrayList), stringBuffer, fieldPosition);
        stringBuffer.append(",\n");
        int n = stringBuffer.length();
        this.format(new DefaultClause(arrayList2), stringBuffer, fieldPosition);
        return EnglishSentenceFormat.indent(stringBuffer, this.indent, n, stringBuffer.length());
    }

    private StringBuffer formatLiteralList(List list, StringBuffer stringBuffer, String string) {
        this.doFormat((Literal)list.get(0), stringBuffer);
        int n = 1;
        while (n < list.size()) {
            stringBuffer.append(",\n" + this.indent + string + " ");
            this.doFormat((Literal)list.get(n), stringBuffer);
            ++n;
        }
        return stringBuffer;
    }

    public StringBuffer format(Literal literal, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (!literal.isPositive()) {
            throw new IllegalArgumentException();
        }
        return this.doFormat(literal, stringBuffer);
    }

    private StringBuffer doFormat(Literal literal, StringBuffer stringBuffer) {
        MessageFormat messageFormat;
        Symbol symbol;
        int n = StandardFrames.HOLDS.equals(literal.getRelation()) ? 0 : 1;
        Object[] objectArray = new Object[literal.getArgs().size() + n];
        if (n == 1) {
            objectArray[0] = this.format(literal.getRelation());
        }
        int n2 = n;
        while (n2 < objectArray.length) {
            symbol = literal.getArgs().get(n2 - n);
            objectArray[n2] = this.format(symbol);
            ++n2;
        }
        symbol = n == 1 ? literal.getRelation() : literal.getArgs().get(0);
        MessageFormat messageFormat2 = messageFormat = symbol instanceof Symbol ? (MessageFormat)this.templates.get(symbol) : this.nonSymbolFormat;
        if (messageFormat == null) {
            messageFormat = this.defaultFormat;
        }
        return messageFormat.format(objectArray, stringBuffer, (FieldPosition)null);
    }

    protected StringBuffer formatKeyword(String string, StringBuffer stringBuffer) {
        return this.getKeywordFormat().format(new Object[]{string}, stringBuffer, null);
    }

    public static StringBuffer indent(StringBuffer stringBuffer, String string, int n) {
        return EnglishSentenceFormat.indent(stringBuffer, string, n, stringBuffer.length());
    }

    public static StringBuffer indent(StringBuffer stringBuffer, String string, int n, int n2) {
        if (n < 0 || n >= stringBuffer.length() || n2 < 0 || n > n2) {
            throw new IllegalArgumentException();
        }
        if (n2 > stringBuffer.length()) {
            n2 = stringBuffer.length();
        }
        char[] cArray = new char[n2 - n];
        stringBuffer.getChars(n, n2, cArray, 0);
        StringBuffer stringBuffer2 = new StringBuffer();
        int n3 = 0;
        while (n3 < cArray.length) {
            stringBuffer2.append(cArray[n3]);
            if (cArray[n3] == '\n') {
                stringBuffer2.append(string);
            }
            ++n3;
        }
        stringBuffer.replace(n, n2, stringBuffer2.toString());
        return stringBuffer;
    }

    public static StringBuffer capitalize(StringBuffer stringBuffer, int n) {
        boolean bl = false;
        int n2 = n;
        while (n2 < stringBuffer.length()) {
            char c = stringBuffer.charAt(n2);
            if (c == '<') {
                while (++n2 < stringBuffer.length()) {
                    if (stringBuffer.charAt(n2) != '>') {
                        continue;
                    }
                    break;
                }
            } else {
                if (Character.isLowerCase(c)) {
                    stringBuffer.setCharAt(n2, Character.toUpperCase(c));
                    break;
                }
                if (!Character.isWhitespace(c)) break;
            }
            ++n2;
        }
        return stringBuffer;
    }

    static class MixedCaseToSpacesSymbolNameFormat
    extends Format {
        MixedCaseToSpacesSymbolNameFormat() {
        }

        public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            String string = ((Symbol)object).getName();
            return MixedCaseToSpacesSymbolNameFormat.mixedCaseToSpaced(string, stringBuffer);
        }

        static StringBuffer mixedCaseToSpaced(String string, StringBuffer stringBuffer) {
            int n = string.length();
            int n2 = 0;
            while (true) {
                char c = string.charAt(n2);
                stringBuffer.append(c);
                if (++n2 >= n) break;
                char c2 = string.charAt(n2);
                if (!Character.isLowerCase(c) || !Character.isLetter(c2) || !Character.isUpperCase(c2)) continue;
                stringBuffer.append(' ');
            }
            return stringBuffer;
        }

        public Object parseObject(String string, ParsePosition parsePosition) {
            throw new UnsupportedOperationException();
        }
    }
}

