/*
 * Decompiled with CFR 0.152.
 */
package jtp.ui.cmd.answer;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import jtp.ReasoningException;
import jtp.ReasoningStep;
import jtp.ReasoningStepIterator;
import jtp.ui.cmd.AnswerDisplayer;

public class BindingsDisplayer
extends AnswerDisplayer {
    PrintWriter pw;

    public BindingsDisplayer(Writer writer) {
        this.pw = new PrintWriter(writer, true);
    }

    public void displayAnswer(ReasoningStep reasoningStep, String string) {
        this.pw.println(string);
        this.printBindings(AnswerDisplayer.getTopLevelBindings(reasoningStep));
    }

    public void displayAnswers(ReasoningStepIterator reasoningStepIterator) throws ReasoningException {
        int n = 1;
        HashSet<Map> hashSet = new HashSet<Map>();
        ReasoningStep reasoningStep = reasoningStepIterator.next();
        if (reasoningStep != null) {
            this.pw.println("\nQuery succeeded.\n");
        } else {
            this.pw.println("\nQuery failed.\n");
        }
        while (reasoningStep != null) {
            Map map = AnswerDisplayer.getTopLevelBindings(reasoningStep);
            if (!hashSet.contains(map) && !map.isEmpty()) {
                this.pw.println("Bindings " + n + ':');
                this.printBindings(map);
                hashSet.add(map);
                ++n;
            }
            reasoningStep = reasoningStepIterator.next();
        }
    }

    public void printBindings(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.pw.println("   " + entry.getKey() + " = " + entry.getValue());
        }
    }
}

