/*
 * Decompiled with CFR 0.152.
 */
package jtp.ui.cmd;

import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.Stack;
import jtp.context.BasicReasoningContext;
import jtp.fol.kif.KIF2CNF;
import jtp.iw.InferenceWebAskCommand;
import jtp.ui.cmd.AddReasonerCommand;
import jtp.ui.cmd.AskCommand;
import jtp.ui.cmd.Command;
import jtp.ui.cmd.Console;
import jtp.ui.cmd.NamespaceMappingCommands;
import jtp.ui.cmd.PickOptionCommand;
import jtp.ui.cmd.TellCommand;
import jtp.ui.cmd.answer.BindingsDisplayer;
import jtp.ui.cmd.answer.DebugAnswerDisplayer;
import jtp.ui.cmd.answer.ProofBrowserAnswerDisplayer;
import jtp.ui.cmd.answer.ProofTextAnswerDisplayer;
import jtp.util.ArrayMap;

public class ReasoningContextConsole
extends Console {
    protected BasicReasoningContext ctx;
    protected Map answerFormats = new ArrayMap();
    protected Map parsers = new ArrayMap();
    protected KIF2CNF kifParser = new KIF2CNF();
    protected Stack checkpoints = new Stack();

    public ReasoningContextConsole(BasicReasoningContext basicReasoningContext, Reader reader, Writer writer) {
        super(reader, writer);
        this.ctx = basicReasoningContext;
    }

    protected void setUp() {
        super.setUp();
        BindingsDisplayer bindingsDisplayer = new BindingsDisplayer(this.out);
        this.answerFormats.put("Variable bindings only", bindingsDisplayer);
        this.answerFormats.put("Full proof", new ProofTextAnswerDisplayer(this.out));
        this.answerFormats.put("Bring up ProofBrowser", new ProofBrowserAnswerDisplayer());
        this.answerFormats.put("Debug format", new DebugAnswerDisplayer(this.out));
        this.addCommand(new TellCommand(this.ctx));
        AskCommand askCommand = new AskCommand(this.ctx);
        askCommand.setAnswerDisplayer(bindingsDisplayer);
        this.addCommand(askCommand);
        this.addCommand(new AnswerFormatCommand(askCommand));
        this.addCommand(new NamespaceMappingCommands.Add(this.kifParser));
        this.addCommand(new NamespaceMappingCommands.Print(this.kifParser));
        this.addCommand(new AddReasonerCommand(this.ctx));
        this.addCommand(new InferenceWebAskCommand(this.ctx));
        this.parsers.put("KIF", this.kifParser);
        this.ctx.setParser(this.kifParser);
    }

    public class AnswerFormatCommand
    extends PickOptionCommand {
        Command target;

        public AnswerFormatCommand(Command command) {
            super("answer-format", "Choose answer format", command.findParameter("answerDisplayer"), "Choose answer format:\n", ReasoningContextConsole.this.answerFormats);
            this.setDescription("Choose between different formats for results of your queries");
        }
    }
}

