/*
 * Decompiled with CFR 0.152.
 */
package jtp.ui.cmd;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import jtp.fol.kif.KIF2CNF;
import jtp.ui.cmd.Command;

public class NamespaceMappingCommands {

    public static class Print
    extends Command {
        KIF2CNF kifParser;

        public Print(KIF2CNF kIF2CNF) {
            super("print-ns-mappings", "Display namespace mappings");
            this.kifParser = kIF2CNF;
            this.setDescription("Prints all available namespace mappings for entering queries.");
        }

        public void execute() {
            PrintWriter printWriter = this.io.getOutput();
            printWriter.println("Current namespace mapings:");
            Iterator iterator = this.kifParser.getNamespaceMap().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                printWriter.println(entry.getKey() + " ---> " + entry.getValue());
            }
        }
    }

    public static class Add
    extends Command {
        KIF2CNF kifParser;
        public static final String FROM = "from";
        public static final String TO = "to";
        String from;
        String to;

        public String getTo() {
            return this.to;
        }

        public void setTo(String string) {
            this.to = string;
        }

        public String getFrom() {
            return this.from;
        }

        public void setFrom(String string) {
            this.from = string;
        }

        public Add(KIF2CNF kIF2CNF) {
            super("add-ns-mapping", "Add namespace mapping");
            this.kifParser = kIF2CNF;
            this.setDescription("Add a namespace mapping to use for entering queries. You will be prompted for the two namespaces, one to map from, the other to map to. Whenever you enter a symbol with the first namespace, it will be replaced by the second namespace. The namespaces may contain any combination of alphanumeric characters and the characters + (plus sign), - (hyphen), _ (underscore), and . (period)");
            this.addParameter(FROM, "Map from:", false);
            this.addParameter(TO, "Map to:", false);
        }

        public void execute() {
            if (!this.validNameSpace(this.from)) {
                this.io.error("Invalid namespace: \"" + this.from + "\"");
                return;
            }
            if (!this.validNameSpace(this.to)) {
                this.io.error("Invalid namespace: \"" + this.to + "\"");
                return;
            }
            Object v = this.kifParser.getNamespaceMap().get(this.from);
            this.kifParser.addNamespaceMapping(this.from, this.to);
            if (v != null) {
                this.io.message("Changing mapping for input namespace \"" + this.from + "\":\n" + "From \"" + v + "\"\n" + "To \"" + this.to + "\"");
            }
        }

        public boolean validNameSpace(String string) {
            return !"".equals(string);
        }
    }
}

