/*
 * Decompiled with CFR 0.152.
 */
package jtp.ui.cmd;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import jtp.ReasoningException;
import jtp.context.BasicReasoningContext;
import jtp.fol.parser.FirstOrderLogicParser;
import jtp.ui.cmd.Command;

public class LoadKBCommand
extends Command {
    BasicReasoningContext ctx;
    public static final String LOCATION = "location";
    public static final String PUB_LOCATION = "publicLocation";
    FirstOrderLogicParser parser = null;
    String location;
    String publicLocation;

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public String getPublicLocation() {
        return this.publicLocation;
    }

    public void setPublicLocation(String string) {
        this.publicLocation = string;
    }

    public LoadKBCommand(BasicReasoningContext basicReasoningContext, String string, String string2) {
        super(string, string2);
        this.ctx = basicReasoningContext;
        this.addParameter(LOCATION, "Enter the actual KB location (URL or file):", false);
        this.addParameter(PUB_LOCATION, "Enter the nominal KB location (empty for same as above):", false);
        this.setDescription("Load a knowledge base from a file or a URL");
    }

    public LoadKBCommand(BasicReasoningContext basicReasoningContext) {
        this(basicReasoningContext, "load-kb", "Load KB");
    }

    public FirstOrderLogicParser getParser() {
        return this.parser;
    }

    public void setParser(FirstOrderLogicParser firstOrderLogicParser) {
        this.parser = firstOrderLogicParser;
    }

    protected URL makeURL(String string, String string2) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                return new File(string).toURL();
            }
            catch (MalformedURLException malformedURLException2) {
                this.io.error("Invalid " + string2 + ": " + string);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws IOException, ReasoningException {
        URL uRL;
        URL uRL2 = this.makeURL(this.location, "actual location");
        URL uRL3 = uRL = "".equals(this.publicLocation) ? uRL2 : this.makeURL(this.publicLocation, "nominal location");
        if (uRL2 == null || uRL == null) {
            return;
        }
        FirstOrderLogicParser firstOrderLogicParser = null;
        if (this.parser != null) {
            firstOrderLogicParser = this.ctx.getParser();
            this.ctx.setParser(this.parser);
        }
        try {
            this.doLoad(uRL2, uRL);
            Object var5_4 = null;
            if (this.parser != null) {
                this.ctx.setParser(firstOrderLogicParser);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.parser != null) {
                this.ctx.setParser(firstOrderLogicParser);
            }
            throw throwable;
        }
    }

    protected void doLoad(URL uRL, URL uRL2) throws ReasoningException, IOException {
        this.ctx.loadKB(uRL, uRL2);
    }
}

