/*
 * Decompiled with CFR 0.152.
 */
package jtp.ui.cmd;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import jtp.ReasoningException;
import jtp.frame.listen.Context;
import jtp.ui.cmd.Command;

public class LoadFCRulesCommand
extends Command {
    Context ctx;
    public static final String LOCATION = "location";
    String location;

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public LoadFCRulesCommand(Context context, String string, String string2) {
        super(string, string2);
        this.ctx = context;
        this.addParameter(LOCATION, "Enter the rules file location (URL or file):", false);
        this.setDescription("Load forward-chaining rules from a file or a URL");
    }

    public LoadFCRulesCommand(Context context) {
        this(context, "load-rules", "Load rules");
    }

    protected URL makeURL(String string, String string2) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                return new File(string).toURL();
            }
            catch (MalformedURLException malformedURLException2) {
                this.io.error("Invalid " + string2 + ": " + string);
                return null;
            }
        }
    }

    public void execute() throws IOException, ReasoningException {
        URL uRL = this.makeURL(this.location, LOCATION);
        if (uRL == null) {
            return;
        }
        this.ctx.loadSpecs(uRL);
    }
}

