/*
 * Decompiled with CFR 0.152.
 */
package jtp.ui.cmd;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import jtp.ui.cmd.Command;
import jtp.ui.cmd.CommandIO;
import jtp.util.IndentingWriter;
import jtp.util.UnexpectedException;

public class Console
implements CommandIO {
    protected Map commands = new TreeMap();
    protected BufferedReader in;
    protected PrintWriter out;

    public Console(Reader reader, Writer writer) {
        this.in = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.out = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer, true);
    }

    public void addCommand(Command command) {
        StringTokenizer stringTokenizer = new StringTokenizer(command.getName().toLowerCase(), ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.commands.put(stringTokenizer.nextToken(), command);
        }
        command.setIo(this);
    }

    protected void setUp() {
        this.addCommand(new QuitCommand());
        this.addCommand(new PrintUsage());
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    String string;
                    StringTokenizer stringTokenizer;
                    if (!(stringTokenizer = new StringTokenizer(string = this.promptFor(this.getPrompt()))).hasMoreTokens()) {
                        continue;
                    }
                    String string2 = stringTokenizer.nextToken().toLowerCase();
                    Command command = (Command)this.commands.get(string2);
                    if (command == null) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        Iterator<String> iterator = ((SortedMap)this.commands).tailMap(string2).keySet().iterator();
                        while (iterator.hasNext()) {
                            String string3 = iterator.next();
                            if (string3.length() <= string2.length() || !string3.substring(0, string2.length()).equals(string2)) break;
                            arrayList.add(string3);
                        }
                        if (arrayList.isEmpty()) {
                            this.out.println("Illegal command: " + string2);
                            continue;
                        }
                        arrayList.add("(cancel)");
                        int n = this.promptFor("Possible completions:\n", arrayList, arrayList.size() > 2 ? arrayList.size() - 1 : 0);
                        if (n >= arrayList.size() - 1) continue;
                        command = (Command)this.commands.get(arrayList.get(n));
                    }
                    command.prepare();
                    command.execute();
                }
            }
            catch (QuitException quitException) {
                this.out.println("Quitting...");
                return;
            }
            catch (Throwable throwable) {
                this.out.println("Exception while executing command:");
                throwable.printStackTrace(this.out);
                continue;
            }
            break;
        }
    }

    protected String getPrompt() {
        return ">";
    }

    public String promptFor(String string) {
        char c = string.charAt(string.length() - 1);
        if (c != '\n' && c != ' ') {
            string = string + ' ';
        }
        this.out.print(string);
        this.out.flush();
        StringBuffer stringBuffer = new StringBuffer();
        try {
            while (true) {
                String string2;
                if ((string2 = this.in.readLine()) == null) {
                    return stringBuffer.toString();
                }
                stringBuffer.append(string2);
                if (!string2.endsWith("\\")) break;
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            throw new UnexpectedException(iOException);
        }
    }

    public int promptFor(String string, List list, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        int n2 = 1;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("    ").append(n2++).append(". ").append(iterator.next()).append('\n');
        }
        stringBuffer.append("Enter your selection");
        if (n >= 0) {
            stringBuffer.append(" (default: ").append(n + 1).append(")");
        }
        stringBuffer.append(":");
        String string2 = this.promptFor(stringBuffer.toString());
        int n3 = n;
        if (!"".equals(string2)) {
            try {
                n3 = Integer.parseInt(string2) - 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (n3 < 0 || n3 >= list.size()) {
            this.error("Invalid selection.");
        }
        return n3;
    }

    public void message(String string) {
        this.out.println(string);
    }

    public void error(String string) {
        this.out.println("Error: " + string);
    }

    public void error(String string, Throwable throwable) {
        this.out.println("Error: " + (string != null ? string : ""));
        if (throwable != null) {
            throwable.printStackTrace(this.out);
        }
    }

    public PrintWriter getOutput() {
        return this.out;
    }

    private static class QuitCommand
    extends Command {
        public QuitCommand() {
            super("Quit,Exit", "Quit");
            this.setDescription("Quit the program");
        }

        public void execute() {
            throw new QuitException();
        }
    }

    private static class QuitException
    extends RuntimeException {
        private QuitException() {
        }
    }

    public class PrintUsage
    extends Command {
        public static final int LEFT_MARGIN = 20;
        public static final int RIGHT_MARGIN = 70;

        public PrintUsage() {
            super("help", "Print Usage");
            this.setDescription("Print short descriptions of available commands");
        }

        public void execute() {
            IndentingWriter indentingWriter = new IndentingWriter(this.io.getOutput());
            indentingWriter.setRightMargin(70);
            try {
                Iterator iterator = new HashSet(Console.this.commands.values()).iterator();
                while (iterator.hasNext()) {
                    Command command = (Command)iterator.next();
                    indentingWriter.setLeftMargin(0);
                    indentingWriter.write(command.getName().toLowerCase() + ": ");
                    indentingWriter.setLeftMargin(20);
                    String string = command.getDescription();
                    indentingWriter.write(string != null ? string : "(No description provided)");
                    if (indentingWriter.getColumn() == 0) continue;
                    indentingWriter.write('\n');
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

