/*
 * Decompiled with CFR 0.152.
 */
package jtp.ui.cmd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import jtp.ui.cmd.CommandIO;
import jtp.util.PropertyUtils;

public abstract class Command {
    String name;
    String menuName;
    String description;
    Icon icon;
    CommandIO io;
    public static final String COMMAND_NAME = "Command name";
    protected List parameters = new ArrayList();

    public Command(String string, String string2) {
        this.name = string;
        this.menuName = string2;
    }

    public Command(String string) {
        this(string, string);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getMenuName() {
        return this.menuName;
    }

    public void setMenuName(String string) {
        this.menuName = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public CommandIO getIo() {
        return this.io;
    }

    public void setIo(CommandIO commandIO) {
        this.io = commandIO;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public void prepare() {
        Iterator iterator = this.parameters.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            if (parameter.isPersistant() && parameter.getValue() != null) continue;
            String string = this.io.promptFor(parameter.getPrompt());
            parameter.setValue(string);
        }
    }

    public abstract void execute() throws Exception;

    public void addParameter(String string, String string2, boolean bl) {
        this.addParameter(new Parameter(string, string2, bl));
    }

    public void addParameter(String string) {
        this.addParameter(string, "Enter " + string + ": ", false);
    }

    public void addParameter(Parameter parameter) {
        parameter.setOwner(this);
        this.parameters.add(parameter);
    }

    public Parameter findParameter(String string) {
        Iterator iterator = this.parameters.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            if (!parameter.getName().equals(string)) continue;
            return parameter;
        }
        return null;
    }

    public List getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public static class Parameter {
        protected String name;
        protected String prompt;
        protected boolean persistant;
        protected Object owner;

        public Parameter(String string, String string2, boolean bl) {
            this.name = string;
            this.prompt = string2;
            this.persistant = bl;
        }

        public Object getOwner() {
            return this.owner;
        }

        public void setOwner(Object object) {
            this.owner = object;
        }

        public String getName() {
            return this.name;
        }

        public String getPrompt() {
            return this.prompt;
        }

        public boolean isPersistant() {
            return this.persistant;
        }

        public Object getValue() {
            return PropertyUtils.getProperty(this.getOwner(), this.getName());
        }

        public void setValue(Object object) {
            PropertyUtils.setProperty(this.getOwner(), this.getName(), object);
        }
    }
}

