/*
 * Decompiled with CFR 0.152.
 */
package jtp.ui.cmd;

import jtp.Reasoner;
import jtp.context.BasicReasoningContext;
import jtp.disp.DispatcherUtils;
import jtp.ui.cmd.Command;

public class AddReasonerCommand
extends Command {
    BasicReasoningContext ctx;
    public static final String REASONER = "reasoner";
    Class reasoner;
    public static final String REASONER_TYPE = "reasonerType";
    public static final int ASKING = 0;
    public static final int TELLING = 1;
    int reasonerType = 0;

    public void setReasoner(Class clazz) {
        this.reasoner = clazz;
    }

    public Class getReasoner() {
        return this.reasoner;
    }

    public void setReasonerType(int n) {
        this.reasonerType = n;
    }

    public int getReasonerType() {
        return this.reasonerType;
    }

    public AddReasonerCommand(BasicReasoningContext basicReasoningContext) {
        super("add-reasoner");
        this.ctx = basicReasoningContext;
        this.setDescription("Add a new reasoner to the system. You will be prompted to enter the full class name (including package) of a Reasoner class. The Reasoner class must have a no-argument constructor which will be used to create an instance of the Reasoner class and install it in the specified dispatcher.");
        this.addParameter(new ReasonerParameter());
        this.addParameter(new ReasonerTypeParameter());
    }

    public void execute() {
        try {
            Reasoner reasoner = (Reasoner)this.getReasoner().newInstance();
            switch (this.getReasonerType()) {
                case 0: {
                    DispatcherUtils.addToDispatcher(reasoner, this.ctx.getAskingDispatcher());
                    break;
                }
                case 1: {
                    DispatcherUtils.addToDispatcher(reasoner, this.ctx.getTellingDispatcher());
                }
            }
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    class ReasonerTypeParameter
    extends Command.Parameter {
        ReasonerTypeParameter() {
            super(AddReasonerCommand.REASONER_TYPE, "Enter reasoner type:", false);
        }

        public Object getValue() {
            return new Integer(AddReasonerCommand.this.getReasonerType());
        }

        public void setValue(Object object) {
            String string = String.valueOf(object);
            int n = -1;
            try {
                n = Integer.parseInt(string) - 1;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException();
            }
            if (n < 0 || n > 1) {
                throw new IllegalArgumentException();
            }
            AddReasonerCommand.this.setReasonerType(n);
        }

        public String getPrompt() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.getPrompt());
            stringBuffer.append("\n    1. Asking\n");
            stringBuffer.append("    2. Telling\n");
            stringBuffer.append("Enter your selection:");
            return stringBuffer.toString();
        }
    }

    class ReasonerParameter
    extends Command.Parameter {
        ReasonerParameter() {
            super(AddReasonerCommand.REASONER, "Enter Reasoner class name, including package (e.g., jtp.func.Greater):", false);
        }

        public Object getValue() {
            return AddReasonerCommand.this.getReasoner();
        }

        public void setValue(Object object) {
            String string = String.valueOf(object);
            try {
                AddReasonerCommand.this.setReasoner(Class.forName(string));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException);
            }
        }
    }
}

