/*
 * Decompiled with CFR 0.152.
 */
package jtp.ui;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import jtp.ReasoningException;
import jtp.context.rdf.RDFReasoningContext;
import jtp.fol.parser.FirstOrderLogicParser;
import jtp.fol.parser.ParsingException;
import jtp.fol.rdf.RDFParser;
import jtp.ui.RDFQueryUtils;
import jtp.ui.cmd.AskCommand;
import jtp.ui.cmd.Command;
import jtp.ui.cmd.InconsistenciesCheckCommand;
import jtp.ui.cmd.LoadKBCommand;
import jtp.ui.cmd.ReasoningContextConsole;
import jtp.undo.Snapshot;
import jtp.undo.SnapshotUndoManager;

public class RDFQueryAnswerer
extends ReasoningContextConsole {
    Stack kbStack = new Stack();
    Stack checkpointStack = new Stack();

    public RDFQueryAnswerer() throws MalformedURLException, IOException, ReasoningException {
        this(new RDFReasoningContext());
    }

    public RDFQueryAnswerer(RDFReasoningContext rDFReasoningContext) throws MalformedURLException, IOException, ReasoningException {
        this(rDFReasoningContext, (Reader)new InputStreamReader(System.in), (Writer)new OutputStreamWriter(System.out));
    }

    public RDFQueryAnswerer(Reader reader, Writer writer) throws MalformedURLException, IOException, ReasoningException {
        this(new RDFReasoningContext(), reader, writer);
    }

    public RDFQueryAnswerer(RDFReasoningContext rDFReasoningContext, Reader reader, Writer writer) throws MalformedURLException, IOException, ReasoningException {
        super(rDFReasoningContext, reader, writer);
        this.message("Setting up...");
        rDFReasoningContext.setUp();
        this.kifParser = rDFReasoningContext.getKifParser();
        this.kifParser.setCaseSensitiveSymbols(true);
    }

    public void setUp() {
        super.setUp();
        this.parsers.put("RDF", new RDFParser());
        this.kifParser.addNamespaceMapping("owl", "http://www.w3.org/2002/07/owl#");
        this.kifParser.addNamespaceMapping("daml", "http://www.daml.org/2001/03/daml+oil#");
        this.kifParser.addNamespaceMapping("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.kifParser.addNamespaceMapping("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        CheckpointLoadKB checkpointLoadKB = new CheckpointLoadKB("load-kif", "Load a KIF KB");
        checkpointLoadKB.setDescription("You will be prompted for a URL to load a KIF KB from. The triples that are being processed from the KB will be printed as they are loaded.");
        checkpointLoadKB.setParser((FirstOrderLogicParser)this.parsers.get("KIF"));
        this.addCommand(checkpointLoadKB);
        CheckpointLoadKB checkpointLoadKB2 = new CheckpointLoadKB("load-kb", "Load an RDF KB"){

            protected void doLoad(URL uRL, URL uRL2) throws ReasoningException, IOException {
                Model model = ModelFactory.createDefaultModel();
                try {
                    model.read((Reader)new BufferedReader(new InputStreamReader(uRL.openStream())), uRL2.toString());
                    ((RDFReasoningContext)RDFQueryAnswerer.this.ctx).loadRDFKB(model, uRL2);
                    HashMap hashMap = new HashMap();
                    RDFQueryUtils.addNamespaceMappingsFromKb(uRL2.toString(), model, hashMap);
                    Iterator iterator = hashMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        RDFQueryAnswerer.this.kifParser.addNamespaceMapping((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                catch (RDFException rDFException) {
                    throw new ParsingException(rDFException);
                }
            }
        };
        checkpointLoadKB2.setDescription("You will be prompted for a URL to load an RDF KB from. You will also be prompted for the base URI of the KB. If you enter a base URI, it will be used to resolve the names of objects in the document according to RDF rules. If you do not enter a base URI, the location that the KB is loaded from will be used to resolve names.");
        checkpointLoadKB2.setParser((FirstOrderLogicParser)this.parsers.get("RDF"));
        this.addCommand(checkpointLoadKB2);
        this.addCommand(new InconsistenciesCheckCommand((RDFReasoningContext)this.ctx, (AskCommand)this.commands.get("ask")));
        CreateCheckpoint createCheckpoint = new CreateCheckpoint();
        this.addCommand(createCheckpoint);
        createCheckpoint.execute();
        this.addCommand(new RevertToCheckpoint());
    }

    public static void main(String[] stringArray) throws Exception {
        RDFQueryAnswerer rDFQueryAnswerer = new RDFQueryAnswerer();
        rDFQueryAnswerer.setUp();
        Command command = (Command)rDFQueryAnswerer.commands.get("help");
        command.execute();
        if (System.getProperty("jtp.fol.rdf.RDFParser.printDebugTriples") == null) {
            System.setProperty("jtp.fol.rdf.RDFParser.printDebugTriples", "true");
        }
        rDFQueryAnswerer.run();
        System.exit(0);
    }

    protected static class StackEdit
    extends AbstractUndoableEdit {
        List stack;
        Object top;

        public StackEdit(Stack stack, Object object) {
            this.stack = stack;
            this.top = object;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.stack.remove(this.stack.size() - 1);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.stack.add(this.top);
        }
    }

    public class RevertToCheckpoint
    extends Command {
        Snapshot checkpoint;

        public Snapshot getCheckpoint() {
            return this.checkpoint;
        }

        public void setCheckpoint(Snapshot snapshot) {
            this.checkpoint = snapshot;
        }

        public RevertToCheckpoint() {
            super("revert", "Revert to a checkpoint");
            this.setDescription("Choose a previously saved checkpoint to revert to.");
        }

        public void prepare() {
            super.prepare();
            ArrayList<String> arrayList = new ArrayList<String>(RDFQueryAnswerer.this.checkpointStack.size() + 1);
            arrayList.addAll(RDFQueryAnswerer.this.checkpointStack);
            arrayList.add("(cancel)");
            int n = RDFQueryAnswerer.this.promptFor("Available checkpoints:\n", arrayList, -1);
            if (n >= 0 && n < RDFQueryAnswerer.this.checkpointStack.size()) {
                this.setCheckpoint((Snapshot)RDFQueryAnswerer.this.checkpointStack.get(n));
            } else {
                this.setCheckpoint(null);
            }
        }

        public void execute() {
            if (this.getCheckpoint() == null) {
                return;
            }
            ((SnapshotUndoManager)RDFQueryAnswerer.this.ctx.getUndoManager()).revertToSnapshot(this.getCheckpoint());
            RDFQueryAnswerer.this.checkpointStack.add(this.getCheckpoint());
            if (RDFQueryAnswerer.this.ctx.getUndoManager() != null) {
                RDFQueryAnswerer.this.ctx.getUndoManager().addEdit(new StackEdit(RDFQueryAnswerer.this.checkpointStack, this.getCheckpoint()));
            }
        }
    }

    public class CreateCheckpoint
    extends Command {
        CreateCheckpoint() {
            super("checkpoint", "Create checkpoint");
            this.setDescription("Creates a checkpoint that you can revert to. E.g., you can load kb1, save a checkpoint, load kb2, ask queries, and then revert to the checkpoint after kb1. All of the triples in kb2 and their consequences will be affectively unasserted. When you initially start the program, a checkpoint is created.");
        }

        public void execute() {
            Snapshot snapshot = ((SnapshotUndoManager)RDFQueryAnswerer.this.ctx.getUndoManager()).getSnapshot();
            switch (RDFQueryAnswerer.this.kbStack.size()) {
                case 0: {
                    snapshot.setDescription("No KBs are loaded.");
                    break;
                }
                case 1: {
                    snapshot.setDescription("KB " + RDFQueryAnswerer.this.kbStack.peek() + " is loaded.");
                    break;
                }
                default: {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("KBs ").append(RDFQueryAnswerer.this.kbStack.get(0));
                    int n = 1;
                    while (n < RDFQueryAnswerer.this.kbStack.size() - 1) {
                        stringBuffer.append(", ").append(RDFQueryAnswerer.this.kbStack.get(n));
                        ++n;
                    }
                    stringBuffer.append(" and ").append(RDFQueryAnswerer.this.kbStack.peek());
                    snapshot.setDescription(stringBuffer.toString());
                }
            }
            RDFQueryAnswerer.this.checkpointStack.add(snapshot);
            if (RDFQueryAnswerer.this.ctx.getUndoManager() != null) {
                RDFQueryAnswerer.this.ctx.getUndoManager().addEdit(new StackEdit(RDFQueryAnswerer.this.checkpointStack, snapshot));
            }
            this.getIo().message("Checkpoint created.");
        }
    }

    public class CheckpointLoadKB
    extends LoadKBCommand {
        public CheckpointLoadKB(String string, String string2) {
            super(RDFQueryAnswerer.this.ctx, string, string2);
        }

        public void execute() throws IOException, ReasoningException {
            super.execute();
            RDFQueryAnswerer.this.kbStack.add(this.getLocation());
            if (RDFQueryAnswerer.this.ctx.getUndoManager() != null) {
                RDFQueryAnswerer.this.ctx.getUndoManager().addEdit(new StackEdit(RDFQueryAnswerer.this.kbStack, this.getLocation()));
            }
        }
    }
}

