/*
 * Decompiled with CFR 0.152.
 */
package jtp.time.tp;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import jtp.time.tlgraph.Node;
import jtp.time.tp.TimePoint;

public class CalendarTimePoint
extends TimePoint
implements Comparable {
    protected static TreeMap points = new TreeMap();
    protected DateFormat format = new SimpleDateFormat("EEEE-MMMM-d-yyyy-h.mm.ss.SSS-a-z");
    Calendar calendar;
    public static final int[] calendarFields = new int[]{0, 1, 2, 5, 11, 12, 13, 14};

    public Calendar getCalendar() {
        return this.calendar;
    }

    public static void reset() {
        points.clear();
    }

    public static CalendarTimePoint getInstance(Calendar calendar, CalendarTimePoint[] calendarTimePointArray) {
        CalendarTimePoint calendarTimePoint;
        CalendarTimePoint calendarTimePoint2 = new CalendarTimePoint(calendar);
        if (!calendar.isSet(0)) {
            calendar.set(0, 1);
        }
        if ((calendarTimePoint = (CalendarTimePoint)points.get(calendarTimePoint2)) != null && calendarTimePoint.equalGranularity(calendarTimePoint2)) {
            return calendarTimePoint;
        }
        new Node().addTimePoint(calendarTimePoint2);
        points.put(calendarTimePoint2, calendarTimePoint2);
        calendarTimePointArray[0] = calendarTimePoint2.getCalendarTimePointBefore();
        calendarTimePointArray[1] = calendarTimePoint2.getCalendarTimePointAfter();
        calendarTimePoint2.format.setTimeZone(calendar.getTimeZone());
        return calendarTimePoint2;
    }

    public static CalendarTimePoint getInstance(int n, int n2, int n3, int n4, int n5, int n6, CalendarTimePoint[] calendarTimePointArray) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n2 - 1, n3, n4, n5, n6);
        return CalendarTimePoint.getInstance(gregorianCalendar, calendarTimePointArray);
    }

    public static CalendarTimePoint getInstance(int n, int n2, int n3, int n4, int n5, int n6, int n7, CalendarTimePoint[] calendarTimePointArray) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n2 - 1, n3, n4, n5, n6);
        gregorianCalendar.set(14, n7);
        return CalendarTimePoint.getInstance(gregorianCalendar, calendarTimePointArray);
    }

    public static CalendarTimePoint getInstance(int n, int n2, int n3, int n4, int n5, int n6, int n7, TimeZone timeZone, CalendarTimePoint[] calendarTimePointArray) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n2 - 1, n3, n4, n5, n6);
        gregorianCalendar.set(14, n7);
        ((Calendar)gregorianCalendar).setTimeZone(timeZone);
        return CalendarTimePoint.getInstance(gregorianCalendar, calendarTimePointArray);
    }

    public static CalendarTimePoint getInstance(long l, CalendarTimePoint[] calendarTimePointArray) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(new Date(l));
        return CalendarTimePoint.getInstance(gregorianCalendar, calendarTimePointArray);
    }

    protected boolean equalGranularity(CalendarTimePoint calendarTimePoint) {
        Calendar calendar = this.getCalendar();
        Calendar calendar2 = calendarTimePoint.getCalendar();
        int n = 0;
        while (n < calendarFields.length) {
            if (calendar.isSet(calendarFields[n]) != calendar2.isSet(calendarFields[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected CalendarTimePoint getCalendarTimePointBefore() {
        int n = this.getLargestUnsetField();
        Calendar calendar = (Calendar)this.getCalendar().clone();
        calendar.add(n, -1);
        SortedMap sortedMap = points.headMap(new CalendarTimePoint(calendar));
        if (!sortedMap.isEmpty()) {
            return sortedMap.lastKey();
        }
        return null;
    }

    protected CalendarTimePoint getCalendarTimePointAfter() {
        int n = this.getSmallestSetField();
        Calendar calendar = (Calendar)this.getCalendar().clone();
        calendar.add(n, 1);
        SortedMap sortedMap = points.tailMap(new CalendarTimePoint(calendar));
        if (!sortedMap.isEmpty()) {
            return sortedMap.firstKey();
        }
        return null;
    }

    protected int getLargestUnsetField() {
        int n = 0;
        while (n < calendarFields.length) {
            if (!this.calendar.isSet(calendarFields[n])) {
                return calendarFields[n];
            }
            ++n;
        }
        return 14;
    }

    protected int getSmallestSetField() {
        int n = 0;
        while (n < calendarFields.length) {
            if (!this.calendar.isSet(calendarFields[n])) {
                return calendarFields[n - 1];
            }
            ++n;
        }
        return 14;
    }

    private CalendarTimePoint(Calendar calendar) {
        this.calendar = calendar;
    }

    public int compareTo(Object object) {
        long l;
        CalendarTimePoint calendarTimePoint = (CalendarTimePoint)object;
        long l2 = this.getCalendar().getTimeInMillis();
        return l2 < (l = calendarTimePoint.getCalendar().getTimeInMillis()) ? -1 : (l2 == l ? 0 : 1);
    }

    public String toString() {
        return this.format.format(this.getCalendar().getTime());
    }
}

