/*
 * Decompiled with CFR 0.152.
 */
package jtp.time.tlgraph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import jtp.DirectAssertion;
import jtp.InconsistencyException;
import jtp.ReasoningException;
import jtp.ReasoningStep;
import jtp.demod.DemodulationReasoningStep;
import jtp.fol.DefaultLiteral;
import jtp.fol.Literal;
import jtp.time.TimePointKnowledgeStore;
import jtp.time.tlgraph.Node;
import jtp.time.tlgraph.Relations;
import jtp.time.tp.CalendarTimePoint;
import jtp.time.tp.TimePoint;
import jtp.util.ArrayMap;

public class TLGraph {
    Node visits = null;
    protected transient Map history = new HashMap(20);
    protected transient Map predecessor = new HashMap(20);
    TimePointKnowledgeStore ks;
    transient UndoManager undoManager;
    static final Byte PARTIAL = new Byte(0);
    static final Byte COMPLETE = new Byte(1);
    static final Byte WHITE = null;
    static final Byte LIGHT_GRAY = PARTIAL;
    static final Byte GRAY = COMPLETE;

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public void setUndoManager(UndoManager undoManager) {
        this.undoManager = undoManager;
    }

    public TLGraph() {
    }

    public TLGraph(TimePointKnowledgeStore timePointKnowledgeStore) {
        this.ks = timePointKnowledgeStore;
    }

    public byte query(TimePoint timePoint, TimePoint timePoint2) {
        return this.query(timePoint.getNode(), timePoint2.getNode());
    }

    public byte query(Node node, Node node2) {
        byte by = this.queryRelation(node, node2);
        this.detraceVisits();
        return by;
    }

    public CalendarTimePoint getMaximumBeforeOrEqualLocation(TimePoint timePoint) {
        long l = Long.MIN_VALUE;
        CalendarTimePoint calendarTimePoint = null;
        Collection collection = this.getAllPointsBeforeOrEqual(timePoint);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            CalendarTimePoint calendarTimePoint2;
            long l2;
            Object e = iterator.next();
            if (!(e instanceof CalendarTimePoint) || (l2 = (calendarTimePoint2 = (CalendarTimePoint)e).getCalendar().getTimeInMillis()) <= l) continue;
            l = l2;
            calendarTimePoint = calendarTimePoint2;
        }
        return calendarTimePoint;
    }

    public CalendarTimePoint getMinimumAfterOrEqualLocation(TimePoint timePoint) {
        long l = Long.MAX_VALUE;
        CalendarTimePoint calendarTimePoint = null;
        Collection collection = this.getAllPointsAfterOrEqual(timePoint);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            CalendarTimePoint calendarTimePoint2;
            long l2;
            Object e = iterator.next();
            if (!(e instanceof CalendarTimePoint) || (l2 = (calendarTimePoint2 = (CalendarTimePoint)e).getCalendar().getTimeInMillis()) >= l) continue;
            l = l2;
            calendarTimePoint = calendarTimePoint2;
        }
        return calendarTimePoint;
    }

    public Collection getAllPointsAfter(TimePoint timePoint) {
        return this.getAllPointsAfter(timePoint, Integer.MAX_VALUE);
    }

    public Collection getAllPointsAfterOrEqual(TimePoint timePoint) {
        return this.getAllPointsAfterOrEqual(timePoint, Integer.MAX_VALUE);
    }

    public Collection getAllPointsBefore(TimePoint timePoint) {
        return this.getAllPointsBefore(timePoint, Integer.MAX_VALUE);
    }

    public Collection getAllPointsBeforeOrEqual(TimePoint timePoint) {
        return this.getAllPointsBeforeOrEqual(timePoint, Integer.MAX_VALUE);
    }

    public Collection getAllPointsAfter(TimePoint timePoint, int n) {
        Node node = timePoint.getNode();
        Collection collection = this.getAllNodesAfter(node, 0, n);
        this.history.clear();
        LinkedList linkedList = new LinkedList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            linkedList.addAll(((Node)iterator.next()).timePoints.keySet());
        }
        return linkedList;
    }

    public Collection getAllPointsAfterOrEqual(TimePoint timePoint, int n) {
        Node node = timePoint.getNode();
        Collection collection = this.getAllNodesAfterOrEqual(node, 0, n);
        this.history.clear();
        LinkedList linkedList = new LinkedList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            linkedList.addAll(((Node)iterator.next()).timePoints.keySet());
        }
        return linkedList;
    }

    public Collection getAllPointsBefore(TimePoint timePoint, int n) {
        Node node = timePoint.getNode();
        Collection collection = this.getAllNodesBefore(node, 0, n);
        this.history.clear();
        LinkedList linkedList = new LinkedList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            linkedList.addAll(((Node)iterator.next()).timePoints.keySet());
        }
        return linkedList;
    }

    public Collection getAllPointsBeforeOrEqual(TimePoint timePoint, int n) {
        Node node = timePoint.getNode();
        Collection collection = this.getAllNodesBeforeOrEqual(node, 0, n);
        this.history.clear();
        LinkedList linkedList = new LinkedList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            linkedList.addAll(((Node)iterator.next()).timePoints.keySet());
        }
        return linkedList;
    }

    public Collection getAllPointsEqual(TimePoint timePoint) {
        return new ArrayList(timePoint.getNode().timePoints.keySet());
    }

    public void update(TimePoint timePoint, byte by, TimePoint timePoint2) throws ReasoningException {
        this.update(timePoint, by, timePoint2, null);
    }

    public void update(TimePoint timePoint, byte by, TimePoint timePoint2, ReasoningStep reasoningStep) throws ReasoningException {
        Node node;
        Node node2 = timePoint.getNode();
        byte by2 = this.queryRelation(node2, node = timePoint2.getNode());
        if (!Relations.consistent(by2, by)) {
            this.detraceVisits();
            throw new InconsistencyException("The proposed relation '" + Relations.toString(by) + "' between " + timePoint + " and " + timePoint2 + " is not consistent with their current relation '" + Relations.toString(by2) + '\'');
        }
        if (Relations.entails(by2, by)) {
            this.detraceVisits();
        } else if (2 == Relations.intersect(by2, by)) {
            if (2 == by) {
                this.insertEqualEdge(node2, node, this.getCycle(this.visits), reasoningStep);
            } else {
                this.insertEqualEdge(node2, node, this.getCycle(this.visits), null);
            }
        } else {
            if (Relations.entails(by, by2)) {
                this.put(node2, by, node, reasoningStep);
            } else {
                this.put(node2, Relations.intersect(by2, by), node, null);
            }
            this.detraceVisits();
        }
    }

    Collection getAllNodesAfter(Node node, int n, int n2) {
        if (n > n2 || node.isSink() || this.history.get(node) != null) {
            return Collections.EMPTY_LIST;
        }
        this.history.put(node, PARTIAL);
        ++n;
        LinkedList linkedList = null;
        Iterator iterator = node.afterChildren.keySet().iterator();
        if (iterator.hasNext()) {
            linkedList = new LinkedList();
        }
        while (iterator.hasNext()) {
            linkedList.addAll(this.getAllNodesAfterOrEqual((Node)iterator.next(), n, n2));
        }
        iterator = node.afterOrEqlChildren.keySet().iterator();
        while (iterator.hasNext()) {
            Collection collection = this.getAllNodesAfter((Node)iterator.next(), n, n2);
            if (collection.isEmpty()) continue;
            if (linkedList == null) {
                linkedList = new LinkedList();
            }
            linkedList.addAll(collection);
        }
        if (linkedList == null) {
            return Collections.EMPTY_LIST;
        }
        return linkedList;
    }

    Collection getAllNodesAfterOrEqual(Node node, int n, int n2) {
        Object v = this.history.get(node);
        if (n > n2 || v == COMPLETE) {
            return Collections.EMPTY_LIST;
        }
        ++n;
        this.history.put(node, COMPLETE);
        LinkedList<Node> linkedList = new LinkedList<Node>();
        linkedList.add(node);
        if (v == null) {
            Iterator iterator = node.afterChildren.keySet().iterator();
            while (iterator.hasNext()) {
                linkedList.addAll(this.getAllNodesAfterOrEqual((Node)iterator.next(), n, n2));
            }
        }
        Iterator iterator = node.afterOrEqlChildren.keySet().iterator();
        while (iterator.hasNext()) {
            linkedList.addAll(this.getAllNodesAfterOrEqual((Node)iterator.next(), n, n2));
        }
        return linkedList;
    }

    Collection getAllNodesBefore(Node node, int n, int n2) {
        if (n > n2 || node.isSource() || this.history.get(node) != null) {
            return Collections.EMPTY_LIST;
        }
        this.history.put(node, PARTIAL);
        ++n;
        LinkedList linkedList = null;
        Iterator iterator = node.beforeChildren.keySet().iterator();
        if (iterator.hasNext()) {
            linkedList = new LinkedList();
        }
        while (iterator.hasNext()) {
            linkedList.addAll(this.getAllNodesBeforeOrEqual((Node)iterator.next(), n, n2));
        }
        iterator = node.beforeOrEqlChildren.keySet().iterator();
        while (iterator.hasNext()) {
            Collection collection = this.getAllNodesBefore((Node)iterator.next(), n, n2);
            if (collection.isEmpty()) continue;
            if (linkedList == null) {
                linkedList = new LinkedList();
            }
            linkedList.addAll(collection);
        }
        if (linkedList == null) {
            return Collections.EMPTY_LIST;
        }
        return linkedList;
    }

    Collection getAllNodesBeforeOrEqual(Node node, int n, int n2) {
        Object v = this.history.get(node);
        if (n > n2 || v == COMPLETE) {
            return Collections.EMPTY_LIST;
        }
        ++n;
        this.history.put(node, COMPLETE);
        LinkedList<Node> linkedList = new LinkedList<Node>();
        linkedList.add(node);
        if (v == null) {
            Iterator iterator = node.beforeChildren.keySet().iterator();
            while (iterator.hasNext()) {
                linkedList.addAll(this.getAllNodesBeforeOrEqual((Node)iterator.next(), n, n2));
            }
        }
        Iterator iterator = node.beforeOrEqlChildren.keySet().iterator();
        while (iterator.hasNext()) {
            linkedList.addAll(this.getAllNodesBeforeOrEqual((Node)iterator.next(), n, n2));
        }
        return linkedList;
    }

    void put(Node node, byte by, Node node2, ReasoningStep reasoningStep) {
        switch (by) {
            case 3: {
                node.addAfterOrEqualChild(node2, reasoningStep);
                break;
            }
            case 1: {
                node.addAfterChild(node2, reasoningStep);
                break;
            }
            case 6: {
                if (reasoningStep != null && this.ks != null) {
                    reasoningStep = this.ks.getPointRelationInverseReasoningStep(reasoningStep);
                }
                node2.addAfterOrEqualChild(node, reasoningStep);
                break;
            }
            case 4: {
                if (reasoningStep != null && this.ks != null) {
                    reasoningStep = this.ks.getPointRelationInverseReasoningStep(reasoningStep);
                }
                node2.addAfterChild(node, reasoningStep);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid relation: " + Relations.toString(by));
            }
        }
        if (this.undoManager != null) {
            this.undoManager.addEdit(new UndoPut(node, by, node2));
        }
    }

    void insertEqualEdge(Node node, Node node2, Collection collection, ReasoningStep reasoningStep) {
        if (collection != null && !collection.isEmpty()) {
            this.collapseCycle(collection, reasoningStep);
        } else {
            this.collapseCycle(Arrays.asList(node, node2), reasoningStep);
        }
    }

    void collapseCycle(Collection collection, ReasoningStep reasoningStep) {
        Object object;
        Iterator iterator;
        Iterator iterator2;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Iterator iterator3;
        Object object6;
        Node node = new Node();
        Iterator iterator4 = collection.iterator();
        while (iterator4.hasNext()) {
            object6 = (Node)iterator4.next();
            iterator3 = ((Node)object6).timePoints.entrySet().iterator();
            while (iterator3.hasNext()) {
                object5 = iterator3.next();
                object4 = (TimePoint)object5.getKey();
                node.addTimePoint((TimePoint)object4);
                object3 = (Map)object5.getValue();
                if (object3 != null) {
                    node.addEqualityMap((TimePoint)object4, (Map)object3);
                }
                node.addEqualReasoningStep((TimePoint)object4, reasoningStep);
            }
        }
        object6 = collection.iterator();
        while (object6.hasNext()) {
            ((Node)object6.next()).marked = true;
        }
        iterator3 = collection.iterator();
        while (iterator3.hasNext()) {
            object5 = (Node)((Object)iterator3.next());
            object4 = ((Node)object5).afterChildren.entrySet().iterator();
            while (object4.hasNext()) {
                object3 = (Map.Entry)object4.next();
                object2 = (Node)object3.getKey();
                if (!((Node)object2).marked) {
                    ((Node)object2).marked = true;
                    node.addAfterChild((Node)object2, (ReasoningStep)object3.getValue());
                }
                ((Node)object2).beforeChildren.remove(object5);
            }
        }
        object5 = collection.iterator();
        while (object5.hasNext()) {
            object4 = (Node)object5.next();
            object3 = ((Node)object4).afterOrEqlChildren.entrySet().iterator();
            while (object3.hasNext()) {
                object2 = (Map.Entry)object3.next();
                iterator2 = (Node)object2.getKey();
                if (!((Node)((Object)iterator2)).marked) {
                    ((Node)((Object)iterator2)).marked = true;
                    node.addAfterOrEqualChild((Node)((Object)iterator2), (ReasoningStep)object2.getValue());
                }
                ((Node)((Object)iterator2)).beforeOrEqlChildren.remove(object4);
            }
        }
        object4 = collection.iterator();
        while (object4.hasNext()) {
            object3 = (Node)object4.next();
            object2 = ((Node)object3).beforeChildren.entrySet().iterator();
            while (object2.hasNext()) {
                iterator2 = (Map.Entry)object2.next();
                iterator = (Node)iterator2.getKey();
                if (!((Node)((Object)iterator)).marked) {
                    ((Node)((Object)iterator)).marked = true;
                    ((Node)((Object)iterator)).addAfterChild(node, (ReasoningStep)iterator2.getValue());
                }
                ((Node)((Object)iterator)).afterChildren.remove(object3);
            }
        }
        object3 = collection.iterator();
        while (object3.hasNext()) {
            object2 = (Node)object3.next();
            iterator2 = ((Node)object2).beforeOrEqlChildren.entrySet().iterator();
            while (iterator2.hasNext()) {
                iterator = (Map.Entry)iterator2.next();
                object = (Node)iterator.getKey();
                if (!((Node)object).marked) {
                    ((Node)object).marked = true;
                    ((Node)object).addAfterOrEqualChild(node, (ReasoningStep)iterator.getValue());
                }
                ((Node)object).afterOrEqlChildren.remove(object2);
            }
        }
        object2 = collection.iterator();
        while (object2.hasNext()) {
            ((Node)object2.next()).marked = false;
        }
        iterator2 = node.afterChildren.keySet().iterator();
        while (iterator2.hasNext()) {
            ((Node)iterator2.next()).marked = false;
        }
        iterator = node.afterOrEqlChildren.keySet().iterator();
        while (iterator.hasNext()) {
            ((Node)iterator.next()).marked = false;
        }
        object = node.beforeChildren.keySet().iterator();
        while (object.hasNext()) {
            ((Node)object.next()).marked = false;
        }
        Iterator iterator5 = node.beforeOrEqlChildren.keySet().iterator();
        while (iterator5.hasNext()) {
            ((Node)iterator5.next()).marked = false;
        }
        if (this.undoManager != null) {
            this.undoManager.addEdit(new UndoEqual(node, collection));
        }
    }

    Collection getCycle(Node node) {
        if (node == null) {
            this.visits = null;
            return new LinkedList();
        }
        if (3 == node.curProp) {
            node.curProp = (byte)-1;
            Collection collection = this.getCycle(node.nextVisitor);
            collection.add(node);
            return collection;
        }
        node.curProp = (byte)-1;
        return this.getCycle(node.nextVisitor);
    }

    byte queryRelation(Node node, Node node2) {
        byte by = this.searchVisit(node, (byte)2, node2);
        if (by == 7) {
            by = this.searchAgain(node2, node);
        }
        return by;
    }

    byte searchAgain(Node node, Node node2) {
        this.visits = node2.nextVisitor;
        node2.curProp = (byte)-1;
        return Relations.inverse(this.searchVisit(node, (byte)2, node2));
    }

    byte searchVisit(Node node, byte by, Node node2) {
        if (node.curProp != -1) {
            return Relations.sequence(by, node.curProp);
        }
        if (node == node2) {
            this.traceNode(node, by);
            return by;
        }
        if (node.isSink()) {
            this.traceNode(node, (byte)7);
            return 7;
        }
        byte by2 = this.searchPast(node, by, node2);
        this.traceNode(node, by2);
        return by2;
    }

    byte searchPast(Node node, byte by, Node node2) {
        if (1 == this.searchAll(node.afterChildren.keySet().iterator(), (byte)1, node2)) {
            return 1;
        }
        return this.searchAll(node.afterOrEqlChildren.keySet().iterator(), Relations.sequence(by, (byte)3), node2);
    }

    byte searchAll(Iterator iterator, byte by, Node node) {
        if (!iterator.hasNext()) {
            return 7;
        }
        Node node2 = (Node)iterator.next();
        byte by2 = this.searchVisit(node2, by, node);
        if (by2 == 1) {
            return 1;
        }
        return Relations.intersect(by2, this.searchAll(iterator, by, node));
    }

    void detraceVisits() {
        while (this.visits != null) {
            this.visits.curProp = (byte)-1;
            this.visits = this.visits.nextVisitor;
        }
    }

    void traceNode(Node node, byte by) {
        node.nextVisitor = this.visits;
        node.curProp = by;
        this.visits = node;
    }

    ReasoningStep proveEquality(TimePoint timePoint, TimePoint timePoint2, Node node) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (timePoint.equals(timePoint2)) {
            return new DirectAssertion((Object)new DefaultLiteral(this.ks.getRelationSymbol((byte)2), Arrays.asList(timePoint, timePoint2), true), "identity");
        }
        Map map = this.history;
        map.put(timePoint, GRAY);
        LinkedList<TimePoint> linkedList = new LinkedList<TimePoint>();
        linkedList.add(timePoint);
        while (!linkedList.isEmpty()) {
            object4 = linkedList.removeFirst();
            object3 = (Map)node.timePoints.get(object4);
            if (object3 == null) continue;
            object2 = object3.keySet().iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (map.get(object) != WHITE) continue;
                map.put(object, GRAY);
                this.predecessor.put(object, Arrays.asList(object4, object3.get(object)));
                linkedList.add((TimePoint)object);
            }
        }
        if (this.predecessor.get(timePoint2) == null) {
            return null;
        }
        object4 = new LinkedList();
        object3 = timePoint2;
        while (!object3.equals(timePoint)) {
            object2 = (List)this.predecessor.get(object3);
            object = object2.get(0);
            Object e = object2.get(1);
            if (e == null) {
                ((LinkedList)object4).addFirst(new DirectAssertion((Object)new DefaultLiteral(this.ks.getRelationSymbol((byte)2), Arrays.asList(object, object3), true), "temporally-labeled graph unable to produce complete proof"));
            } else {
                ((LinkedList)object4).addFirst(e);
            }
            object3 = object;
        }
        map.clear();
        this.predecessor.clear();
        if (((LinkedList)object4).size() == 1) {
            return (ReasoningStep)((LinkedList)object4).get(0);
        }
        return this.ks.getPointEqualityReasoningStep(timePoint, timePoint2, (List)object4);
    }

    public ReasoningStep proveRelation(TimePoint timePoint, TimePoint timePoint2, byte by) {
        ReasoningStep reasoningStep;
        Object object;
        if (by == 2) {
            return this.proveEquality(timePoint, timePoint2, timePoint.getNode());
        }
        if (Relations.entails((byte)2, by) && timePoint.getNode().equals(timePoint2.getNode())) {
            return this.ks.getPointSubRelationReasoningStep(this.ks.getRelationSymbol((byte)2), this.ks.getRelationSymbol(by), this.proveEquality(timePoint, timePoint2, timePoint.getNode()));
        }
        boolean bl = false;
        if (by == 4 || by == 6) {
            bl = true;
            object = timePoint;
            timePoint = timePoint2;
            timePoint2 = object;
            by = Relations.inverse(by);
        }
        object = null;
        if (by == 1) {
            object = this.pathAfter(timePoint.getNode(), timePoint2.getNode());
        } else if (by == 3) {
            object = this.pathAfterOrEql(timePoint.getNode(), timePoint2.getNode());
        }
        DefaultLiteral defaultLiteral = new DefaultLiteral(this.ks.getRelationSymbol(by), Arrays.asList(timePoint, timePoint2), true);
        ArrayList<ReasoningStep> arrayList = new ArrayList<ReasoningStep>(object.size());
        TimePoint timePoint3 = timePoint;
        while (!object.isEmpty()) {
            reasoningStep = (ReasoningStep)object.remove(0);
            reasoningStep = this.createSubStep(timePoint3, reasoningStep);
            arrayList.add(reasoningStep);
            timePoint3 = (TimePoint)((Literal)reasoningStep.getGoal()).getArgs().get(1);
        }
        if (!timePoint2.equals(timePoint3)) {
            if (!timePoint2.getNode().equals(timePoint3.getNode())) {
                throw new RuntimeException("Final time points are not equal: " + timePoint2 + " and " + timePoint3);
            }
            reasoningStep = (ReasoningStep)arrayList.remove(arrayList.size() - 1);
            Literal literal = (Literal)reasoningStep.getGoal();
            ArrayList<ReasoningStep> arrayList2 = new ArrayList<ReasoningStep>(2);
            arrayList2.add(reasoningStep);
            arrayList2.add(this.proveEquality(timePoint3, timePoint2, timePoint2.getNode()));
            arrayList.add(new DemodulationReasoningStep((Object)new DefaultLiteral(literal.getRelation(), Arrays.asList(literal.getArgs().get(0), timePoint2), true), new ArrayMap(Collections.singletonList(timePoint3), Collections.singletonList(timePoint2)), arrayList2));
        }
        reasoningStep = null;
        reasoningStep = arrayList.size() == 1 ? (ReasoningStep)arrayList.get(0) : this.ks.getTimePointReasoningStep(defaultLiteral, arrayList);
        if (bl) {
            reasoningStep = this.ks.getPointRelationInverseReasoningStep(reasoningStep);
        }
        return reasoningStep;
    }

    ReasoningStep createSubStep(TimePoint timePoint, ReasoningStep reasoningStep) {
        Literal literal = (Literal)reasoningStep.getGoal();
        if (literal.getArgs().get(0).equals(timePoint)) {
            return reasoningStep;
        }
        TimePoint timePoint2 = (TimePoint)literal.getArgs().get(0);
        TimePoint timePoint3 = (TimePoint)literal.getArgs().get(1);
        if (!timePoint.getNode().equals(timePoint2.getNode())) {
            throw new RuntimeException("Points are not equal: " + timePoint + " and " + timePoint2);
        }
        ArrayList<ReasoningStep> arrayList = new ArrayList<ReasoningStep>(2);
        arrayList.add(this.proveEquality(timePoint, timePoint2, timePoint.getNode()));
        arrayList.add(reasoningStep);
        return new DemodulationReasoningStep((Object)new DefaultLiteral(literal.getRelation(), Arrays.asList(timePoint, timePoint3), true), new ArrayMap(Collections.singletonList(timePoint2), Collections.singletonList(timePoint)), arrayList);
    }

    List pathAfterOrEql(Node node, Node node2) {
        Map map = this.history;
        map.put(node, GRAY);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(node);
        while (!linkedList.isEmpty()) {
            Object k;
            Object object;
            Object object2;
            Object object3;
            Node node3 = (Node)linkedList.removeFirst();
            if (node3.equals(node2)) break;
            Iterator iterator = node3.afterChildren.keySet().iterator();
            while (iterator.hasNext()) {
                object3 = iterator.next();
                if (map.get(object3) != WHITE) continue;
                map.put(object3, GRAY);
                object2 = node3.afterChildren.get(object3);
                if (object2 == null) {
                    object = node3.timePoints.keySet().iterator().next();
                    k = ((Node)object3).timePoints.keySet().iterator().next();
                    object2 = new DirectAssertion((Object)new DefaultLiteral(this.ks.getRelationSymbol((byte)1), Arrays.asList(object, k), true), "temporally-labeled graph unable to produce complete proof");
                }
                this.predecessor.put(object3, Arrays.asList(node3, object2));
                linkedList.add(object3);
            }
            object3 = node3.afterOrEqlChildren.keySet().iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                if (map.get(object2) != WHITE) continue;
                map.put(object2, GRAY);
                object = node3.afterOrEqlChildren.get(object2);
                if (object == null) {
                    k = node3.timePoints.keySet().iterator().next();
                    Object k2 = ((Node)object2).timePoints.keySet().iterator().next();
                    object = new DirectAssertion((Object)new DefaultLiteral(this.ks.getRelationSymbol((byte)3), Arrays.asList(k, k2), true), "temporally-labeled graph unable to produce complete proof");
                }
                this.predecessor.put(object2, Arrays.asList(node3, object));
                linkedList.add(object2);
            }
        }
        map.clear();
        return this.getPath(node, node2);
    }

    List pathAfter(Node node, Node node2) {
        Map map = this.history;
        map.put(node, LIGHT_GRAY);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(node);
        while (!linkedList.isEmpty()) {
            Object k;
            Object object;
            Object object2;
            Object object3;
            Node node3 = (Node)linkedList.removeFirst();
            if (node3.equals(node2) && map.get(node3) == GRAY) break;
            Iterator iterator = node3.afterChildren.keySet().iterator();
            while (iterator.hasNext()) {
                object3 = iterator.next();
                if (map.get(object3) == GRAY) continue;
                map.put(object3, GRAY);
                object2 = node3.afterChildren.get(object3);
                if (object2 == null) {
                    object = node3.timePoints.keySet().iterator().next();
                    k = ((Node)object3).timePoints.keySet().iterator().next();
                    object2 = new DirectAssertion((Object)new DefaultLiteral(this.ks.getRelationSymbol((byte)1), Arrays.asList(object, k), true), "temporally-labeled graph unable to produce complete proof");
                }
                this.predecessor.put(object3, Arrays.asList(node3, object2));
                if (linkedList.contains(object3)) continue;
                linkedList.add(object3);
            }
            object3 = node3.afterOrEqlChildren.keySet().iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                if (map.get(object2) != WHITE) continue;
                map.put(object2, map.get(node3));
                object = node3.afterOrEqlChildren.get(object2);
                if (object == null) {
                    k = node3.timePoints.keySet().iterator().next();
                    Object k2 = ((Node)object2).timePoints.keySet().iterator().next();
                    object = new DirectAssertion((Object)new DefaultLiteral(this.ks.getRelationSymbol((byte)3), Arrays.asList(k, k2), true), "temporally-labeled graph unable to produce complete proof");
                }
                this.predecessor.put(object2, Arrays.asList(node3, object));
                linkedList.add(object2);
            }
        }
        map.clear();
        return this.getPath(node, node2);
    }

    List getPath(Node node, Node node2) {
        List list;
        LinkedList linkedList = new LinkedList();
        Node node3 = node2;
        while ((list = (List)this.predecessor.get(node3)) != null) {
            linkedList.addFirst(list.get(1));
            node3 = list.get(0);
        }
        this.predecessor.clear();
        return linkedList;
    }

    class UndoEqual
    extends AbstractUndoableEdit {
        Node newnode;
        Collection oldnodes;

        UndoEqual(Node node, Collection collection) {
            this.newnode = node;
            this.oldnodes = collection;
        }

        public void undo() throws CannotUndoException {
            Iterator iterator;
            Object object;
            Object object2;
            super.undo();
            Iterator iterator2 = this.newnode.afterChildren.keySet().iterator();
            while (iterator2.hasNext()) {
                ((Node)iterator2.next()).beforeChildren.remove(this.newnode);
            }
            Iterator iterator3 = this.newnode.afterOrEqlChildren.keySet().iterator();
            while (iterator3.hasNext()) {
                ((Node)iterator3.next()).beforeOrEqlChildren.remove(this.newnode);
            }
            Iterator iterator4 = this.newnode.beforeChildren.keySet().iterator();
            while (iterator4.hasNext()) {
                ((Node)iterator4.next()).afterChildren.remove(this.newnode);
            }
            Iterator iterator5 = this.newnode.beforeOrEqlChildren.keySet().iterator();
            while (iterator5.hasNext()) {
                ((Node)iterator5.next()).afterOrEqlChildren.remove(this.newnode);
            }
            Iterator iterator6 = this.oldnodes.iterator();
            while (iterator6.hasNext()) {
                Object object3;
                Object object4;
                Object object5;
                Iterator iterator7;
                object2 = (Node)iterator6.next();
                object = ((Node)object2).afterChildren.entrySet().iterator();
                while (object.hasNext()) {
                    iterator = (Map.Entry)object.next();
                    iterator7 = (Node)iterator.getKey();
                    object5 = (ReasoningStep)iterator.getValue();
                    ((Node)((Object)iterator7)).beforeChildren.put(object2, object5);
                }
                iterator = ((Node)object2).afterOrEqlChildren.entrySet().iterator();
                while (iterator.hasNext()) {
                    iterator7 = iterator.next();
                    object5 = (Node)iterator7.getKey();
                    object4 = (ReasoningStep)iterator7.getValue();
                    ((Node)object5).beforeOrEqlChildren.put(object2, object4);
                }
                iterator7 = ((Node)object2).beforeChildren.entrySet().iterator();
                while (iterator7.hasNext()) {
                    object5 = iterator7.next();
                    object4 = (Node)object5.getKey();
                    object3 = (ReasoningStep)object5.getValue();
                    ((Node)object4).afterChildren.put(object2, object3);
                }
                object5 = ((Node)object2).beforeOrEqlChildren.entrySet().iterator();
                while (object5.hasNext()) {
                    object4 = (Map.Entry)object5.next();
                    object3 = (Node)object4.getKey();
                    ReasoningStep reasoningStep = (ReasoningStep)object4.getValue();
                    ((Node)object3).afterOrEqlChildren.put(object2, reasoningStep);
                }
            }
            object2 = this.oldnodes.iterator();
            while (object2.hasNext()) {
                object = (Node)object2.next();
                iterator = ((Node)object).timePoints.keySet().iterator();
                while (iterator.hasNext()) {
                    ((TimePoint)((Object)iterator.next())).setNode((Node)object);
                }
            }
        }
    }

    class UndoPut
    extends AbstractUndoableEdit {
        Node n1;
        Node n2;
        byte relation;

        UndoPut(Node node, byte by, Node node2) {
            this.n1 = node;
            this.n2 = node2;
            this.relation = by;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            switch (this.relation) {
                case 3: {
                    this.n1.removeAfterOrEqualChild(this.n2);
                    break;
                }
                case 1: {
                    this.n1.removeAfterChild(this.n2);
                    break;
                }
                case 6: {
                    this.n2.removeAfterOrEqualChild(this.n1);
                    break;
                }
                case 4: {
                    this.n2.removeAfterChild(this.n1);
                    break;
                }
                default: {
                    throw new CannotUndoException();
                }
            }
        }
    }
}

