/*
 * Decompiled with CFR 0.152.
 */
package jtp.time.tlgraph;

import java.util.Map;
import jtp.ReasoningStep;
import jtp.fol.Literal;
import jtp.time.tp.TimePoint;
import jtp.util.ArrayMap;

public class Node {
    Map timePoints = new ArrayMap();
    Map afterChildren = new ArrayMap();
    Map afterOrEqlChildren = new ArrayMap();
    Map beforeChildren = new ArrayMap();
    Map beforeOrEqlChildren = new ArrayMap();
    Node nextVisitor = null;
    byte curProp = (byte)-1;
    boolean marked = false;

    public void addTimePoint(TimePoint timePoint) {
        this.timePoints.put(timePoint, null);
        timePoint.setNode(this);
    }

    public void addEqualReasoningStep(TimePoint timePoint, ReasoningStep reasoningStep) {
        if (!this.timePoints.containsKey(timePoint)) {
            throw new RuntimeException("Time point '" + timePoint + "' does not belong to node; cannot add equal reasoning step.");
        }
        Map map = (Map)this.timePoints.get(timePoint);
        if (map == null) {
            map = new ArrayMap();
            this.timePoints.put(timePoint, map);
        }
        if (reasoningStep != null) {
            Literal literal = (Literal)reasoningStep.getGoal();
            TimePoint timePoint2 = literal.getArgs().get(0).equals(timePoint) ? (TimePoint)literal.getArgs().get(1) : (TimePoint)literal.getArgs().get(0);
            map.put(timePoint2, reasoningStep);
        }
    }

    public void addEqualityMap(TimePoint timePoint, Map map) {
        if (!this.timePoints.containsKey(timePoint)) {
            throw new RuntimeException("Time point '" + timePoint + "' does not belong to node; cannot add equal reasoning step.");
        }
        Map map2 = (Map)this.timePoints.get(timePoint);
        if (map2 == null) {
            map2 = new ArrayMap();
            this.timePoints.put(timePoint, map2);
        }
        map2.putAll(map);
    }

    void addAfterChild(Node node) {
        this.addAfterChild(node, null);
    }

    void addAfterOrEqualChild(Node node) {
        this.addAfterOrEqualChild(node, null);
    }

    void addAfterChild(Node node, ReasoningStep reasoningStep) {
        this.afterChildren.put(node, reasoningStep);
        node.addBeforeChild(this, reasoningStep);
    }

    void addAfterOrEqualChild(Node node, ReasoningStep reasoningStep) {
        this.afterOrEqlChildren.put(node, reasoningStep);
        node.addBeforeOrEqualChild(this, reasoningStep);
    }

    void removeAfterChild(Node node) {
        this.afterChildren.remove(node);
        node.removeBeforeChild(this);
    }

    void removeAfterOrEqualChild(Node node) {
        this.afterOrEqlChildren.remove(node);
        node.removeBeforeOrEqualChild(this);
    }

    private void addBeforeChild(Node node, ReasoningStep reasoningStep) {
        this.beforeChildren.put(node, reasoningStep);
    }

    private void addBeforeOrEqualChild(Node node, ReasoningStep reasoningStep) {
        this.beforeOrEqlChildren.put(node, reasoningStep);
    }

    private void removeBeforeChild(Node node) {
        this.beforeChildren.remove(node);
    }

    private void removeBeforeOrEqualChild(Node node) {
        this.beforeOrEqlChildren.remove(node);
    }

    boolean isSink() {
        return this.afterChildren.isEmpty() && this.afterOrEqlChildren.isEmpty();
    }

    boolean isSource() {
        return this.beforeChildren.isEmpty() && this.beforeOrEqlChildren.isEmpty();
    }
}

