/*
 * Decompiled with CFR 0.152.
 */
package jtp.time.func;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import jtp.DirectAssertion;
import jtp.ReasoningException;
import jtp.demod.CanonicalMapping;
import jtp.fol.DefaultLiteral;
import jtp.fol.Symbol;
import jtp.time.func.TimePointFunctionReasoner;
import jtp.time.tlgraph.TLGraph;
import jtp.time.tp.CalendarTimePoint;
import jtp.time.vocab.TimeVocabulary;

public class PlusTimePoint
extends TimePointFunctionReasoner {
    TLGraph _tlg = new TLGraph();

    public PlusTimePoint(CanonicalMapping canonicalMapping, TimeVocabulary timeVocabulary) {
        super(Symbol.newSymbol("+"), 3, canonicalMapping, timeVocabulary);
    }

    protected Object calculate(Object[] objectArray) throws ReasoningException {
        if (!(objectArray[0] instanceof CalendarTimePoint) || !(objectArray[1] instanceof Number)) {
            return null;
        }
        CalendarTimePoint calendarTimePoint = (CalendarTimePoint)objectArray[0];
        Number number = (Number)objectArray[1];
        Calendar calendar = (Calendar)calendarTimePoint.getCalendar().clone();
        calendar.setTime(new Date(calendarTimePoint.getCalendar().getTimeInMillis() + number.longValue()));
        CalendarTimePoint[] calendarTimePointArray = new CalendarTimePoint[2];
        CalendarTimePoint calendarTimePoint2 = CalendarTimePoint.getInstance(calendar, calendarTimePointArray);
        this.addMetricPointToGraph(calendarTimePoint2, calendarTimePointArray);
        return calendarTimePoint2;
    }

    protected void addMetricPointToGraph(CalendarTimePoint calendarTimePoint, CalendarTimePoint[] calendarTimePointArray) throws ReasoningException {
        if (calendarTimePointArray[0] != null) {
            this._tlg.update(calendarTimePoint, (byte)4, calendarTimePointArray[0], new DirectAssertion((Object)new DefaultLiteral(this.tvocab.getAfterRelation(), Arrays.asList(calendarTimePoint, calendarTimePointArray[0]), true), "points on timeline"));
        }
        if (calendarTimePointArray[1] != null) {
            this._tlg.update(calendarTimePoint, (byte)1, calendarTimePointArray[1], new DirectAssertion((Object)new DefaultLiteral(this.tvocab.getBeforeRelation(), Arrays.asList(calendarTimePoint, calendarTimePointArray[1]), true), "points on timeline"));
        }
    }
}

