/*
 * Decompiled with CFR 0.152.
 */
package jtp.time.func;

import java.util.Arrays;
import java.util.Calendar;
import jtp.DirectAssertion;
import jtp.ReasoningException;
import jtp.demod.CanonicalMapping;
import jtp.fol.DefaultLiteral;
import jtp.fol.Symbol;
import jtp.time.func.TimePointFunctionReasoner;
import jtp.time.tlgraph.TLGraph;
import jtp.time.tp.CalendarTimePoint;
import jtp.time.vocab.TimeVocabulary;

public class FirstTimePoint
extends TimePointFunctionReasoner {
    TLGraph _tlg = new TLGraph();
    protected Symbol[] units = new Symbol[]{this.tvocab.getMonthFn(), this.tvocab.getDayFn(), this.tvocab.getHourFn(), this.tvocab.getMinuteFn(), this.tvocab.getSecondFn()};
    protected static final int[] calendarFields = new int[]{2, 5, 11, 12, 13, 14};
    protected static final int[] firstValues = new int[]{0, 1, 0, 0, 0, 0};

    public FirstTimePoint(CanonicalMapping canonicalMapping, TimeVocabulary timeVocabulary) {
        super(timeVocabulary.getFirstTimePointFn(), 3, canonicalMapping, timeVocabulary);
    }

    protected Object calculate(Object[] objectArray) throws ReasoningException {
        if (!(objectArray[0] instanceof CalendarTimePoint) || !(objectArray[1] instanceof Symbol)) {
            return null;
        }
        int n = 0;
        while (n < this.units.length) {
            if (this.units[n].equals(objectArray[1])) break;
            ++n;
        }
        if (n == this.units.length) {
            return null;
        }
        ++n;
        CalendarTimePoint calendarTimePoint = (CalendarTimePoint)objectArray[0];
        Calendar calendar = (Calendar)calendarTimePoint.getCalendar().clone();
        while (n < calendarFields.length) {
            calendar.set(calendarFields[n], firstValues[n]);
            ++n;
        }
        CalendarTimePoint[] calendarTimePointArray = new CalendarTimePoint[2];
        CalendarTimePoint calendarTimePoint2 = CalendarTimePoint.getInstance(calendar, calendarTimePointArray);
        this.addMetricPointToGraph(calendarTimePoint2, calendarTimePointArray);
        return calendarTimePoint2;
    }

    protected void addMetricPointToGraph(CalendarTimePoint calendarTimePoint, CalendarTimePoint[] calendarTimePointArray) throws ReasoningException {
        if (calendarTimePointArray[0] != null) {
            this._tlg.update(calendarTimePoint, (byte)4, calendarTimePointArray[0], new DirectAssertion((Object)new DefaultLiteral(this.tvocab.getAfterRelation(), Arrays.asList(calendarTimePoint, calendarTimePointArray[0]), true), "points on timeline"));
        }
        if (calendarTimePointArray[1] != null) {
            this._tlg.update(calendarTimePoint, (byte)1, calendarTimePointArray[1], new DirectAssertion((Object)new DefaultLiteral(this.tvocab.getBeforeRelation(), Arrays.asList(calendarTimePoint, calendarTimePointArray[1]), true), "points on timeline"));
        }
    }
}

