/*
 * Decompiled with CFR 0.152.
 */
package jtp.time.demod;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import jtp.DirectAssertion;
import jtp.ReasoningException;
import jtp.demod.CanonicalMapping;
import jtp.fol.CNFSentence;
import jtp.fol.Clause;
import jtp.fol.DefaultLiteral;
import jtp.fol.Literal;
import jtp.fol.Symbol;
import jtp.fol.Unifyable;
import jtp.time.demod.TimePointMappingReasoningStep;
import jtp.time.tlgraph.TLGraph;
import jtp.time.tp.CalendarTimePoint;
import jtp.time.tp.TimePoint;
import jtp.time.vocab.TimeVocabulary;

public class TimePointMapper {
    static final Symbol EQUALS = Symbol.newSymbol("=");
    private static final Symbol NULL_SYM = Symbol.uniqueSymbol("", null);
    CanonicalMapping mapping;
    TLGraph tlg;
    TimeVocabulary tvocab;

    public TimePointMapper(CanonicalMapping canonicalMapping, TimeVocabulary timeVocabulary) {
        this.mapping = canonicalMapping;
        this.tlg = new TLGraph();
        this.tvocab = timeVocabulary;
    }

    public CanonicalMapping getMapping() {
        return this.mapping;
    }

    public void setTLGraph(TLGraph tLGraph) {
        this.tlg = tLGraph;
    }

    public void mapTimePoints(CNFSentence cNFSentence) throws ReasoningException {
        this.mapTimePoints(cNFSentence, true);
    }

    public void mapTimePoints(CNFSentence cNFSentence, boolean bl) throws ReasoningException {
        Iterator iterator = cNFSentence.clauses().iterator();
        while (iterator.hasNext()) {
            this.mapTimePoints((Clause)iterator.next(), bl);
        }
    }

    public void mapTimePoints(Clause clause) throws ReasoningException {
        this.mapTimePoints(clause, true);
    }

    public void mapTimePoints(Clause clause, boolean bl) throws ReasoningException {
        Iterator iterator = clause.literals().iterator();
        while (iterator.hasNext()) {
            this.mapTimePoints((Literal)iterator.next(), bl);
        }
    }

    public void mapTimePoints(Literal literal) throws ReasoningException {
        this.mapTimePoints(literal, true);
    }

    public void mapTimePoints(Literal literal, boolean bl) throws ReasoningException {
        this.mapTimePoints(literal.getArgs(), bl);
    }

    public void mapTimePoints(List list) throws ReasoningException {
        this.mapTimePoints(list, true);
    }

    public void mapTimePoints(List list, boolean bl) throws ReasoningException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.mapTimePoint(iterator.next(), bl);
        }
    }

    public TimePoint mapTimePoint(Object object) throws ReasoningException {
        return this.mapTimePoint(object, true);
    }

    public TimePoint mapTimePoint(Object object, boolean bl) throws ReasoningException {
        if (object instanceof TimePoint) {
            return (TimePoint)object;
        }
        Object v = this.mapping.getSubstitutionMap().get(object);
        if (v instanceof TimePoint) {
            return (TimePoint)v;
        }
        TimePoint timePoint = null;
        if (object instanceof List) {
            List list = (List)object;
            if (list.isEmpty()) {
                return null;
            }
            if (this.isIntervalEndPoint(list)) {
                timePoint = this.isTimeIntervalFnPoint(list) ? this.getTimeIntervalFnPoint(list) : this.getTimePoint(list);
            } else if (this.isMetricPoint(list)) {
                timePoint = this.getMetricPoint(list);
            }
        } else if (object instanceof Symbol && bl) {
            timePoint = this.getTimePoint(object);
        } else {
            return null;
        }
        this.mapping.moveEqualityClass(object, timePoint, new TimePointMappingReasoningStep(new DefaultLiteral(EQUALS, Arrays.asList(object, timePoint), true)));
        return timePoint;
    }

    public boolean isIntervalEndPoint(List list) {
        return list.size() == 2 && (list.get(0).equals(this.tvocab.getStartPointFn()) || list.get(0).equals(this.tvocab.getEndPointFn())) && !(list.get(1) instanceof Unifyable);
    }

    protected boolean isTimeIntervalFnPoint(List list) {
        if (!(list.get(1) instanceof List)) {
            return false;
        }
        List list2 = (List)list.get(1);
        return list2.size() == 3 && list2.get(0).equals(this.tvocab.getTimeIntervalFn());
    }

    public boolean isMetricPoint(List list) {
        return list.get(0).equals(this.tvocab.getAbsoluteTimePointFn());
    }

    public TimePoint getMetricPoint(List list) throws ReasoningException {
        CalendarTimePoint[] calendarTimePointArray = new CalendarTimePoint[2];
        CalendarTimePoint calendarTimePoint = null;
        if (list.size() == 2 && list.get(1) instanceof Number) {
            calendarTimePoint = CalendarTimePoint.getInstance(((Number)list.get(1)).longValue(), calendarTimePointArray);
        } else {
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            String string = "GMT";
            Iterator iterator = list.iterator();
            iterator.next();
            while (iterator.hasNext()) {
                List list2 = (List)iterator.next();
                Symbol symbol = (Symbol)list2.get(0);
                if (symbol.equals(this.tvocab.getTimeZoneFn())) {
                    string = (String)list2.get(1);
                    continue;
                }
                int n8 = (Integer)list2.get(1);
                if (symbol.equals(this.tvocab.getYearFn())) {
                    n = n8;
                    continue;
                }
                if (symbol.equals(this.tvocab.getMonthFn())) {
                    n2 = n8;
                    continue;
                }
                if (symbol.equals(this.tvocab.getDayFn())) {
                    n3 = n8;
                    continue;
                }
                if (symbol.equals(this.tvocab.getHourFn())) {
                    n4 = n8;
                    continue;
                }
                if (symbol.equals(this.tvocab.getMinuteFn())) {
                    n5 = n8;
                    continue;
                }
                if (symbol.equals(this.tvocab.getSecondFn())) {
                    n6 = n8;
                    continue;
                }
                if (!symbol.equals(this.tvocab.getMillisecondFn())) continue;
                n7 = n8;
            }
            if (n == -1 || n2 == -1 || n3 == -1 || n4 == -1) {
                throw new ReasoningException("Date must be specified at least up to hour: " + list);
            }
            calendarTimePoint = CalendarTimePoint.getInstance(n, n2, n3, n4, n5, n6, n7, TimeZone.getTimeZone(string), calendarTimePointArray);
        }
        this.addMetricPointToGraph(calendarTimePoint, calendarTimePointArray);
        return calendarTimePoint;
    }

    protected void addMetricPointToGraph(CalendarTimePoint calendarTimePoint, CalendarTimePoint[] calendarTimePointArray) throws ReasoningException {
        if (calendarTimePointArray[0] != null) {
            this.tlg.update(calendarTimePointArray[0], (byte)1, calendarTimePoint, new DirectAssertion((Object)new DefaultLiteral(this.tvocab.getBeforeRelation(), Arrays.asList(calendarTimePointArray[0], calendarTimePoint), true), "points on timeline"));
        }
        if (calendarTimePointArray[1] != null) {
            this.tlg.update(calendarTimePoint, (byte)1, calendarTimePointArray[1], new DirectAssertion((Object)new DefaultLiteral(this.tvocab.getBeforeRelation(), Arrays.asList(calendarTimePoint, calendarTimePointArray[1]), true), "points on timeline"));
        }
    }

    public TimePoint getTimePoint(Object object) {
        TimePoint timePoint = new TimePoint(object);
        return timePoint;
    }

    public TimePoint getTimeIntervalFnPoint(List list) throws ReasoningException {
        List list2 = (List)list.get(1);
        Object e = list.get(0).equals(this.tvocab.getStartPointFn()) ? list2.get(1) : list2.get(2);
        TimePoint timePoint = this.mapTimePoint(e);
        if (timePoint == null) {
            throw new ReasoningException("argument to TimeIntervalFn " + list2 + " should be a TimePoint or mappable to a TimePoint: " + e);
        }
        return timePoint;
    }
}

