/*
 * Decompiled with CFR 0.152.
 */
package jtp.time;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.undo.UndoManager;
import jtp.DirectAssertion;
import jtp.KnowledgeStore;
import jtp.Reasoner;
import jtp.ReasoningException;
import jtp.ReasoningStep;
import jtp.ReasoningStepIterator;
import jtp.demod.CanonicalMapping;
import jtp.demod.DemodulationProofTranslator;
import jtp.demod.DemodulationReasoner;
import jtp.demod.DemodulationReasoningStep;
import jtp.disp.SequentialDispatcher;
import jtp.fol.DefaultClause;
import jtp.fol.DefaultLiteral;
import jtp.fol.Literal;
import jtp.fol.SubstUtils;
import jtp.fol.Symbol;
import jtp.fol.Unifyable;
import jtp.fol.Variable;
import jtp.frame.InferredValueReasoningStep;
import jtp.frame.vocab.StandardFrames;
import jtp.rs.ArrayReasoningStepIterator;
import jtp.time.demod.TimePointMapper;
import jtp.time.tlgraph.Relations;
import jtp.time.tlgraph.TLGraph;
import jtp.time.tp.CalendarTimePoint;
import jtp.time.tp.TimePoint;
import jtp.time.vocab.TimeVocabulary;
import jtp.util.PropertyImporter;

public class TimePointKnowledgeStore
extends PropertyImporter
implements KnowledgeStore {
    TLGraph tlg;
    TimePointMapper tmapper;
    TimeVocabulary tvocab;
    TellingReasoner tellingReasoner;
    AskingReasoner askingReasoner;
    int maxDepth = Integer.MAX_VALUE;
    DirectAssertion subRelationRule;
    DirectAssertion transitiveRule;
    DirectAssertion equalPointTransitive;
    DirectAssertion inverseRule;
    DirectAssertion beforeInverseAfter;
    DirectAssertion beforeEqlInverseAfterEql;

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int n) {
        this.maxDepth = n;
    }

    public UndoManager getUndoManager() {
        return this.tlg.getUndoManager();
    }

    public void setUndoManager(UndoManager undoManager) {
        this.tlg.setUndoManager(undoManager);
    }

    public TimePointKnowledgeStore(CanonicalMapping canonicalMapping, TimeVocabulary timeVocabulary) {
        this.tvocab = timeVocabulary;
        this.tlg = new TLGraph(this);
        this.tmapper = new TimePointMapper(canonicalMapping, this.tvocab);
        this.setImportedProperties(new String[]{"maxDepth", "undoManager"});
        this.createSubRelationRule();
        this.createTransitivityRule();
        this.createInverseRule();
    }

    public void createSubRelationRule() {
        Variable variable = new Variable("psub");
        Variable variable2 = new Variable("prop");
        Variable variable3 = new Variable("subj");
        Variable variable4 = new Variable("val");
        this.subRelationRule = new DirectAssertion((Object)new DefaultClause(new DefaultLiteral(this.tvocab.getSubrelationRelation(), Arrays.asList(variable, variable2), false), new DefaultLiteral(StandardFrames.HOLDS, Arrays.asList(variable, variable3, variable4), false), new DefaultLiteral(StandardFrames.HOLDS, Arrays.asList(variable2, variable3, variable4), true)), this.tvocab.getSource());
    }

    public void createTransitivityRule() {
        Variable variable = new Variable("p");
        Variable variable2 = new Variable("x");
        Variable variable3 = new Variable("y");
        Variable variable4 = new Variable("z");
        this.transitiveRule = new DirectAssertion((Object)new DefaultClause(Arrays.asList(new DefaultLiteral(this.tvocab.getInstanceOfRelation(), Arrays.asList(variable, this.tvocab.getTransitiveRelationClass()), false), new DefaultLiteral(StandardFrames.HOLDS, Arrays.asList(variable, variable2, variable3), false), new DefaultLiteral(StandardFrames.HOLDS, Arrays.asList(variable, variable3, variable4), false), new DefaultLiteral(StandardFrames.HOLDS, Arrays.asList(variable, variable2, variable4), true))), this.tvocab.getSource());
        this.equalPointTransitive = new DirectAssertion((Object)new DefaultLiteral(this.tvocab.getInstanceOfRelation(), Arrays.asList(this.tvocab.getEqualRelation(), this.tvocab.getTransitiveRelationClass()), true), this.tvocab.getSource());
    }

    public void createInverseRule() {
        Variable variable = new Variable("p1");
        Variable variable2 = new Variable("p2");
        Variable variable3 = new Variable("subj");
        Variable variable4 = new Variable("obj");
        this.inverseRule = new DirectAssertion((Object)new DefaultClause(new DefaultLiteral(this.tvocab.getInverseRelation(), Arrays.asList(variable, variable2), false), new DefaultLiteral(StandardFrames.HOLDS, Arrays.asList(variable, variable3, variable4), false), new DefaultLiteral(StandardFrames.HOLDS, Arrays.asList(variable2, variable4, variable3), true)), this.tvocab.getSource());
        this.beforeInverseAfter = new DirectAssertion((Object)new DefaultLiteral(this.tvocab.getInverseRelation(), Arrays.asList(this.tvocab.getAfterRelation(), this.tvocab.getBeforeRelation()), true), this.tvocab.getSource());
        this.beforeEqlInverseAfterEql = new DirectAssertion((Object)new DefaultLiteral(this.tvocab.getInverseRelation(), Arrays.asList(this.tvocab.getAfterOrEqualRelation(), this.tvocab.getBeforeOrEqualRelation()), true), this.tvocab.getSource());
    }

    public Reasoner getAskingReasoner() {
        if (this.askingReasoner == null) {
            this.askingReasoner = new AskingReasoner();
        }
        return this.askingReasoner;
    }

    public Reasoner getTellingReasoner() {
        if (this.tellingReasoner == null) {
            this.tellingReasoner = new TellingReasoner();
        }
        return this.tellingReasoner;
    }

    public byte getByteRelation(Symbol symbol) {
        if (symbol.equals(this.tvocab.getBeforeRelation())) {
            return 1;
        }
        if (symbol.equals(this.tvocab.getAfterRelation())) {
            return 4;
        }
        if (symbol.equals(this.tvocab.getEqualRelation())) {
            return 2;
        }
        if (symbol.equals(this.tvocab.getBeforeOrEqualRelation())) {
            return 3;
        }
        if (symbol.equals(this.tvocab.getAfterOrEqualRelation())) {
            return 6;
        }
        return 0;
    }

    public Symbol getRelationSymbol(byte by) {
        switch (by) {
            case 1: {
                return this.tvocab.getBeforeRelation();
            }
            case 4: {
                return this.tvocab.getAfterRelation();
            }
            case 2: {
                return this.tvocab.getEqualRelation();
            }
            case 3: {
                return this.tvocab.getBeforeOrEqualRelation();
            }
            case 6: {
                return this.tvocab.getAfterOrEqualRelation();
            }
        }
        return null;
    }

    public ReasoningStep getTimePointReasoningStep(Literal literal, List list) {
        return new TimePointReasoningStep(literal, list);
    }

    public ReasoningStep getPointEqualityReasoningStep(Object object, Object object2, List list) {
        return new PointEqualityReasoningStep(object, object2, list);
    }

    public ReasoningStep getPointRelationInverseReasoningStep(ReasoningStep reasoningStep) {
        return new PointRelationInverseReasoningStep(reasoningStep);
    }

    public ReasoningStep getPointSubRelationReasoningStep(Symbol symbol, Symbol symbol2, ReasoningStep reasoningStep) {
        return new PointSubRelationReasoningStep(symbol, symbol2, reasoningStep);
    }

    List createSubStepsForPointEqualityRS(List list) {
        ArrayList<DirectAssertion> arrayList = new ArrayList<DirectAssertion>(list.size() + 2);
        arrayList.add(this.transitiveRule);
        arrayList.add(this.equalPointTransitive);
        arrayList.addAll(list);
        return arrayList;
    }

    Literal createGoalForPointRelationInverseRS(ReasoningStep reasoningStep) {
        Literal literal = (Literal)reasoningStep.getGoal();
        byte by = this.getByteRelation(literal.getRelation());
        Symbol symbol = this.getRelationSymbol(Relations.inverse(by));
        return new DefaultLiteral(symbol, Arrays.asList(literal.getArgs().get(1), literal.getArgs().get(0)), true);
    }

    List createSubStepsForPointRelationInverseRS(ReasoningStep reasoningStep) {
        Literal literal = (Literal)reasoningStep.getGoal();
        DirectAssertion directAssertion = literal.getRelation().equals(this.tvocab.getAfterRelation()) ? this.beforeInverseAfter : this.beforeEqlInverseAfterEql;
        return Arrays.asList(this.inverseRule, directAssertion, reasoningStep);
    }

    Literal createGoalForPointSubRelationRS(Symbol symbol, ReasoningStep reasoningStep) {
        Literal literal = (Literal)reasoningStep.getGoal();
        return new DefaultLiteral(symbol, Arrays.asList(literal.getArgs().get(0), literal.getArgs().get(1)), true);
    }

    List createSubStepsForPointSubRelationRS(Symbol symbol, Symbol symbol2, ReasoningStep reasoningStep) {
        ArrayList<ReasoningStep> arrayList = new ArrayList<ReasoningStep>(3);
        arrayList.add(this.subRelationRule);
        arrayList.add(new DirectAssertion((Object)new DefaultLiteral(this.tvocab.getSubrelationRelation(), Arrays.asList(symbol, symbol2), true), this.subRelationRule.getKBLocation()));
        arrayList.add(reasoningStep);
        return arrayList;
    }

    class PointSubRelationReasoningStep
    extends TimePointReasoningStep {
        public PointSubRelationReasoningStep(Symbol symbol, Symbol symbol2, ReasoningStep reasoningStep) {
            super(TimePointKnowledgeStore.this.createGoalForPointSubRelationRS(symbol2, reasoningStep), TimePointKnowledgeStore.this.createSubStepsForPointSubRelationRS(symbol, symbol2, reasoningStep));
        }
    }

    class PointRelationInverseReasoningStep
    extends TimePointReasoningStep {
        public PointRelationInverseReasoningStep(ReasoningStep reasoningStep) {
            super(TimePointKnowledgeStore.this.createGoalForPointRelationInverseRS(reasoningStep), TimePointKnowledgeStore.this.createSubStepsForPointRelationInverseRS(reasoningStep));
        }
    }

    class PointEqualityReasoningStep
    extends TimePointReasoningStep {
        public PointEqualityReasoningStep(Object object, Object object2, List list) {
            super(new DefaultLiteral(TimePointKnowledgeStore.this.getRelationSymbol((byte)2), Arrays.asList(object, object2), true), TimePointKnowledgeStore.this.createSubStepsForPointEqualityRS(list));
        }
    }

    public class TimePointReasoningStep
    extends InferredValueReasoningStep {
        public TimePointReasoningStep(Literal literal, List list) {
            super(literal, list);
        }

        protected void setBindings(Map map) {
            this.bindings = map;
        }

        public String tracePrint() {
            return "proven through use of temporal reasoner";
        }
    }

    public class TellingReasoner
    implements Reasoner,
    SequentialDispatcher.LocationPreference {
        DemodulationProofTranslator dtrans;

        TellingReasoner() {
            this.dtrans = new DemodulationProofTranslator(TimePointKnowledgeStore.this.tmapper.getMapping());
        }

        public boolean acceptable(Object object) {
            ReasoningStep reasoningStep = (ReasoningStep)object;
            if (!(reasoningStep.getGoal() instanceof Literal)) {
                return false;
            }
            Literal literal = (Literal)reasoningStep.getGoal();
            if (literal.getArgs().size() != 2 || !literal.isPositive()) {
                return false;
            }
            Symbol symbol = literal.getRelation();
            return symbol.equals(TimePointKnowledgeStore.this.tvocab.getBeforeRelation()) || symbol.equals(TimePointKnowledgeStore.this.tvocab.getAfterRelation()) || symbol.equals(TimePointKnowledgeStore.this.tvocab.getEqualRelation()) || symbol.equals(TimePointKnowledgeStore.this.tvocab.getBeforeOrEqualRelation()) || symbol.equals(TimePointKnowledgeStore.this.tvocab.getAfterOrEqualRelation());
        }

        public ReasoningStepIterator process(Object object) throws ReasoningException {
            Literal literal = (Literal)((ReasoningStep)object).getGoal();
            TimePointKnowledgeStore.this.tmapper.mapTimePoints(literal, true);
            ReasoningStep reasoningStep = this.dtrans.translate((ReasoningStep)object);
            Literal literal2 = (Literal)reasoningStep.getGoal();
            if (!(literal2.getArgs().get(0) instanceof TimePoint) || !(literal2.getArgs().get(1) instanceof TimePoint)) {
                return ArrayReasoningStepIterator.empty;
            }
            TimePoint timePoint = (TimePoint)literal2.getArgs().get(0);
            TimePoint timePoint2 = (TimePoint)literal2.getArgs().get(1);
            byte by = TimePointKnowledgeStore.this.getByteRelation(literal2.getRelation());
            TimePointKnowledgeStore.this.tlg.update(timePoint, by, timePoint2, reasoningStep);
            if (object instanceof DirectAssertion) {
                ((DirectAssertion)object).setAsserted(true);
            }
            return ArrayReasoningStepIterator.empty;
        }

        public int getPreferredLocation() {
            return 1;
        }
    }

    public class AskingReasoner
    implements Reasoner {
        DemodulationReasoner demod;
        private transient List varStack = new ArrayList(3);

        AskingReasoner() {
            this.demod = new DemodulationReasoner(TimePointKnowledgeStore.this.tmapper.getMapping());
        }

        public boolean acceptable(Object object) {
            if (!(object instanceof Literal)) {
                return false;
            }
            Literal literal = (Literal)object;
            Symbol symbol = literal.getRelation();
            List list = literal.getArgs();
            return literal.isPositive() && (symbol.equals(TimePointKnowledgeStore.this.tvocab.getLocationRelation()) || (symbol.equals(TimePointKnowledgeStore.this.tvocab.getBeforeRelation()) || symbol.equals(TimePointKnowledgeStore.this.tvocab.getAfterRelation()) || symbol.equals(TimePointKnowledgeStore.this.tvocab.getEqualRelation()) || symbol.equals(TimePointKnowledgeStore.this.tvocab.getBeforeOrEqualRelation()) || symbol.equals(TimePointKnowledgeStore.this.tvocab.getAfterOrEqualRelation())) && list.size() == 2 || symbol.equals(StandardFrames.HOLDS) && list.size() == 3 && list.get(0) instanceof Unifyable && !(list.get(1) instanceof Unifyable) && !(list.get(2) instanceof Unifyable));
        }

        public ReasoningStepIterator process(Object object) throws ReasoningException {
            Literal literal = SubstUtils.deReferenceLiteral((Literal)object);
            TimePointKnowledgeStore.this.tmapper.mapTimePoints(literal, false);
            DemodulationReasoningStep demodulationReasoningStep = this.demod.translateGoal(literal);
            Literal literal2 = demodulationReasoningStep == null ? literal : (Literal)demodulationReasoningStep.getSubGoals().get(demodulationReasoningStep.getSubGoals().size() - 1);
            Symbol symbol = literal2.getRelation();
            if (symbol.equals(TimePointKnowledgeStore.this.tvocab.getLocationRelation())) {
                return this.processLocationQuery(literal2, demodulationReasoningStep);
            }
            if (symbol.equals(StandardFrames.HOLDS) && literal2.getArgs().get(1) instanceof TimePoint && literal2.getArgs().get(2) instanceof TimePoint) {
                return this.processPointRelationQuery(literal2, demodulationReasoningStep);
            }
            Object e = literal2.getArgs().get(0);
            Object e2 = literal2.getArgs().get(1);
            if (!(e instanceof TimePoint) && !(e instanceof Unifyable)) {
                return ArrayReasoningStepIterator.empty;
            }
            if (!(e2 instanceof TimePoint) && !(e2 instanceof Unifyable)) {
                return ArrayReasoningStepIterator.empty;
            }
            if (e instanceof Unifyable && e2 instanceof Unifyable) {
                return ArrayReasoningStepIterator.empty;
            }
            byte by = TimePointKnowledgeStore.this.getByteRelation(symbol);
            if (e instanceof TimePoint && e2 instanceof TimePoint) {
                TimePoint timePoint = (TimePoint)e;
                TimePoint timePoint2 = (TimePoint)e2;
                byte by2 = TimePointKnowledgeStore.this.tlg.query(timePoint, timePoint2);
                if (Relations.entails(by2, by)) {
                    ReasoningStep reasoningStep = TimePointKnowledgeStore.this.tlg.proveRelation(timePoint, timePoint2, by2);
                    if (by2 != by) {
                        reasoningStep = new PointSubRelationReasoningStep(TimePointKnowledgeStore.this.getRelationSymbol(by2), symbol, reasoningStep);
                    }
                    if (demodulationReasoningStep == null) {
                        return new ArrayReasoningStepIterator(reasoningStep);
                    }
                    demodulationReasoningStep.getSubProofs().add(reasoningStep);
                    return new ArrayReasoningStepIterator(demodulationReasoningStep);
                }
                return ArrayReasoningStepIterator.empty;
            }
            if (e instanceof TimePoint) {
                Collection collection = null;
                TimePoint timePoint = (TimePoint)e;
                if (symbol.equals(TimePointKnowledgeStore.this.tvocab.getBeforeRelation())) {
                    collection = TimePointKnowledgeStore.this.tlg.getAllPointsAfter(timePoint, TimePointKnowledgeStore.this.maxDepth);
                } else if (symbol.equals(TimePointKnowledgeStore.this.tvocab.getBeforeOrEqualRelation())) {
                    collection = TimePointKnowledgeStore.this.tlg.getAllPointsAfterOrEqual(timePoint, TimePointKnowledgeStore.this.maxDepth);
                } else if (symbol.equals(TimePointKnowledgeStore.this.tvocab.getAfterRelation())) {
                    collection = TimePointKnowledgeStore.this.tlg.getAllPointsBefore(timePoint, TimePointKnowledgeStore.this.maxDepth);
                } else if (symbol.equals(TimePointKnowledgeStore.this.tvocab.getAfterOrEqualRelation())) {
                    collection = TimePointKnowledgeStore.this.tlg.getAllPointsBeforeOrEqual(timePoint, TimePointKnowledgeStore.this.maxDepth);
                } else if (symbol.equals(TimePointKnowledgeStore.this.tvocab.getEqualRelation())) {
                    collection = TimePointKnowledgeStore.this.tlg.getAllPointsEqual(timePoint);
                }
                ArrayList<ReasoningStep> arrayList = new ArrayList<ReasoningStep>(collection.size());
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(TimePointKnowledgeStore.this.tlg.proveRelation(timePoint, (TimePoint)iterator.next(), by));
                }
                return new ResultsIterator((Unifyable)e2, arrayList, 1, demodulationReasoningStep);
            }
            Collection collection = null;
            TimePoint timePoint = (TimePoint)e2;
            if (symbol.equals(TimePointKnowledgeStore.this.tvocab.getBeforeRelation())) {
                collection = TimePointKnowledgeStore.this.tlg.getAllPointsBefore(timePoint, TimePointKnowledgeStore.this.maxDepth);
            } else if (symbol.equals(TimePointKnowledgeStore.this.tvocab.getBeforeOrEqualRelation())) {
                collection = TimePointKnowledgeStore.this.tlg.getAllPointsBeforeOrEqual(timePoint, TimePointKnowledgeStore.this.maxDepth);
            } else if (symbol.equals(TimePointKnowledgeStore.this.tvocab.getAfterRelation())) {
                collection = TimePointKnowledgeStore.this.tlg.getAllPointsAfter(timePoint, TimePointKnowledgeStore.this.maxDepth);
            } else if (symbol.equals(TimePointKnowledgeStore.this.tvocab.getAfterOrEqualRelation())) {
                collection = TimePointKnowledgeStore.this.tlg.getAllPointsAfterOrEqual(timePoint, TimePointKnowledgeStore.this.maxDepth);
            } else if (symbol.equals(TimePointKnowledgeStore.this.tvocab.getEqualRelation())) {
                collection = TimePointKnowledgeStore.this.tlg.getAllPointsEqual(timePoint);
            }
            ArrayList<ReasoningStep> arrayList = new ArrayList<ReasoningStep>(collection.size());
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                arrayList.add(TimePointKnowledgeStore.this.tlg.proveRelation((TimePoint)iterator.next(), timePoint, by));
            }
            return new ResultsIterator((Unifyable)e, arrayList, 0, demodulationReasoningStep);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ReasoningStepIterator processLocationQuery(Literal literal, DemodulationReasoningStep demodulationReasoningStep) {
            Map map;
            TimePointReasoningStep timePointReasoningStep;
            block15: {
                CalendarTimePoint calendarTimePoint;
                CalendarTimePoint calendarTimePoint2;
                TimePoint timePoint;
                block14: {
                    Object e;
                    block13: {
                        block12: {
                            Object e2;
                            block11: {
                                if (!(literal.getArgs().get(0) instanceof TimePoint)) {
                                    return ArrayReasoningStepIterator.empty;
                                }
                                timePoint = (TimePoint)literal.getArgs().get(0);
                                e2 = literal.getArgs().get(1);
                                e = literal.getArgs().get(2);
                                calendarTimePoint2 = TimePointKnowledgeStore.this.tlg.getMaximumBeforeOrEqualLocation(timePoint);
                                calendarTimePoint = TimePointKnowledgeStore.this.tlg.getMinimumAfterOrEqualLocation(timePoint);
                                if (calendarTimePoint2 == null || calendarTimePoint == null) {
                                    return ArrayReasoningStepIterator.empty;
                                }
                                try {
                                    if (!(e2 instanceof Unifyable)) break block11;
                                    if (!((Unifyable)e2).unify(calendarTimePoint2, this.varStack)) {
                                        ReasoningStepIterator reasoningStepIterator = ArrayReasoningStepIterator.empty;
                                        Object var15_10 = null;
                                        this.varStack.clear();
                                        return reasoningStepIterator;
                                    }
                                    break block12;
                                }
                                catch (Throwable throwable) {
                                    Object var15_16 = null;
                                    this.varStack.clear();
                                    throw throwable;
                                }
                            }
                            if (e2.equals(calendarTimePoint2)) break block12;
                            ReasoningStepIterator reasoningStepIterator = ArrayReasoningStepIterator.empty;
                            Object var15_11 = null;
                            this.varStack.clear();
                            return reasoningStepIterator;
                        }
                        if (!(e instanceof Unifyable)) break block13;
                        if (!((Unifyable)e).unify(calendarTimePoint, this.varStack)) {
                            ReasoningStepIterator reasoningStepIterator = ArrayReasoningStepIterator.empty;
                            Object var15_12 = null;
                            this.varStack.clear();
                            return reasoningStepIterator;
                        }
                        break block14;
                    }
                    if (e.equals(calendarTimePoint)) break block14;
                    ReasoningStepIterator reasoningStepIterator = ArrayReasoningStepIterator.empty;
                    Object var15_13 = null;
                    this.varStack.clear();
                    return reasoningStepIterator;
                }
                ArrayList<ReasoningStep> arrayList = new ArrayList<ReasoningStep>(2);
                arrayList.add(TimePointKnowledgeStore.this.tlg.proveRelation(calendarTimePoint2, timePoint, (byte)3));
                arrayList.add(TimePointKnowledgeStore.this.tlg.proveRelation(timePoint, calendarTimePoint, (byte)3));
                timePointReasoningStep = new TimePointReasoningStep(literal, arrayList);
                map = SubstUtils.variableStackToMap(this.varStack, null);
                if (demodulationReasoningStep != null) break block15;
                timePointReasoningStep.setBindings(map);
                ArrayReasoningStepIterator arrayReasoningStepIterator = new ArrayReasoningStepIterator(timePointReasoningStep);
                Object var15_14 = null;
                this.varStack.clear();
                return arrayReasoningStepIterator;
            }
            demodulationReasoningStep.getSubProofs().add(timePointReasoningStep);
            demodulationReasoningStep.setBindings(map);
            ArrayReasoningStepIterator arrayReasoningStepIterator = new ArrayReasoningStepIterator(demodulationReasoningStep);
            Object var15_15 = null;
            this.varStack.clear();
            return arrayReasoningStepIterator;
        }

        protected ReasoningStepIterator processPointRelationQuery(Literal literal, DemodulationReasoningStep demodulationReasoningStep) {
            Unifyable unifyable = (Unifyable)literal.getArgs().get(0);
            TimePoint timePoint = (TimePoint)literal.getArgs().get(1);
            TimePoint timePoint2 = (TimePoint)literal.getArgs().get(2);
            LinkedList<ReasoningStep> linkedList = new LinkedList<ReasoningStep>();
            byte by = TimePointKnowledgeStore.this.tlg.query(timePoint, timePoint2);
            ReasoningStep reasoningStep = TimePointKnowledgeStore.this.tlg.proveRelation(timePoint, timePoint2, by);
            linkedList.add(reasoningStep);
            byte by2 = 0;
            while (by2 <= 7) {
                if (Relations.entails(by, by2) && by != by2) {
                    linkedList.add(new PointSubRelationReasoningStep(TimePointKnowledgeStore.this.getRelationSymbol(by), TimePointKnowledgeStore.this.getRelationSymbol(by2), reasoningStep));
                }
                by2 = (byte)(by2 + 1);
            }
            return new ResultsIterator(unifyable, linkedList, 0, demodulationReasoningStep);
        }

        class ResultsIterator
        implements ReasoningStepIterator {
            private transient List stack = new ArrayList(3);
            int index;
            Unifyable u;
            Iterator proofIterator;
            Map bindings = null;
            DemodulationReasoningStep drs;

            ResultsIterator(Unifyable unifyable, Collection collection, int n, DemodulationReasoningStep demodulationReasoningStep) {
                this.proofIterator = collection.iterator();
                this.u = unifyable;
                this.index = n;
                this.drs = demodulationReasoningStep;
                demodulationReasoningStep.getSubProofs().add(new DirectAssertion("dummy"));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ReasoningStep next() {
                while (this.proofIterator.hasNext()) {
                    Object var6_5;
                    Object object;
                    ReasoningStep reasoningStep;
                    block8: {
                        try {
                            reasoningStep = (ReasoningStep)this.proofIterator.next();
                            Literal literal = (Literal)reasoningStep.getGoal();
                            Object object2 = literal.getArgs().get(this.index);
                            if (object2 instanceof TimePoint && ((TimePoint)(object = (TimePoint)object2)).getID() != null) {
                                object2 = ((TimePoint)object).getID();
                            }
                            if (!this.u.unify(object2, this.stack)) {
                                var6_5 = null;
                                this.stack.clear();
                                continue;
                            }
                            if (this.bindings != null) {
                                this.bindings.clear();
                            }
                            this.bindings = SubstUtils.variableStackToMap(this.stack, this.bindings);
                            if (this.drs != null) break block8;
                            if (reasoningStep instanceof TimePointReasoningStep) {
                                ((TimePointReasoningStep)reasoningStep).setBindings(this.bindings);
                            }
                            object = reasoningStep;
                        }
                        catch (Throwable throwable) {
                            var6_5 = null;
                            this.stack.clear();
                            throw throwable;
                        }
                        var6_5 = null;
                        this.stack.clear();
                        return object;
                    }
                    this.drs.setBindings(this.bindings);
                    this.drs.getSubProofs().remove(this.drs.getSubProofs().size() - 1);
                    this.drs.getSubProofs().add(reasoningStep);
                    object = this.drs;
                    var6_5 = null;
                    this.stack.clear();
                    return object;
                }
                return null;
            }
        }
    }
}

