/*
 * Decompiled with CFR 0.152.
 */
package jtp.rs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import jtp.ReasoningStep;
import jtp.fol.CNFSentence;
import jtp.util.ObjectStorage;

public class SecondaryProofStorageWriter
implements Serializable {
    ObjectStorage st;
    SortedMap indexMap = new TreeMap();

    public SecondaryProofStorageWriter(ObjectStorage objectStorage) {
        this.st = objectStorage;
    }

    public boolean storeProof(ReasoningStep reasoningStep) throws IOException {
        String string = SecondaryProofStorageWriter.makeKey(reasoningStep.getGoal());
        if (string == null) {
            return false;
        }
        if (this.indexMap.containsKey(string)) {
            return true;
        }
        long l = this.st.storeObject(reasoningStep);
        this.indexMap.put(string, new Long(l));
        return true;
    }

    public void writeIndex(File file) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        Iterator iterator = this.indexMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            fileWriter.write(entry.getKey().toString() + '\t' + entry.getValue() + '\n');
        }
        fileWriter.close();
    }

    public void readIndex(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t\r\n\f");
            String string2 = stringTokenizer.nextToken();
            Long l = Long.valueOf(stringTokenizer.nextToken());
            this.indexMap.put(string2, l);
        }
    }

    static String makeKey(Object object) {
        if (!(object instanceof CNFSentence)) {
            return null;
        }
        String string = object.toString();
        if (string.indexOf(9) >= 0 || string.indexOf(10) >= 0) {
            return null;
        }
        return string;
    }
}

