/*
 * Decompiled with CFR 0.152.
 */
package jtp.rs;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import jtp.ReasoningStep;
import jtp.rs.SecondaryProofStorageWriter;
import jtp.util.ObjectStorage;

public class SecondaryProofStorageLookup {
    ObjectStorage ost;
    RandomAccessFile raf;
    InputStream in;

    public SecondaryProofStorageLookup(ObjectStorage objectStorage, File file) throws IOException {
        this.ost = objectStorage;
        this.raf = new RandomAccessFile(file, "r");
        this.in = new In();
    }

    public ReasoningStep lookUp(Object object) throws IOException {
        String string = SecondaryProofStorageWriter.makeKey(object);
        if (string == null) {
            return null;
        }
        long l = this.raf.length();
        this.raf.seek(0L);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.in));
        int n = this.match(string, bufferedReader);
        if (n > 0) {
            return null;
        }
        if (n == 0) {
            return (ReasoningStep)this.ost.retrieveObjectAt(this.readLocation(bufferedReader));
        }
        long l2 = 0L;
        while (l2 + 2L < l) {
            long l3 = l2 + (l - l2) / 2L;
            this.raf.seek(l3);
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(this.in));
            long l4 = this.align(bufferedReader2);
            if (l3 + l4 >= l) {
                l = l3 + 1L;
                continue;
            }
            int n2 = this.match(string, bufferedReader2);
            if (n2 == 0) {
                return (ReasoningStep)this.ost.retrieveObjectAt(this.readLocation(bufferedReader2));
            }
            if (n2 < 0) {
                l2 = l3 + l4;
                continue;
            }
            l = l3 + 1L;
        }
        return null;
    }

    protected long align(Reader reader) throws IOException {
        int n;
        long l = 0L;
        do {
            ++l;
        } while ((n = reader.read()) != -1 && n != 10);
        return l;
    }

    protected int match(String string, Reader reader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            int n2 = reader.read();
            stringBuffer.append((char)n2);
            char c = string.charAt(n);
            if (n2 < c) {
                return -1;
            }
            if (n2 > c) {
                return 1;
            }
            ++n;
        }
        if (reader.read() != 9) {
            return 1;
        }
        return 0;
    }

    protected long readLocation(Reader reader) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = reader.read()) != 10 && n != -1) {
            stringBuffer.append((char)n);
        }
        return Long.valueOf(stringBuffer.toString());
    }

    private class In
    extends InputStream {
        private In() {
        }

        public int read() throws IOException {
            return SecondaryProofStorageLookup.this.raf.read();
        }
    }
}

