/*
 * Decompiled with CFR 0.152.
 */
package jtp.rs;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jtp.ReasoningException;
import jtp.ReasoningStep;
import jtp.ReasoningStepIterator;
import jtp.fol.SubstUtils;
import jtp.fol.Variable;
import jtp.proof.Proof;
import jtp.util.ArrayMap;

public class RSUtils {
    public static Map variableStackToMap(List list, Map abstractMap) {
        int n = list.size();
        if (abstractMap == null) {
            abstractMap = n <= 3 ? new ArrayMap(n) : (n < 15 ? new TreeMap<Variable, Object>() : new HashMap(2 * n));
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Variable variable = (Variable)iterator.next();
            abstractMap.put(variable, variable.deReferenceVariables());
        }
        return abstractMap;
    }

    public static void recursiveMakeStep(ReasoningStep reasoningStep) {
        reasoningStep.makeStep();
        Iterator iterator = reasoningStep.getSubProofs().iterator();
        while (iterator.hasNext()) {
            RSUtils.recursiveMakeStep((ReasoningStep)iterator.next());
        }
    }

    public static void recursiveBacktrack(ReasoningStep reasoningStep) {
        reasoningStep.backtrack();
        Iterator iterator = reasoningStep.getSubProofs().iterator();
        while (iterator.hasNext()) {
            RSUtils.recursiveBacktrack((ReasoningStep)iterator.next());
        }
    }

    public static ReasoningStep recursiveClone(ReasoningStep reasoningStep) {
        ReasoningStep reasoningStep2 = (ReasoningStep)reasoningStep.clone();
        if (reasoningStep.getSubProofs() != null && reasoningStep.getSubProofs() != Collections.EMPTY_LIST && reasoningStep2.getSubProofs() == reasoningStep.getSubProofs()) {
            System.out.println("INCORRECT CLONING: " + reasoningStep.getClass());
        } else {
            reasoningStep2.getSubProofs().clear();
            Iterator iterator = reasoningStep.getSubProofs().iterator();
            while (iterator.hasNext()) {
                reasoningStep2.getSubProofs().add(RSUtils.recursiveClone((ReasoningStep)iterator.next()));
            }
        }
        return reasoningStep2;
    }

    public static Map getRecursiveBindings(Proof proof, Map hashMap) {
        if (hashMap == null) {
            hashMap = new HashMap(20);
        }
        hashMap.putAll(proof.getBindings());
        Iterator iterator = proof.getSubProofs().iterator();
        while (iterator.hasNext()) {
            RSUtils.getRecursiveBindings((Proof)iterator.next(), hashMap);
        }
        return hashMap;
    }

    public static String printReasoningStepIterator(ReasoningStepIterator reasoningStepIterator, String string) throws ReasoningException {
        ReasoningStep reasoningStep;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while ((reasoningStep = reasoningStepIterator.next()) != null) {
            stringBuffer.append(RSUtils.printReasoningStep(reasoningStep, string + ' ' + n + ':')).append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String printReasoningStep(ReasoningStep reasoningStep, String string) {
        Iterator iterator;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append(reasoningStep.getClass()).append(" used to prove ").append(reasoningStep.getGoal());
        stringBuffer.append('\n').append(string).append(reasoningStep.tracePrint());
        Map map = reasoningStep.getBindings();
        if (!map.isEmpty()) {
            stringBuffer.append('\n').append(string).append("Bindings:");
            object = map.keySet().iterator();
            while (object.hasNext()) {
                iterator = object.next();
                stringBuffer.append('\n').append(string).append(iterator).append(" = ").append(SubstUtils.print(map.get(iterator)));
            }
        }
        if (!(object = reasoningStep.getSubGoals()).isEmpty()) {
            stringBuffer.append('\n').append(string).append("Subgoals:");
            iterator = object.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append('\n').append(string).append(' ').append(iterator.next());
            }
        }
        if (!(object = reasoningStep.getSubProofs()).isEmpty()) {
            stringBuffer.append('\n').append(string).append("Substeps:");
            iterator = object.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append('\n').append(RSUtils.printReasoningStep((ReasoningStep)iterator.next(), string + ' '));
            }
        }
        return stringBuffer.toString();
    }

    public static int getNestingDepth(ReasoningStep reasoningStep) {
        List list = reasoningStep.getSubProofs();
        if (list.isEmpty()) {
            return 1;
        }
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n2 = RSUtils.getNestingDepth((ReasoningStep)iterator.next());
            if (n2 <= n) continue;
            n = n2;
        }
        return n + 1;
    }

    public static ReasoningStepIterator concatenate(ReasoningStepIterator reasoningStepIterator, ReasoningStepIterator reasoningStepIterator2) {
        return RSUtils.concatenate(new ReasoningStepIterator[]{reasoningStepIterator, reasoningStepIterator2});
    }

    public static ReasoningStepIterator concatenate(ReasoningStepIterator reasoningStepIterator, ReasoningStepIterator reasoningStepIterator2, ReasoningStepIterator reasoningStepIterator3) {
        return RSUtils.concatenate(new ReasoningStepIterator[]{reasoningStepIterator, reasoningStepIterator2, reasoningStepIterator3});
    }

    public static ReasoningStepIterator concatenate(final ReasoningStepIterator[] reasoningStepIteratorArray) {
        return new ReasoningStepIterator(){
            int i = 0;

            public ReasoningStep next() throws ReasoningException {
                while (this.i < reasoningStepIteratorArray.length) {
                    ReasoningStep reasoningStep = reasoningStepIteratorArray[this.i].next();
                    if (reasoningStep != null) {
                        return reasoningStep;
                    }
                    ++this.i;
                }
                return null;
            }
        };
    }
}

