/*
 * Decompiled with CFR 0.152.
 */
package jtp.rs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import jtp.ReasoningStep;
import jtp.proof.Proof;

public class LinearizedProof {
    Map rsToItems = new HashMap();
    Proof rs0;
    List axioms = new ArrayList();
    List theorems = new ArrayList();

    public LinearizedProof(Proof proof) {
        if (proof instanceof ReasoningStep) {
            proof = (Proof)((ReasoningStep)proof).deReferenceVariables();
        }
        this.rs0 = proof;
        this.sort(proof);
        Collections.reverse(this.axioms);
        Collections.reverse(this.theorems);
        this.assignIndexes(this.axioms, 1);
        this.assignIndexes(this.theorems, this.axioms.size() + 1);
    }

    public List getAxioms() {
        return this.axioms;
    }

    public List getTheorems() {
        return this.theorems;
    }

    protected void assignIndexes(List list, int n) {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            if (this.rsToItems.containsKey(e)) {
                listIterator.remove();
                continue;
            }
            this.rsToItems.put(e, new Integer(listIterator.previousIndex() + n));
        }
    }

    protected boolean isAnAxiomRS(Proof proof) {
        return proof.getSubGoals().isEmpty();
    }

    protected void sort(Proof proof) {
        if (this.isAnAxiomRS(proof)) {
            this.axioms.add(proof);
        } else {
            this.theorems.add(proof);
            Iterator iterator = proof.getSubProofs().iterator();
            while (iterator.hasNext()) {
                this.sort((Proof)iterator.next());
            }
        }
    }

    public String printShortComment(Proof proof) {
        if (proof instanceof ReasoningStep) {
            return ((ReasoningStep)proof).tracePrint();
        }
        return String.valueOf(proof.getInference());
    }

    public String toString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Axioms:\n");
        ListIterator listIterator = this.axioms.listIterator();
        while (listIterator.hasNext()) {
            object = (Proof)listIterator.next();
            stringBuffer.append(this.rsToItems.get(object)).append(". ").append(((Proof)object).getGoal()).append(this.printShortComment((Proof)object)).append('\n');
        }
        stringBuffer.append("Theorems:\n");
        object = this.theorems.listIterator();
        while (object.hasNext()) {
            Proof proof = (Proof)object.next();
            stringBuffer.append(this.rsToItems.get(proof)).append(". ").append(proof.getGoal()).append(this.printShortComment(proof)).append('\n');
            if (!proof.getSubProofs().isEmpty()) {
                stringBuffer.append('\t').append("(based on ");
                Iterator iterator = proof.getSubProofs().iterator();
                stringBuffer.append(this.rsToItems.get(iterator.next()));
                while (iterator.hasNext()) {
                    stringBuffer.append("; ").append(this.rsToItems.get(iterator.next()));
                }
                stringBuffer.append(')');
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }
}

