/*
 * Decompiled with CFR 0.152.
 */
package jtp.rs;

import java.util.Collections;
import java.util.List;
import jtp.Cut;
import jtp.ReasoningStep;
import jtp.context.DepthMonitor;

public class DefaultCut
extends Cut {
    String message;
    int depth;

    public DefaultCut(String string, int n) {
        this.message = string;
        this.depth = n;
    }

    public DefaultCut(String string) {
        this(string, Integer.MAX_VALUE);
    }

    public DefaultCut(String string, DepthMonitor depthMonitor) {
        this(string, depthMonitor.getMaxDepth() - depthMonitor.getCurrentDepth());
    }

    public void setGoal(Object object) {
        this.goal = object;
    }

    public String tracePrint() {
        if (this.message == null) {
            return "Cut";
        }
        return "Cut: " + this.message;
    }

    public List getSubGoals() {
        return Collections.EMPTY_LIST;
    }

    public int getExhaustedDepth() {
        return this.depth;
    }

    public void setExhaustedDepth(int n) {
        this.depth = n;
    }

    public void makeStep() {
    }

    public static boolean isValidCut(int n, DepthMonitor depthMonitor) {
        if (n == Integer.MAX_VALUE) {
            return true;
        }
        return n + depthMonitor.getCurrentDepth() >= depthMonitor.getMaxDepth();
    }

    public static boolean isValidCut(ReasoningStep reasoningStep, DepthMonitor depthMonitor) {
        if (!(reasoningStep instanceof Cut)) {
            return false;
        }
        Cut cut = (Cut)reasoningStep;
        return DefaultCut.isValidCut(cut.getExhaustedDepth(), depthMonitor);
    }
}

