/*
 * Decompiled with CFR 0.152.
 */
package jtp.proof;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import jtp.fol.CNFSentence;
import jtp.fol.Clause;
import jtp.fol.DefaultCNFSentence;
import jtp.fol.DefaultClause;
import jtp.fol.DefaultLiteral;
import jtp.fol.Literal;
import jtp.fol.SubstUtils;
import jtp.fol.SubstitutableList;
import jtp.fol.Symbol;
import jtp.fol.Variable;
import jtp.fol.kif.KIF2CNF;
import jtp.fol.parser.FirstOrderLogicTranslator;
import jtp.fol.parser.ParserBasedTranslator;
import jtp.proof.AndIntroductionInference;
import jtp.proof.Implication;
import jtp.proof.ImplicationConversionException;
import jtp.proof.Proof;

public class ProofUtil {
    static FirstOrderLogicTranslator kifTranslator = new ParserBasedTranslator(new KIF2CNF());

    public static Implication toImplication(CNFSentence cNFSentence) throws ImplicationConversionException {
        if (cNFSentence.clauses().size() != 1) {
            throw new ImplicationConversionException("Only CNF sentences with singleton clause are supported : " + cNFSentence);
        }
        Clause clause = (Clause)cNFSentence.clauses().iterator().next();
        ArrayList<Literal> arrayList = new ArrayList<Literal>(clause.literals().size());
        ArrayList<Literal> arrayList2 = new ArrayList<Literal>(clause.literals().size());
        Iterator iterator = clause.literals().iterator();
        while (iterator.hasNext()) {
            Literal literal = (Literal)iterator.next();
            if (literal.isPositive()) {
                arrayList.add(literal);
                continue;
            }
            arrayList2.add(literal);
        }
        if (arrayList.size() != 1) {
            throw new ImplicationConversionException("Only clauses with exactly one positive literal are supported : " + clause);
        }
        return new Implication((CNFSentence)arrayList.get(0), ProofUtil.invertPolarity(arrayList2));
    }

    public static List invertPolarity(List list) {
        ArrayList<DefaultLiteral> arrayList = new ArrayList<DefaultLiteral>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Literal literal = (Literal)iterator.next();
            arrayList.add(new DefaultLiteral(literal.getRelation(), literal.getArgs(), !literal.isPositive()));
        }
        return arrayList;
    }

    public static Object deReferenceGoal(Object object) {
        return object instanceof CNFSentence ? SubstUtils.deReferenceSentence((CNFSentence)object) : object;
    }

    public static String prettyPrintGoal(Object object, String string) {
        if (object instanceof Clause && !(object instanceof Literal)) {
            return ProofUtil.printClauseAsImplication((Clause)object, string);
        }
        return ProofUtil.prefixify(String.valueOf(object), string);
    }

    public static String prefixify(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        int n = 0;
        while (n < string.length()) {
            int n2 = string.indexOf(10, n);
            if (n2 < 0) {
                stringBuffer.append(string.substring(n));
                break;
            }
            stringBuffer.append(string.substring(n, n2 + 1)).append(string2);
            n = n2 + 1;
        }
        return stringBuffer.toString();
    }

    public static String printClauseAsImplication(Clause clause, String string) {
        if (clause.literals().size() == 0) {
            return string;
        }
        if (clause.literals().size() == 1) {
            return string + ProofUtil.printLiteral((Literal)clause.literals().iterator().next(), false);
        }
        Literal literal = null;
        Iterator iterator = clause.literals().iterator();
        while (iterator.hasNext()) {
            literal = (Literal)iterator.next();
            if (literal.isPositive()) break;
        }
        String string2 = "";
        String string3 = "";
        Iterator iterator2 = clause.literals().iterator();
        while (iterator2.hasNext()) {
            Literal literal2 = (Literal)iterator2.next();
            if (literal == literal2) {
                string2 = ProofUtil.printLiteral(literal2, false);
                continue;
            }
            string3 = string3 + "\n" + string + "     " + ProofUtil.printLiteral(literal2, true);
        }
        return string + "(<= " + string2 + string3 + ")";
    }

    public static String printLiteral(Literal literal, boolean bl) {
        boolean bl2 = bl ? !literal.isPositive() : literal.isPositive();
        Symbol symbol = literal.getRelation();
        List list = literal.getArgs();
        DefaultLiteral defaultLiteral = symbol.equals(Symbol.newSymbol("holds")) && list.get(0) instanceof Symbol ? new DefaultLiteral((Symbol)list.get(0), list.subList(1, list.size()), bl2) : new DefaultLiteral(symbol, list, bl2);
        return ((Object)defaultLiteral).toString();
    }

    public static CNFSentence instantiate(CNFSentence cNFSentence, Map map) {
        ArrayList<Clause> arrayList = new ArrayList<Clause>(cNFSentence.clauses().size());
        boolean bl = false;
        Iterator iterator = cNFSentence.clauses().iterator();
        while (iterator.hasNext()) {
            Clause clause = (Clause)iterator.next();
            ArrayList<Literal> arrayList2 = new ArrayList<Literal>(clause.literals().size());
            boolean bl2 = false;
            Iterator iterator2 = clause.literals().iterator();
            while (iterator2.hasNext()) {
                Literal literal = (Literal)iterator2.next();
                Literal literal2 = ProofUtil.instantiate(literal, map);
                bl2 = bl2 || literal != literal2;
                arrayList2.add(literal2);
            }
            bl = bl || bl2;
            arrayList.add(bl2 ? new DefaultClause(arrayList2) : clause);
        }
        return bl ? new DefaultCNFSentence(arrayList) : cNFSentence;
    }

    public static Literal instantiate(Literal literal, Map map) {
        List list = literal.getArgs();
        SubstitutableList substitutableList = (SubstitutableList)((SubstitutableList)list).substitute(map);
        if (substitutableList == list) {
            return literal;
        }
        return new DefaultLiteral(literal.getRelation(), substitutableList, literal.isPositive());
    }

    public static Proof simplify(Proof proof) {
        if (!(proof.getGoal() instanceof String)) {
            return proof;
        }
        List list = ((Proof)proof.getSubProofs().get(0)).getSubProofs();
        list.remove(0);
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        int n = 0;
        while (n < list.size()) {
            arrayList.add(ProofUtil.deReferenceGoal(((Proof)list.get(n)).getGoal()));
            ++n;
        }
        CNFSentence cNFSentence = ProofUtil.toConjunction(arrayList);
        AndIntroductionInference andIntroductionInference = new AndIntroductionInference(arrayList);
        Hashtable hashtable = new Hashtable();
        int n2 = 0;
        while (n2 < list.size()) {
            hashtable.putAll(((Proof)list.get(n2)).getBindings());
            ++n2;
        }
        return new Proof(cNFSentence, list, andIntroductionInference, hashtable);
    }

    public static CNFSentence toConjunction(List list) {
        String string = "";
        int n = 0;
        while (n < list.size()) {
            string = string + list.get(n).toString();
            ++n;
        }
        return kifTranslator.translate("(and" + string + ")");
    }

    public static Set getVars(Object object) {
        if (object instanceof CNFSentence) {
            return ProofUtil.getVars((CNFSentence)object);
        }
        return Collections.EMPTY_SET;
    }

    public static Set getVars(CNFSentence cNFSentence) {
        TreeSet treeSet = new TreeSet();
        Iterator iterator = cNFSentence.clauses().iterator();
        while (iterator.hasNext()) {
            treeSet.addAll(ProofUtil.getVars((Clause)iterator.next()));
        }
        return treeSet;
    }

    public static Set getVars(Clause clause) {
        TreeSet treeSet = new TreeSet();
        Iterator iterator = clause.literals().iterator();
        while (iterator.hasNext()) {
            treeSet.addAll(ProofUtil.getVars((Literal)iterator.next()));
        }
        return treeSet;
    }

    public static Set getVars(Literal literal) {
        TreeSet treeSet = new TreeSet();
        Iterator iterator = literal.getArgs().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Variable)) continue;
            treeSet.add(e);
        }
        return treeSet;
    }
}

