/*
 * Decompiled with CFR 0.152.
 */
package jtp.proof;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jtp.fol.Unifyable;
import jtp.proof.Inference;
import jtp.proof.ProofUtil;
import jtp.ui.AnswerUtil;
import jtp.util.ArrayMap;

public class Proof
implements Serializable {
    protected Object goal;
    protected Map bindings = ArrayMap.empty;
    protected List subGoals = Collections.EMPTY_LIST;
    protected List subProofs = null;
    protected Inference inference;
    static final Class EMPTY_LIST_CLASS = Collections.EMPTY_LIST.getClass();

    protected Proof() {
    }

    public Proof(Object object, List list, Inference inference, Map map) {
        this.goal = object;
        this.subProofs = list;
        this.subGoals = new SGList();
        this.inference = inference;
        this.bindings = map;
    }

    public Object getGoal() {
        return this.goal;
    }

    public List getSubProofs() {
        return this.subProofs;
    }

    public List getSubGoals() {
        return this.subGoals;
    }

    public Inference getInference() {
        return this.inference;
    }

    public Map getBindings() {
        return this.bindings;
    }

    public String toString() {
        return this.toString("/", "");
    }

    public String toString(String string, String string2) {
        Object object;
        String string3;
        String string4 = string2 + "[" + string + "]:\n";
        try {
            string3 = AnswerUtil.shortenNS(ProofUtil.prettyPrintGoal(ProofUtil.deReferenceGoal(this.getGoal()), string2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string3 = String.valueOf(this.getGoal());
        }
        string4 = string4 + string3 + "\n" + string2 + "<<\n";
        try {
            string3 = AnswerUtil.shortenNS(this.getInference().toString(this, string2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string3 = this.getInference().toString(this, string2);
        }
        string4 = string4 + string3;
        string3 = "";
        Map map = this.getBindings();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            object = map.get(k);
            string3 = string3 + "\n" + string2 + k + " : " + (object instanceof Unifyable ? ((Unifyable)object).deReferenceVariables() : object);
        }
        if (!string3.equals("")) {
            string4 = string4 + "\n" + string2 + "Inference Bindings: " + string3;
        }
        string3 = "";
        int n = 1;
        object = this.subProofs.iterator();
        while (object.hasNext()) {
            string3 = string3 + "\n" + ((Proof)object.next()).toString(string + "." + n, string2 + "  ");
            ++n;
        }
        if (n > 1) {
            string4 = string4 + "\n" + string2 + "{{" + string3;
        }
        return string4;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.subGoals != null && this.subGoals.getClass() == EMPTY_LIST_CLASS) {
            this.subGoals = Collections.EMPTY_LIST;
        }
        if (this.subProofs != null && this.subProofs.getClass() == EMPTY_LIST_CLASS) {
            this.subProofs = Collections.EMPTY_LIST;
        }
    }

    private class SGList
    extends AbstractList {
        private SGList() {
        }

        public int size() {
            return Proof.this.getSubProofs().size();
        }

        public Object get(int n) {
            return ((Proof)Proof.this.getSubProofs().get(n)).getGoal();
        }
    }
}

