/*
 * Decompiled with CFR 0.152.
 */
package jtp.modelim;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jtp.ReasoningStep;
import jtp.ReasoningStepIterator;

class Ring {
    ReasoningStep rs;
    ReasoningStepIterator provider;
    Object goal;
    Ring down;
    Ring up;
    Ring right;
    Ring left;
    int expectedChildren;
    int nAssumptions = 0;
    boolean proved = false;

    public Ring(ReasoningStep reasoningStep, ReasoningStepIterator reasoningStepIterator, Object object, Ring ring) {
        this.rs = reasoningStep;
        this.provider = reasoningStepIterator;
        this.down = null;
        this.goal = object;
        this.up = ring;
        this.right = this;
        this.left = this;
        this.expectedChildren = reasoningStep != null ? reasoningStep.getSubGoals().size() - reasoningStep.getSubProofs().size() : 1;
    }

    public Ring addChild(ReasoningStep reasoningStep, Object object, ReasoningStepIterator reasoningStepIterator) {
        Ring ring = new Ring(reasoningStep, reasoningStepIterator, object, this);
        if (this.down == null) {
            this.down = ring;
        } else {
            this.down.addSibling(ring);
        }
        return ring;
    }

    public Ring removeLastChild() {
        if (this.down == null) {
            throw new NoSuchElementException();
        }
        if (this.down.left == this.down) {
            Ring ring = this.down;
            this.down = null;
            return ring;
        }
        Ring ring = this.down.left;
        this.down.left.left.right = this.down;
        this.down.left = this.down.left.left;
        return ring;
    }

    public int getChildrenCount() {
        if (this.down == null) {
            return 0;
        }
        int n = 1;
        Ring ring = this.down.right;
        while (ring != this.down) {
            ++n;
            ring = ring.right;
        }
        return n;
    }

    public void addSibling(Ring ring) {
        this.left.right = ring;
        ring.left = this.left;
        ring.right = this;
        this.left = ring;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" { ").append(this.goal);
        if (this.down != null) {
            stringBuffer.append(" ").append(this.down);
            Ring ring = this.down.right;
            while (ring != this.down) {
                stringBuffer.append(" ").append(ring);
                ring = ring.right;
            }
        }
        stringBuffer.append(" } ");
        return stringBuffer.toString();
    }

    public void makeAssumption(int n) {
        Ring ring = this;
        int n2 = 0;
        while (n2 < n) {
            ++ring.nAssumptions;
            ring = ring.up;
            ++n2;
        }
    }

    public void removeAssumption(int n) {
        Ring ring = this;
        int n2 = 0;
        while (n2 < n) {
            --ring.nAssumptions;
            ring = ring.up;
            ++n2;
        }
    }

    static class Path
    extends AbstractList {
        Ring root;
        Ring leaf;
        int size = 0;

        Path(Ring ring) {
            this.root = ring;
            this.leaf = ring;
        }

        public void setLeaf(Ring ring) {
            this.leaf = ring;
            this.size = 0;
            Ring ring2 = ring;
            while (ring2 != this.root) {
                ++this.size;
                ring2 = ring2.up;
            }
        }

        public Ring getRoot() {
            return this.root;
        }

        public Ring getLeaf() {
            return this.leaf;
        }

        public int size() {
            return this.size;
        }

        public Object get(int n) {
            if (n >= this.size) {
                throw new NoSuchElementException();
            }
            Ring ring = this.leaf;
            while (n > 0) {
                ring = ring.up;
                --n;
            }
            return ring.goal;
        }

        public Iterator iterator() {
            return new Iterator(this){
                Ring r;
                private final /* synthetic */ Path this$0;
                {
                    this.this$0 = path;
                    this.r = this.this$0.leaf;
                }

                public boolean hasNext() {
                    return this.r != this.this$0.root;
                }

                public Object next() {
                    Object object = this.r.goal;
                    this.r = this.r.up;
                    return object;
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

