/*
 * Decompiled with CFR 0.152.
 */
package jtp.modelim;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jtp.Cut;
import jtp.Dispatcher;
import jtp.Reasoner;
import jtp.ReasoningException;
import jtp.ReasoningStep;
import jtp.ReasoningStepIterator;
import jtp.context.DepthMonitor;
import jtp.context.Tracer;
import jtp.disp.SequentialDispatcher;
import jtp.modelim.AncestorCycleCutReasoner;
import jtp.modelim.LinearReductionReasoner;
import jtp.modelim.Ring;
import jtp.rs.ArrayReasoningStepIterator;
import jtp.rs.DefaultCut;
import jtp.rs.ReasoningStepStub;
import jtp.util.PropertyImporter;

public class ModelEliminationReasoner
extends PropertyImporter
implements Reasoner {
    int currentReductions = 0;
    Tracer tracer;
    Dispatcher askingDispatcher;
    Reasoner intermediateResultDispatcher;
    DepthMonitor depthMonitor;

    public ModelEliminationReasoner() {
        this.setImportedProperties(new String[]{"tracer", "askingDispatcher", "intermediateResultDispatcher"});
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public void setTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    public Dispatcher getAskingDispatcher() {
        return this.askingDispatcher;
    }

    public void setAskingDispatcher(Dispatcher dispatcher) {
        this.askingDispatcher = dispatcher;
    }

    public Reasoner getIntermediateResultDispatcher() {
        return this.intermediateResultDispatcher;
    }

    public void setIntermediateResultDispatcher(Reasoner reasoner) {
        this.intermediateResultDispatcher = reasoner;
    }

    public DepthMonitor getDepthMonitor() {
        return this.depthMonitor;
    }

    public void setDepthMonitor(DepthMonitor depthMonitor) {
        this.depthMonitor = depthMonitor;
    }

    public ReasoningStepIterator process(Object object) throws ReasoningException {
        ProofCollector proofCollector = new ProofCollector(object);
        return proofCollector;
    }

    public boolean acceptable(Object object) {
        return true;
    }

    protected class ProofCollector
    implements ReasoningStepIterator {
        ReasoningStep ps;
        IntermediateResult intRslt = new IntermediateResult();
        DefaultCut exhaustionCut = new DefaultCut("Search space exhausted");
        List goals = new ArrayList();
        int lev;
        int initTracerDepth;
        ReasoningStepIterator currentProvider;
        private transient List subgoals;
        Dispatcher bus;
        Ring root;
        Ring leaf;
        Ring.Path goalTreeStack;

        ProofCollector(Object object) {
            this.lev = ModelEliminationReasoner.this.depthMonitor.getCurrentDepth();
            this.initTracerDepth = ModelEliminationReasoner.this.tracer.getTraceDepth();
            this.currentProvider = null;
            this.subgoals = new ArrayList();
            this.bus = new SequentialDispatcher();
            this.goals.add(object);
            this.bus.addReasoner(new DMReasoner());
            this.root = new Ring(null, null, null, null);
            this.goalTreeStack = new Ring.Path(this.root);
            this.leaf = this.root;
            AncestorCycleCutReasoner ancestorCycleCutReasoner = new AncestorCycleCutReasoner(this.goalTreeStack);
            ancestorCycleCutReasoner.setDepthMonitor(ModelEliminationReasoner.this.getDepthMonitor());
            this.bus.addReasoner(ancestorCycleCutReasoner);
            this.bus.addReasoner(new LinearReductionReasoner(this.goalTreeStack));
            this.bus.addReasoner(ModelEliminationReasoner.this.askingDispatcher);
        }

        public ReasoningStep next() throws ReasoningException {
            if (this.root.down != null) {
                this.deFormProofTree(this.root.down);
                this.backtrack();
            }
            while (true) {
                if (this.goals.isEmpty()) {
                    if (ModelEliminationReasoner.this.tracer.getVerbosityLevel() > 0) {
                        this.log("Found a solution!");
                    }
                    return this.formProofTree(this.root.down);
                }
                Object e = this.goals.get(this.goals.size() - 1);
                if (ModelEliminationReasoner.this.tracer.getVerbosityLevel() > 0) {
                    this.log("Processing goal: " + e);
                }
                if (this.currentProvider == null) {
                    this.currentProvider = this.bus.process(e);
                }
                ReasoningStep reasoningStep = this.currentProvider.next();
                int n = ModelEliminationReasoner.this.depthMonitor.getMaxDepth() - this.lev;
                if (reasoningStep instanceof Cut) {
                    if (ModelEliminationReasoner.this.tracer.getVerbosityLevel() > 2) {
                        this.log(e + ": cut: " + reasoningStep.tracePrint());
                    }
                    if (!DefaultCut.isValidCut(reasoningStep, ModelEliminationReasoner.this.depthMonitor)) continue;
                    n = ((Cut)reasoningStep).getExhaustedDepth();
                    reasoningStep = null;
                }
                if (reasoningStep == null) {
                    if (ModelEliminationReasoner.this.intermediateResultDispatcher != null) {
                        this.notifyOfExhaustion(e, n);
                    }
                    if (this.root.down == null) {
                        return null;
                    }
                    this.backtrack();
                    continue;
                }
                this.advance(reasoningStep);
            }
        }

        private void advance(ReasoningStep reasoningStep) throws ReasoningException {
            if (ModelEliminationReasoner.this.tracer.getVerbosityLevel() > 1) {
                this.log("Advancing: goal " + reasoningStep.getGoal() + ": " + reasoningStep.tracePrint());
            }
            Object e = this.goals.remove(this.goals.size() - 1);
            Ring ring = this.leaf.addChild(reasoningStep, e, this.currentProvider);
            if (reasoningStep instanceof LinearReductionReasoner.LinearReductionProofStep) {
                ring.makeAssumption(((LinearReductionReasoner.LinearReductionProofStep)reasoningStep).assumptionDepth);
            }
            this.leaf = this.advance(this.leaf.down.left);
            this.goalTreeStack.setLeaf(this.leaf);
            this.lev = this.goalTreeStack.size();
            this.currentProvider = null;
            if (reasoningStep.getSubGoals().size() > reasoningStep.getSubProofs().size()) {
                Iterator iterator = reasoningStep.getSubGoals().iterator();
                while (iterator.hasNext()) {
                    this.subgoals.add(iterator.next());
                }
                int n = this.subgoals.size() - 1;
                while (n >= reasoningStep.getSubProofs().size()) {
                    this.goals.add(this.subgoals.remove(n));
                    --n;
                }
                this.subgoals.clear();
            }
        }

        private void backtrack() throws ReasoningException {
            Ring ring = this.backtrack(this.leaf);
            ReasoningStep reasoningStep = ring.rs;
            Object object = ring.goal;
            this.leaf = ring.up;
            if (ModelEliminationReasoner.this.tracer.getVerbosityLevel() > 2) {
                this.log("Bactracking from: goal: " + reasoningStep.getGoal() + ": " + reasoningStep.tracePrint());
            }
            reasoningStep.backtrack();
            if (reasoningStep instanceof LinearReductionReasoner.LinearReductionProofStep) {
                ring.removeAssumption(((LinearReductionReasoner.LinearReductionProofStep)reasoningStep).assumptionDepth);
            }
            if (ring.proved && reasoningStep.getBindings().isEmpty()) {
                if (ModelEliminationReasoner.this.tracer.getVerbosityLevel() > 2) {
                    this.log("Last proof step set no restrictions on the goal, further search unnecessary.");
                }
                this.currentProvider = ArrayReasoningStepIterator.empty;
                if (ModelEliminationReasoner.this.intermediateResultDispatcher != null) {
                    this.notifyOfExhaustion(object, Integer.MAX_VALUE);
                }
            } else {
                this.currentProvider = ring.provider;
            }
            this.goalTreeStack.setLeaf(this.leaf);
            this.lev = this.goalTreeStack.size();
            if (reasoningStep.getSubGoals().size() > reasoningStep.getSubProofs().size()) {
                int n = reasoningStep.getSubGoals().size() - reasoningStep.getSubProofs().size();
                int n2 = 0;
                while (n2 < n) {
                    this.goals.remove(this.goals.size() - 1);
                    ++n2;
                }
            }
            this.goals.add(object);
        }

        private void deFormProofTree(Ring ring) {
            if (ring.down != null) {
                this.deFormProofTree(ring.down);
                Ring ring2 = ring.down.right;
                while (ring2 != ring.down) {
                    this.deFormProofTree(ring2);
                    ring2 = ring2.right;
                }
                ReasoningStep reasoningStep = ring.rs;
                List list = reasoningStep.getSubProofs();
                int n = reasoningStep.getSubGoals().size() - ring.expectedChildren;
                int n2 = list.size() - 1;
                while (n2 >= n) {
                    list.remove(n2);
                    --n2;
                }
            }
        }

        private ReasoningStep formProofTree(Ring ring) {
            if (ring.down != null) {
                List list = ring.rs.getSubProofs();
                list.add(this.formProofTree(ring.down));
                Ring ring2 = ring.down.right;
                while (ring2 != ring.down) {
                    list.add(this.formProofTree(ring2));
                    ring2 = ring2.right;
                }
            }
            return ring.rs;
        }

        private Ring advance(Ring ring) throws ReasoningException {
            while (ring.getChildrenCount() >= ring.expectedChildren) {
                ring.proved = true;
                if (ModelEliminationReasoner.this.intermediateResultDispatcher != null && ring.nAssumptions == 0) {
                    this.notifyOfIntermediateResult(ring);
                }
                ring = ring.up;
                if (ring.up == null) break;
            }
            return ring;
        }

        public Ring backtrack(Ring ring) {
            while (ring.down != null) {
                ring = ring.down.left;
            }
            ring = ring.up;
            return ring.removeLastChild();
        }

        private void log(Object object) {
            ModelEliminationReasoner.this.tracer.setTraceDepth(this.initTracerDepth + this.lev);
            ModelEliminationReasoner.this.tracer.trace(object);
        }

        protected void notifyOfExhaustion(Object object, int n) throws ReasoningException {
            this.exhaustionCut.setGoal(object);
            this.exhaustionCut.setExhaustedDepth(n);
            this.notifyOfIntermediateResult(this.exhaustionCut);
            this.exhaustionCut.setGoal(null);
        }

        protected void notifyOfIntermediateResult(Ring ring) throws ReasoningException {
            this.intRslt.setNode(ring);
            this.notifyOfIntermediateResult(this.intRslt);
            if (this.intRslt.formedProof) {
                this.deFormProofTree(this.intRslt.node);
            }
            this.intRslt.release();
        }

        protected void notifyOfIntermediateResult(ReasoningStep reasoningStep) throws ReasoningException {
            ReasoningStepIterator reasoningStepIterator = ModelEliminationReasoner.this.intermediateResultDispatcher.process(reasoningStep);
            while (reasoningStepIterator.next() != null) {
            }
        }

        class IntermediateResult
        extends ReasoningStepStub {
            Ring node;
            boolean formedProof = false;

            IntermediateResult() {
            }

            public void setNode(Ring ring) {
                this.node = ring;
                this.goal = this.node.rs.getGoal();
            }

            public void release() {
                this.formedProof = false;
                this.goal = null;
                this.node = null;
            }

            public ReasoningStep retrieveReasoningStep() {
                this.formedProof = true;
                return ProofCollector.this.formProofTree(this.node);
            }
        }

        class DMReasoner
        implements Reasoner {
            DMReasoner() {
            }

            public ReasoningStepIterator process(Object object) {
                if (!((ProofCollector)ProofCollector.this).ModelEliminationReasoner.this.depthMonitor.setCurrentDepth(ProofCollector.this.lev)) {
                    DefaultCut defaultCut = new DefaultCut("Depth limit reached", ((ProofCollector)ProofCollector.this).ModelEliminationReasoner.this.depthMonitor.getCurrentDepth());
                    defaultCut.setGoal(object);
                    return new ArrayReasoningStepIterator(defaultCut);
                }
                return ArrayReasoningStepIterator.empty;
            }

            public boolean acceptable(Object object) {
                return true;
            }
        }
    }
}

