/*
 * Decompiled with CFR 0.152.
 */
package jtp.modelim;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import jtp.Dispatcher;
import jtp.Reasoner;
import jtp.ReasoningException;
import jtp.ReasoningStep;
import jtp.ReasoningStepIterator;
import jtp.context.DefaultDepthMonitor;
import jtp.context.DepthMonitor;
import jtp.context.Tracer;
import jtp.rs.ArrayReasoningStepIterator;
import jtp.util.PropertyImporter;
import jtp.util.ReplacementHashSet;

public class BreadthFirstForwardReasoner
extends PropertyImporter
implements Reasoner {
    Tracer tracer;
    Dispatcher tellingDispatcher;
    DepthMonitor depthMonitor;
    int maxDepth;

    public Tracer getTracer() {
        return this.tracer;
    }

    public void setTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    public Dispatcher getTellingDispatcher() {
        return this.tellingDispatcher;
    }

    public void setTellingDispatcher(Dispatcher dispatcher) {
        this.tellingDispatcher = dispatcher;
    }

    public DepthMonitor getDepthMonitor() {
        return this.depthMonitor;
    }

    public void setDepthMonitor(DepthMonitor depthMonitor) {
        this.depthMonitor = depthMonitor;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int n) {
        this.maxDepth = n;
    }

    public BreadthFirstForwardReasoner() {
        this.setImportedProperties(new String[]{"maxDepth", "tracer", "tellingDispatcher"});
    }

    public ReasoningStepIterator process(Object object) throws ReasoningException {
        this.setDepthMonitor(new DefaultDepthMonitor(this.getMaxDepth()));
        return new GoalQueue(object);
    }

    public boolean acceptable(Object object) {
        return object instanceof ReasoningStep;
    }

    private void log(Object object) {
        this.tracer.setTraceDepth(this.depthMonitor.getCurrentDepth());
        this.tracer.trace(object);
    }

    class GoalQueue
    implements ReasoningStepIterator {
        Set history = new ReplacementHashSet(101);
        List goalExpansions = new LinkedList();
        ReasoningStepIterator currentGoalExpansion = ArrayReasoningStepIterator.empty;
        int levelBoundary = 0;
        int count = 0;

        GoalQueue(Object object) throws ReasoningException {
            this.add((ReasoningStep)object);
        }

        public ReasoningStep next() throws ReasoningException {
            ReasoningStep reasoningStep = null;
            BreadthFirstForwardReasoner.this.tracer.setTraceDepth(BreadthFirstForwardReasoner.this.depthMonitor.getCurrentDepth() + 1);
            while ((reasoningStep = this.currentGoalExpansion.next()) == null) {
                if (BreadthFirstForwardReasoner.this.tracer.getVerbosityLevel() > 0) {
                    BreadthFirstForwardReasoner.this.log("New input expansion");
                }
                if (this.goalExpansions.isEmpty()) {
                    if (BreadthFirstForwardReasoner.this.tracer.getVerbosityLevel() > 0) {
                        BreadthFirstForwardReasoner.this.log("No more inputs");
                    }
                    return null;
                }
                if (this.count >= this.levelBoundary) {
                    if (BreadthFirstForwardReasoner.this.tracer.getVerbosityLevel() > 0) {
                        BreadthFirstForwardReasoner.this.log("Incrementing current input level");
                    }
                    if (!BreadthFirstForwardReasoner.this.depthMonitor.incrementCurrentDepth(1)) {
                        if (BreadthFirstForwardReasoner.this.tracer.getVerbosityLevel() > 0) {
                            BreadthFirstForwardReasoner.this.log("Depth limit reached");
                        }
                        return null;
                    }
                    this.levelBoundary = this.count + this.goalExpansions.size();
                    if (BreadthFirstForwardReasoner.this.tracer.getVerbosityLevel() > 0) {
                        BreadthFirstForwardReasoner.this.log("Input sources on level " + BreadthFirstForwardReasoner.this.depthMonitor.getCurrentDepth() + ": " + this.goalExpansions.size());
                    }
                    BreadthFirstForwardReasoner.this.tracer.setTraceDepth(BreadthFirstForwardReasoner.this.depthMonitor.getCurrentDepth() + 1);
                }
                ++this.count;
                this.currentGoalExpansion = (ReasoningStepIterator)this.goalExpansions.remove(0);
            }
            this.add(reasoningStep);
            return reasoningStep;
        }

        public void add(ReasoningStep reasoningStep) throws ReasoningException {
            if (BreadthFirstForwardReasoner.this.tracer.getVerbosityLevel() > 0) {
                BreadthFirstForwardReasoner.this.log("Input: " + reasoningStep.tracePrint());
            }
            if (!this.history.contains(reasoningStep)) {
                this.history.add(reasoningStep);
                if (BreadthFirstForwardReasoner.this.tracer.getVerbosityLevel() > 1) {
                    BreadthFirstForwardReasoner.this.log("Adding consequences for " + reasoningStep.getGoal() + " to the queue");
                }
                BreadthFirstForwardReasoner.this.tracer.setTraceDepth(BreadthFirstForwardReasoner.this.depthMonitor.getCurrentDepth() + 1);
                this.goalExpansions.add(BreadthFirstForwardReasoner.this.tellingDispatcher.process(reasoningStep));
            }
        }
    }
}

