/*
 * Decompiled with CFR 0.152.
 */
package jtp.iw;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jtp.DirectAssertion;
import jtp.demod.DemodulationReasoningStep;
import jtp.frame.EnumeratingReasoner;
import jtp.frame.InferredValueReasoningStep;
import jtp.frame.ValueLinkCreationReasoningStep;
import jtp.frame.fc.RuleCreationReasoningStep;
import jtp.frame.fc.RuleInstallationProofStep;
import jtp.frame.listen.VCListenerCreationReasoningStep;
import jtp.frame.vc.MembershipProofStep;
import jtp.func.FunctionProofStep;
import jtp.gmp.ModusPonensProofStep;
import jtp.iw.GetURLContents;
import jtp.modelim.AskingQueryProcessor;
import jtp.proof.AxiomInference;
import jtp.proof.Proof;
import jtp.proof.ProofUtil;
import jtp.rs.TranslationReasoningStep;
import jtp.time.demod.TimePointMappingReasoningStep;
import jtp.ui.rs.KIFSentenceFormatPlain;
import jtp.util.ArrayMap;

public class IWUtils {
    static String _registrarAddress = "http://belo.stanford.edu:8080/iwregistrar/";
    static String _addAnswers = _registrarAddress + "AddAnswers";
    static String _createNodeSet = _registrarAddress + "CreateNodeSet";
    static String _createQuery = _registrarAddress + "CreateQuery";
    static String _getURIFromURL = _registrarAddress + "GetURIFromURL";
    static String _newRegistrarAddress = "http://www.ksl.stanford.edu/software/IW/newregistry/DPR/";
    static String DEMOD = _newRegistrarAddress + "Demod.daml#Demod";
    static String GMP = _newRegistrarAddress + "GMP.daml#GMP";
    static String MEMBER = _newRegistrarAddress + "Member.daml#Member";
    static String REFORMULATION = _newRegistrarAddress + "Reformulation.daml#Reformulation";
    static String SUBSUMPTION = _newRegistrarAddress + "Subsump.daml#Subsump";
    static String TIMEPOINT = _newRegistrarAddress + "TimePoint.daml#TimePoint";
    static String TIMEPOINTMAP = _newRegistrarAddress + "TimePointMap.daml#TimePointMap";
    static String TOLD = _newRegistrarAddress + "Told.daml#Told";
    static String FUNC = _newRegistrarAddress + "Func.daml#Func";
    static String JTPURI = "http://www.ksl.stanford.edu/software/IW/newregistry/IE/JTP.daml#JTP";

    public static Set getInferenceVars(Proof proof) {
        if (proof.getInference() instanceof AxiomInference) {
            return Collections.EMPTY_SET;
        }
        HashSet hashSet = new HashSet();
        hashSet.addAll(ProofUtil.getVars(ProofUtil.deReferenceGoal(proof.getGoal())));
        int n = 0;
        while (n < proof.getSubProofs().size()) {
            hashSet.addAll(ProofUtil.getVars(ProofUtil.deReferenceGoal(((Proof)proof.getSubProofs().get(n)).getGoal())));
            ++n;
        }
        HashSet<String> hashSet2 = new HashSet<String>(hashSet.size() * 2);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            hashSet2.add(iterator.next().toString());
        }
        return hashSet2;
    }

    public static Map getInferenceBindings(Proof proof) {
        Map map = IWUtils.getLocalBindings(proof);
        Set set = IWUtils.getInferenceVars(proof);
        ArrayMap arrayMap = new ArrayMap(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Object v = map.get(e);
            if (v == null) continue;
            arrayMap.put(e, v);
        }
        return arrayMap;
    }

    protected static Map getIWBindings(Proof proof) {
        HashMap hashMap = new HashMap();
        Iterator iterator = proof.getBindings().keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            hashMap.putAll(IWUtils.getLocalBindings(proof));
        }
        int n = 0;
        while (n < proof.getSubProofs().size()) {
            hashMap.putAll(IWUtils.getLocalBindings((Proof)proof.getSubProofs().get(n)));
            ++n;
        }
        return hashMap;
    }

    protected static Map getLocalBindings(Proof proof) {
        HashMap hashMap = new HashMap();
        Iterator iterator = proof.getBindings().keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            hashMap.put(k.toString(), proof.getBindings().get(k));
        }
        int n = 0;
        while (n < proof.getSubProofs().size()) {
            hashMap.putAll(IWUtils.getContextBindings((Proof)proof.getSubProofs().get(n)));
            ++n;
        }
        return hashMap;
    }

    public static Map getContextBindings(Proof proof) {
        Map map = IWUtils.getLocalBindings(proof);
        Iterator iterator = IWUtils.getInferenceVars(proof).iterator();
        while (iterator.hasNext()) {
            map.remove(iterator.next());
        }
        return map;
    }

    public static void printErrorMessage(String string) {
        if (string == null || string.equals("") || string.indexOf("<RC>") == -1 || string.indexOf("</RC>") == -1) {
            System.out.println("Tagged file has not response code.");
        } else {
            String string2 = string.substring(string.indexOf("<RC>") + 4, string.indexOf("</RC>"));
            if (!string2.equals("00")) {
                int n = string.indexOf("<errormsg>");
                int n2 = string.indexOf("</errormsg>");
                if (n != -1 && n2 != 1 && n + 10 > n2) {
                    System.out.println("Error message is malformed");
                } else {
                    System.out.println("Error message: " + string.substring(n + 10, n2));
                }
            }
        }
    }

    public static String filterTag(String string, String string2) {
        if (string == null || string.equals("") || string2 == null || string2.equals("")) {
            return "Tagged file is empty";
        }
        IWUtils.printErrorMessage(string2);
        String string3 = "<" + string + ">";
        String string4 = "</" + string + ">";
        if (string2.indexOf(string3) == -1 || string2.indexOf(string4) == -1) {
            return "";
        }
        return string2.substring(string2.indexOf(string3) + string3.length(), string2.indexOf(string4));
    }

    public static String generateQuery(Proof proof, String string, String string2, Hashtable hashtable, String string3, int n) {
        KIFSentenceFormatPlain kIFSentenceFormatPlain = new KIFSentenceFormatPlain();
        String string4 = string + string3 + ".daml#" + string3;
        try {
            String string5;
            Object object;
            String string6;
            String string7 = "";
            string7 = string7 + "qy=" + URLEncoder.encode(string4, "UTF-8");
            string7 = string7 + "&ie=" + URLEncoder.encode(JTPURI, "UTF-8");
            if (proof == null || proof.getGoal() == null) {
                string7 = string7 + "&qycont=EMPTY_QUERY";
            } else {
                string6 = proof.getGoal().toString();
                string7 = string7 + "&qycont=" + URLEncoder.encode(string6, "UTF-8");
            }
            string6 = "";
            int n2 = 1;
            while (n2 < n + 1) {
                object = string3 + "ns" + n2 + "_0";
                string5 = string + (String)object + ".daml#" + (String)object;
                string6 = string6 + "," + URLEncoder.encode(string5, "UTF-8");
                ++n2;
            }
            if (!string6.equals("")) {
                string7 = string7 + "&nslist=" + string6.substring(1);
            }
            object = new URL(_createQuery);
            string5 = IWUtils.filterTag("result", GetURLContents.Post(((URL)object).toString(), string7, "application/x-www-form-urlencoded"));
            System.out.println("Writing " + string4);
            if (string2 != null) {
                try {
                    byte[] byArray = string5.toString().getBytes();
                    String string8 = string2 + string3 + ".daml";
                    File file = new File(string8);
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    fileOutputStream.write(byArray);
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException.toString());
                }
            }
            if (hashtable != null) {
                hashtable.put(string4, string5.toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string4;
    }

    public static void generateNodeSet(Proof proof, List list, int n, String string, String string2, Hashtable hashtable, String string3) {
        KIFSentenceFormatPlain kIFSentenceFormatPlain = new KIFSentenceFormatPlain();
        try {
            Object object;
            String string4;
            Object object2;
            Object object3;
            int n2 = list.indexOf(proof);
            String string5 = "";
            String string6 = string3 + "ns" + n + "_" + n2;
            String string7 = string3 + "ns" + n + "_0";
            String string8 = string + string6 + ".daml#" + string6;
            String string9 = string + string7 + ".daml#" + string7;
            String string10 = string + string3 + ".daml#" + string3;
            List list2 = proof.getSubProofs();
            string5 = string5 + "ns=" + URLEncoder.encode(string8, "UTF-8");
            string5 = string5 + "&ie=" + URLEncoder.encode(JTPURI, "UTF-8");
            String string11 = proof.getGoal().toString();
            string5 = string5 + "&nscont=" + URLEncoder.encode(string11, "UTF-8");
            if (n2 == 0) {
                string5 = string5 + "&qy=" + URLEncoder.encode(string10, "UTF-8");
            }
            if (n2 > 0) {
                string5 = string5 + "&nsroot=" + URLEncoder.encode(string9, "UTF-8");
            }
            String string12 = "";
            if (proof instanceof DirectAssertion || list2 == null || list2.size() == 0) {
                string12 = TOLD;
            } else if (proof instanceof EnumeratingReasoner.ProofStep || proof instanceof TranslationReasoningStep || proof instanceof RuleCreationReasoningStep || proof instanceof MembershipProofStep || proof instanceof ValueLinkCreationReasoningStep || proof instanceof VCListenerCreationReasoningStep || proof instanceof InferredValueReasoningStep || proof instanceof ModusPonensProofStep) {
                string12 = GMP;
            } else if (proof instanceof DemodulationReasoningStep) {
                string12 = DEMOD;
            } else if (proof instanceof FunctionProofStep) {
                string12 = FUNC;
            } else if (proof instanceof RuleInstallationProofStep) {
                string12 = MEMBER;
            } else if (proof instanceof TimePointMappingReasoningStep) {
                string12 = TIMEPOINTMAP;
            } else if (proof instanceof AskingQueryProcessor.ReformulationProofStep) {
                string12 = REFORMULATION;
            } else {
                System.out.println("Error, unrecognized inference rule.");
            }
            if (!string12.equals("")) {
                string5 = string5 + "&rl=" + URLEncoder.encode(string12, "UTF-8");
            }
            String string13 = "";
            String string14 = "";
            Iterator iterator = IWUtils.getIWBindings(proof).entrySet().iterator();
            while (iterator.hasNext()) {
                object3 = iterator.next();
                string13 = string13 + "," + URLEncoder.encode(object3.getKey().toString(), "UTF-8");
                string14 = string14 + "," + URLEncoder.encode(object3.getValue().toString(), "UTF-8");
            }
            if (!string13.equals("") && !string14.equals("")) {
                string5 = string5 + "&trlist=" + string13.substring(1);
                string5 = string5 + "&vrlist=" + string14.substring(1);
            }
            if (list2 != null && list2.size() > 0) {
                object3 = "";
                object2 = list2.iterator();
                while (object2.hasNext()) {
                    string4 = string3 + "ns" + n + "_" + list.indexOf((Proof)object2.next());
                    object = string + string4 + ".daml#" + string4;
                    object3 = (String)object3 + "," + URLEncoder.encode((String)object, "UTF-8");
                }
                if (!((String)object3).equals("") && !((String)object3).equals("")) {
                    string5 = string5 + "&nsant=" + ((String)object3).substring(1);
                }
            }
            object3 = "";
            if (proof instanceof DirectAssertion) {
                if (((DirectAssertion)proof).getKBLocation() != null && !((DirectAssertion)proof).getKBLocation().toString().equals("")) {
                    object3 = ((DirectAssertion)proof).getKBLocation().toString();
                }
            } else if (proof instanceof RuleCreationReasoningStep) {
                if (((RuleCreationReasoningStep)proof).getKBLocation() != null && !((RuleCreationReasoningStep)proof).getKBLocation().toString().equals("")) {
                    object3 = ((RuleCreationReasoningStep)proof).getKBLocation().toString();
                }
            } else if (proof instanceof VCListenerCreationReasoningStep && ((VCListenerCreationReasoningStep)proof).getKBLocation() != null && !((VCListenerCreationReasoningStep)proof).getKBLocation().toString().equals("")) {
                object3 = ((VCListenerCreationReasoningStep)proof).getKBLocation().toString();
            }
            if (!((String)object3).equals("") && (object2 = IWUtils.filterTag("result", GetURLContents.exec(_getURIFromURL + "?url=" + URLEncoder.encode((String)object3, "UTF-8")))) != null && !((String)object2).equals("")) {
                string5 = string5 + "&kslist=" + (String)object2;
            }
            object2 = new URL(_createNodeSet);
            string4 = IWUtils.filterTag("result", GetURLContents.Post(((URL)object2).toString(), string5, "application/x-www-form-urlencoded"));
            System.out.println("Writing " + string8);
            if (string2 != null) {
                try {
                    object = string4.toString().getBytes();
                    String string15 = string2 + string6 + ".daml";
                    File file = new File(string15);
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    fileOutputStream.write((byte[])object);
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException.toString());
                }
            }
            if (hashtable != null) {
                hashtable.put(string8, string4.toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

