/*
 * Decompiled with CFR 0.152.
 */
package jtp.iw;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jtp.ReasoningStep;
import jtp.ReasoningStepIterator;
import jtp.fol.CNFSentence;
import jtp.fol.Clause;
import jtp.fol.Literal;
import jtp.fol.Unifyable;
import jtp.iw.IWUtils;
import jtp.proof.Proof;
import jtp.rs.ArrayReasoningStepIterator;
import jtp.rs.RSUtils;

public class IWHandler {
    String _queryName = null;
    String _baseNodeSetURI = null;
    String _baseNodeSetPath = null;
    Hashtable _baseNodeSetHash = null;
    ReasoningStepIterator rsi = null;
    List _steps = new ArrayList(10000);

    public IWHandler(ReasoningStep reasoningStep, String string, String string2, String string3) {
        this.rsi = new ArrayReasoningStepIterator(reasoningStep);
        this._queryName = string;
        this._baseNodeSetURI = string2;
        this._baseNodeSetPath = string3;
        this._baseNodeSetHash = null;
    }

    public IWHandler(ReasoningStepIterator reasoningStepIterator, String string, String string2, String string3) {
        this.rsi = reasoningStepIterator;
        this._queryName = string;
        this._baseNodeSetURI = string2;
        this._baseNodeSetPath = string3;
        this._baseNodeSetHash = null;
    }

    public IWHandler(ReasoningStep reasoningStep, String string, String string2, Hashtable hashtable) {
        this.rsi = new ArrayReasoningStepIterator(reasoningStep);
        this._queryName = string;
        this._baseNodeSetURI = string2;
        this._baseNodeSetPath = null;
        this._baseNodeSetHash = hashtable;
    }

    public IWHandler(ReasoningStepIterator reasoningStepIterator, String string, String string2, Hashtable hashtable) {
        this.rsi = reasoningStepIterator;
        this._queryName = string;
        this._baseNodeSetURI = string2;
        this._baseNodeSetPath = null;
        this._baseNodeSetHash = hashtable;
    }

    public void traverseFirst(Proof proof) {
        this._steps.add(proof);
        Iterator iterator = proof.getSubProofs().iterator();
        while (iterator.hasNext()) {
            Proof proof2 = (Proof)iterator.next();
            this.traverseFirst(proof2);
        }
    }

    public void traverseSecond(Proof proof, int n) {
        IWUtils.generateNodeSet(proof, this._steps, n, this._baseNodeSetURI, this._baseNodeSetPath, this._baseNodeSetHash, this._queryName);
        Iterator iterator = proof.getSubProofs().iterator();
        while (iterator.hasNext()) {
            Proof proof2 = (Proof)iterator.next();
            this.traverseSecond(proof2, n);
        }
    }

    public String publish() throws Exception {
        ReasoningStep reasoningStep;
        String string = null;
        System.out.println("\nPublishing query over Inference Web.");
        int n = 1;
        String string2 = "";
        HashSet hashSet = new HashSet();
        ReasoningStep reasoningStep2 = null;
        while ((reasoningStep = this.rsi.next()) != null) {
            if (IWHandler.duplicateAnswer(reasoningStep, hashSet)) continue;
            if (n == 1) {
                reasoningStep2 = reasoningStep;
            }
            try {
                System.out.println("Generating node set files for binding " + n);
                this._steps.clear();
                this.traverseFirst(reasoningStep);
                this.traverseSecond(reasoningStep, n);
            }
            catch (Exception exception) {
                System.out.println("\nInference Web problem for answer " + n + ".");
            }
            ++n;
        }
        System.out.println("Generating query file");
        string = IWUtils.generateQuery(reasoningStep2, this._baseNodeSetURI, this._baseNodeSetPath, this._baseNodeSetHash, this._queryName, n - 1);
        return string;
    }

    protected static boolean duplicateAnswer(ReasoningStep reasoningStep, Set set) {
        Map map = IWHandler.getTopLevelBindings(reasoningStep);
        if (set.contains(map)) {
            return true;
        }
        set.add(map);
        return false;
    }

    protected static Map getTopLevelBindings(ReasoningStep reasoningStep) {
        Map map = IWHandler.getBindings(reasoningStep);
        HashMap hashMap = new HashMap(map.size());
        Set set = IWHandler.getQueryVariables(reasoningStep);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            hashMap.put(e, map.get(e));
        }
        return hashMap;
    }

    protected static Map getBindings(ReasoningStep reasoningStep) {
        if (reasoningStep.getGoal() instanceof String) {
            reasoningStep = (ReasoningStep)reasoningStep.getSubProofs().get(0);
        }
        return RSUtils.getRecursiveBindings(reasoningStep, null);
    }

    protected static Set getQueryVariables(ReasoningStep reasoningStep) {
        Object object = reasoningStep.getGoal();
        if (object instanceof CNFSentence) {
            return IWHandler.getQueryVariables((CNFSentence)object);
        }
        ReasoningStep reasoningStep2 = (ReasoningStep)reasoningStep.getSubProofs().get(0);
        return IWHandler.getQueryVariables((CNFSentence)reasoningStep2.getGoal());
    }

    static Set getQueryVariables(CNFSentence cNFSentence) {
        HashSet hashSet = new HashSet(10);
        Iterator iterator = cNFSentence.clauses().iterator();
        while (iterator.hasNext()) {
            Clause clause = (Clause)iterator.next();
            Iterator iterator2 = clause.literals().iterator();
            while (iterator2.hasNext()) {
                Literal literal = (Literal)iterator2.next();
                if (!(literal.getArgs() instanceof Unifyable)) continue;
                hashSet.addAll(((Unifyable)((Object)literal.getArgs())).getVariables(null));
            }
        }
        return hashSet;
    }
}

