/*
 * Decompiled with CFR 0.152.
 */
package jtp.gmp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jtp.DirectAssertion;
import jtp.ReasoningException;
import jtp.ReasoningStep;
import jtp.ReasoningStepIterator;
import jtp.fol.Literal;
import jtp.fol.SubstUtils;
import jtp.gmp.ClauseOrientation;
import jtp.gmp.ModusPonensProofStep;
import jtp.gmp.Utils;

public class ModusPonensRecycler
implements ReasoningStepIterator {
    protected Iterator clauseIter;
    private transient List varStack;
    private transient Set canonVarSet;
    protected ModusPonensProofStep ps;
    protected Literal goal;
    protected Map bindings = null;

    ModusPonensRecycler(Literal literal, Iterator iterator, List list, Set set) {
        this.goal = literal;
        this.clauseIter = iterator;
        this.varStack = list;
        this.canonVarSet = set;
    }

    public ReasoningStep next() throws ReasoningException {
        while (this.clauseIter.hasNext()) {
            ClauseOrientation clauseOrientation = (ClauseOrientation)this.clauseIter.next();
            if (this.ps == null) {
                this.ps = new ModusPonensProofStep(this.goal);
            }
            if (!this.tryClause(clauseOrientation)) continue;
            this.varStack.clear();
            return this.ps;
        }
        this.ps = null;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean tryClause(ClauseOrientation clauseOrientation) {
        try {
            if (!Utils.unify(this.goal, clauseOrientation, this.canonVarSet, this.varStack)) {
                boolean bl = false;
                return bl;
            }
            this.ps.hc = clauseOrientation;
            if (this.bindings != null) {
                this.bindings.clear();
            }
            this.ps.setBindings(SubstUtils.variableStackToMap(this.varStack, this.bindings));
            int n = clauseOrientation.literals().size() - 1;
            if (this.ps.getSubGoals() == Collections.EMPTY_LIST) {
                this.ps.setSubGoals(new ArrayList(n));
            } else {
                this.ps.getSubGoals().clear();
            }
            clauseOrientation.createSubGoals(this.ps.getSubGoals());
            if (!this.ps.getSubProofs().isEmpty()) {
                this.ps.getSubProofs().clear();
            }
            if (!this.ps.getSubGoals().isEmpty()) {
                this.ps.getSubProofs().add(new DirectAssertion(clauseOrientation.getClause()));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (!this.canonVarSet.isEmpty()) {
                Utils.restoreVariableSet(this.canonVarSet);
            }
            this.varStack.clear();
        }
    }
}

