/*
 * Decompiled with CFR 0.152.
 */
package jtp.gmp;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import jtp.DirectAssertion;
import jtp.KnowledgeStore;
import jtp.Reasoner;
import jtp.ReasoningException;
import jtp.ReasoningStepIterator;
import jtp.fol.Clause;
import jtp.fol.Literal;
import jtp.fol.Symbol;
import jtp.gmp.ClauseOrientation;
import jtp.gmp.ModusPonensReasoner;
import jtp.rs.ArrayReasoningStepIterator;
import jtp.util.PropertyImporter;

public class ClauseOrientationKB
extends PropertyImporter
implements Reasoner,
KnowledgeStore,
Serializable {
    Map pos = new HashMap(100);
    Map neg = new HashMap(100);
    Reasoner askingReasoner = new ModusPonensReasoner(this);
    transient UndoManager undoManager;

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public void setUndoManager(UndoManager undoManager) {
        this.undoManager = undoManager;
    }

    public ClauseOrientationKB() {
        this.setImportedProperties(new String[]{"undoManager"});
    }

    public boolean acceptable(Object object) {
        if (!(object instanceof DirectAssertion)) {
            return false;
        }
        DirectAssertion directAssertion = (DirectAssertion)object;
        return !directAssertion.isAsserted() && directAssertion.getGoal() instanceof Clause;
    }

    public ReasoningStepIterator process(Object object) throws ReasoningException {
        DirectAssertion directAssertion = (DirectAssertion)object;
        Clause clause = (Clause)directAssertion.getGoal();
        Iterator iterator = clause.literals().iterator();
        while (iterator.hasNext()) {
            this.addClauseOrientation(new ClauseOrientation(clause, (Literal)iterator.next()));
        }
        directAssertion.setAsserted(true);
        return ArrayReasoningStepIterator.empty;
    }

    boolean addClauseOrientation(ClauseOrientation clauseOrientation) {
        Map map = clauseOrientation.head.isPositive() ? this.pos : this.neg;
        ArrayList<ClauseOrientation> arrayList = (ArrayList<ClauseOrientation>)map.get(clauseOrientation.head.getRelation());
        if (arrayList == null) {
            arrayList = new ArrayList<ClauseOrientation>();
            map.put(clauseOrientation.head.getRelation(), arrayList);
        }
        if (arrayList.add(clauseOrientation) && this.undoManager != null) {
            this.undoManager.addEdit(new Undo(clauseOrientation, arrayList));
        }
        return true;
    }

    Collection getBucket(boolean bl, Symbol symbol) {
        Map map = bl ? this.pos : this.neg;
        return (Collection)map.get(symbol);
    }

    Collection getBucket(Literal literal) {
        return this.getBucket(literal.isPositive(), literal.getRelation());
    }

    public String toString() {
        return "ClauseOrientationKB{pos: " + this.pos.toString() + ", neg: " + this.neg.toString() + '}';
    }

    public Reasoner getAskingReasoner() {
        return this.askingReasoner;
    }

    public Reasoner getTellingReasoner() {
        return this;
    }

    static class Undo
    extends AbstractUndoableEdit {
        Collection bucket;
        ClauseOrientation co;

        public Undo(ClauseOrientation clauseOrientation, Collection collection) {
            this.co = clauseOrientation;
            this.bucket = collection;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.bucket.remove(this.co);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.bucket.add(this.co);
        }
    }
}

