/*
 * Decompiled with CFR 0.152.
 */
package jtp.gmp;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jtp.fol.Clause;
import jtp.fol.DefaultLiteral;
import jtp.fol.Literal;
import jtp.fol.SubstUtils;
import jtp.fol.Unifyable;

public class ClauseOrientation
implements Serializable {
    Clause cl;
    Literal head;

    public ClauseOrientation(Clause clause, Literal literal) {
        this.cl = clause;
        this.head = literal;
    }

    public static ClauseOrientation[] produceOrientations(Clause clause) {
        int n = clause.literals().size();
        ClauseOrientation[] clauseOrientationArray = new ClauseOrientation[n];
        Iterator iterator = clause.literals().iterator();
        int n2 = 0;
        while (n2 < n) {
            ClauseOrientation clauseOrientation;
            Literal literal = (Literal)iterator.next();
            clauseOrientationArray[n2] = clauseOrientation = new ClauseOrientation(clause, literal);
            ++n2;
        }
        return clauseOrientationArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(<= ").append(this.head);
        Iterator iterator = this.cl.literals().iterator();
        while (iterator.hasNext()) {
            Literal literal = (Literal)iterator.next();
            if (literal == this.head) continue;
            DefaultLiteral defaultLiteral = new DefaultLiteral(literal.getRelation(), literal.getArgs(), !literal.isPositive());
            stringBuffer.append(SubstUtils.printLiteral(defaultLiteral));
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public Collection literals() {
        return this.cl.literals();
    }

    public Collection clauses() {
        return this.cl.clauses();
    }

    public Literal getHead() {
        return this.head;
    }

    public Clause getClause() {
        return this.cl;
    }

    public List createSubGoals(List arrayList) {
        Collection collection = this.cl.literals();
        if (arrayList == null) {
            arrayList = new ArrayList<Clause>(collection.size());
        }
        if (collection.size() == 1) {
            return arrayList;
        }
        arrayList.add(this.cl);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Literal literal = (Literal)iterator.next();
            if (literal == this.getHead()) continue;
            List list = literal.getArgs();
            List list2 = list instanceof Unifyable ? (List)((Unifyable)((Object)list)).deReferenceVariables() : list;
            DefaultLiteral defaultLiteral = new DefaultLiteral(literal.getRelation(), list2, !literal.isPositive());
            arrayList.add(defaultLiteral);
        }
        return arrayList;
    }
}

