/*
 * Decompiled with CFR 0.152.
 */
package jtp.frame.vc;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jtp.ReasoningStep;
import jtp.fol.Unifyable;
import jtp.frame.vc.BackwardChainingWalker;
import jtp.frame.vc.Goal;
import jtp.frame.vc.MembershipProofStep;
import jtp.frame.vc.Multiplexor;
import jtp.frame.vc.ValueCollectionListener;
import jtp.util.CascadeIterator;

public abstract class ValueCollection
extends AbstractCollection
implements Serializable {
    protected Map valueMap = new HashMap(10);
    ValueCollectionListener vcListener;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ValueCollection");
        Iterator iterator = this.iterator();
        if (iterator.hasNext()) {
            stringBuffer.append(": { " + iterator.next());
            while (iterator.hasNext()) {
                stringBuffer.append(", " + iterator.next());
            }
            stringBuffer.append("}");
        } else {
            stringBuffer.append(" (empty)");
        }
        return stringBuffer.toString();
    }

    public boolean add(Object object) {
        return this.add(object, null);
    }

    public boolean add(Object object, ReasoningStep reasoningStep) {
        if (this.valueMap.containsKey(object)) {
            return false;
        }
        this.valueMap.put(object, reasoningStep);
        return true;
    }

    public void setProof(Object object, ReasoningStep reasoningStep) {
        this.valueMap.put(object, reasoningStep);
    }

    public boolean remove(Object object) {
        if (!this.valueMap.containsKey(object)) {
            return false;
        }
        this.valueMap.remove(object);
        return true;
    }

    public int size() {
        int n = 0;
        BackwardChainingWalker backwardChainingWalker = new BackwardChainingWalker(this);
        while (backwardChainingWalker.hasNext()) {
            ValueCollection valueCollection = (ValueCollection)backwardChainingWalker.next();
            n += valueCollection.directValues().size();
        }
        return n;
    }

    public Iterator iterator() {
        return new CascadeIterator(new BackwardChainingWalker(this)){

            protected Iterator nextIter() {
                return ((ValueCollection)this.si.next()).directValues().iterator();
            }
        };
    }

    public boolean isEmpty() {
        BackwardChainingWalker backwardChainingWalker = new BackwardChainingWalker(this);
        while (backwardChainingWalker.hasNext()) {
            if (((ValueCollection)backwardChainingWalker.next()).directValues().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Object object) {
        if (this.directValues().contains(object)) {
            return true;
        }
        BackwardChainingWalker backwardChainingWalker = new BackwardChainingWalker(this);
        backwardChainingWalker.next();
        while (backwardChainingWalker.hasNext()) {
            if (!((ValueCollection)backwardChainingWalker.next()).directValues().contains(object)) continue;
            return true;
        }
        return false;
    }

    public Set directValues() {
        return this.valueMap.keySet();
    }

    public Collection getInputLinks() {
        return Collections.EMPTY_SET;
    }

    public void setInputLinks(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public abstract Collection getOutputLinks();

    public abstract void setOutputLinks(Collection var1);

    public ReasoningStep getProof(Object object) {
        ReasoningStep reasoningStep = (ReasoningStep)this.valueMap.get(object);
        return reasoningStep != null ? reasoningStep : new MembershipProofStep(this, object);
    }

    public boolean valueIsInferred(Object object) {
        return this.valueMap.get(object) != null;
    }

    public String getMembershipString(Object object) {
        if (object instanceof Unifyable) {
            object = ((Unifyable)object).deReferenceVariables();
        }
        return object + " is in " + this;
    }

    public Object getMembershipGoal(Object object) {
        return new Goal(this, object);
    }

    public ValueCollectionListener getVCListener() {
        return this.vcListener;
    }

    public void addValueCollectionListener(ValueCollectionListener valueCollectionListener) {
        if (this.vcListener == null) {
            this.vcListener = valueCollectionListener;
        } else if (this.vcListener instanceof Multiplexor) {
            ((Multiplexor)this.vcListener).addValueCollectionListener(valueCollectionListener);
        } else {
            Multiplexor multiplexor = new Multiplexor();
            multiplexor.addValueCollectionListener(this.vcListener);
            multiplexor.addValueCollectionListener(valueCollectionListener);
            this.vcListener = multiplexor;
        }
    }

    public void removeValueCollectionListener(ValueCollectionListener valueCollectionListener) {
        if (this.vcListener == valueCollectionListener) {
            this.vcListener = null;
        } else if (this.vcListener instanceof Multiplexor) {
            ((Multiplexor)this.vcListener).removeValueCollectionListener(valueCollectionListener);
        }
    }
}

