/*
 * Decompiled with CFR 0.152.
 */
package jtp.frame.listen;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import jtp.ReasoningException;
import jtp.ReasoningStepIterator;
import jtp.context.BasicReasoningContext;
import jtp.disp.DispatcherUtils;
import jtp.fol.Clause;
import jtp.fol.DefaultLiteral;
import jtp.fol.Literal;
import jtp.fol.Symbol;
import jtp.fol.Unifyable;
import jtp.fol.Variable;
import jtp.fol.daml.DAMLParser;
import jtp.fol.kif.KIF2CNF;
import jtp.frame.FrameKB;
import jtp.frame.LinkAsserter;
import jtp.frame.SlotValueAskingReasoner;
import jtp.frame.SlotValueTellingReasoner;
import jtp.frame.ValueLinkCreationReasoningStep;
import jtp.frame.listen.ListenerTemplate;
import jtp.frame.listen.OneWayTripleTemplate;
import jtp.frame.listen.TripleTemplate;
import jtp.frame.listen.VCListenerCreationReasoningStep;
import jtp.frame.listen.VCListenerCreator;
import jtp.frame.listen.VCTemplate;
import jtp.frame.listen.VLTemplate;
import jtp.frame.vocab.StandardFrames;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class Context
extends BasicReasoningContext {
    private FrameKB fkb;
    DAMLParser damlParser = new DAMLParser();
    KIF2CNF kifParser = new KIF2CNF();
    protected static final Symbol VC = Symbol.newSymbol("vc");
    protected static final Symbol VALUE_LINK = Symbol.newSymbol("value-link");
    protected static final Symbol ONE_VALUE = Symbol.newSymbol("one-value");
    protected static final Symbol TRIPLE = Symbol.newSymbol("triple");
    Set boundObjects = new HashSet(20);
    final Symbol INEQUAL = Symbol.newSymbol("/=");

    public FrameKB getFrameKB() {
        return this.fkb;
    }

    public void setFrameKB(FrameKB frameKB) {
        this.fkb = frameKB;
        this.pcSupport.firePropertyChange("frameKB", this.fkb, this.fkb);
    }

    public DAMLParser getDamlParser() {
        return this.damlParser;
    }

    public KIF2CNF getKifParser() {
        return this.kifParser;
    }

    public void setUp() {
        try {
            this.defaultSetup();
            this.setMaxDepth(20);
            this.createContentHolders();
            this.add(this.getFrameKB());
            LinkAsserter linkAsserter = new LinkAsserter();
            this.add(linkAsserter);
            VCListenerCreator vCListenerCreator = new VCListenerCreator();
            this.add(vCListenerCreator);
            DispatcherUtils.addToDispatcher(new SlotValueAskingReasoner(this.getFrameKB()), this.getAskingDispatcher());
            DispatcherUtils.addToDispatcher(new SlotValueTellingReasoner(this.getFrameKB()), this.getTellingDispatcher());
            DispatcherUtils.addToDispatcher(linkAsserter, this.getTellingDispatcher());
            DispatcherUtils.addToDispatcher(vCListenerCreator, this.getTellingDispatcher());
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    protected void createContentHolders() throws IOException {
        this.createEmptyContentHolders();
    }

    protected void createEmptyContentHolders() {
        this.setFrameKB(new FrameKB());
    }

    public void loadSpecs(URL uRL) throws IOException, ReasoningException {
        this.loadSpecs(uRL, uRL);
    }

    public void loadSpecs(URL uRL, URL uRL2) throws IOException, ReasoningException {
        this.setParser(this.kifParser);
        try {
            Object object;
            Object object2;
            String string;
            Object object3;
            Element element = new SAXBuilder().build(uRL).getRootElement();
            Iterator iterator = element.getChildren("ListenerSpec").iterator();
            while (iterator.hasNext()) {
                Object object4;
                object3 = (Element)iterator.next();
                string = object3.getChild("rule").getTextTrim();
                object2 = object3.getAttributeValue("name");
                object = object3.getChildren("ignore");
                ArrayList<Object> arrayList = null;
                if (!object.isEmpty()) {
                    arrayList = new ArrayList<Object>(object.size() + 1);
                    object4 = object.iterator();
                    while (object4.hasNext()) {
                        arrayList.add(((Element)object4.next()).getTextTrim());
                    }
                    arrayList.add(object2);
                }
                object4 = (Clause)this.getTranslator().translate(string);
                this.addListener((String)object2, (Clause)object4, arrayList, uRL2);
            }
            object3 = element.getChildren("ValueLink").iterator();
            while (object3.hasNext()) {
                string = (Element)object3.next();
                object2 = (Literal)this.getTranslator().translate(string.getChild("target").getTextTrim());
                object = (Literal)this.getTranslator().translate(string.getChild("source").getTextTrim());
                this.addLink((Literal)object2, (Literal)object);
            }
        }
        catch (JDOMException jDOMException) {
            throw new IOException("Error loading rules file: " + jDOMException.getMessage());
        }
    }

    protected void addListener(String string, Clause clause, Collection collection, URL uRL) throws ReasoningException {
        ListenerTemplate listenerTemplate;
        List list;
        VCTemplate[] vCTemplateArray = new VCTemplate[clause.literals().size() - 1];
        Iterator iterator = clause.literals().iterator();
        Literal literal = null;
        int n = 0;
        while (iterator.hasNext()) {
            literal = (Literal)iterator.next();
            if (!literal.getRelation().equals(VC)) break;
            list = literal.getArgs();
            if (list.size() == 4) {
                vCTemplateArray[n] = new VCTemplate(list.get(0), list.get(1), list.get(2), this.getBooleanVal((String)list.get(3)));
            } else if (list.size() == 6) {
                vCTemplateArray[n] = new VCTemplate(list.get(0), list.get(1), list.get(2), this.getBooleanVal((String)list.get(3)), list.get(4), (Symbol)list.get(5));
            } else {
                throw new RuntimeException("Invalid argument list in VC specification: " + list);
            }
            ++n;
        }
        list = literal.getArgs();
        if (literal.getRelation().equals(VALUE_LINK)) {
            listenerTemplate = new VLTemplate(list.get(0), list.get(1), this.getBooleanVal((String)list.get(2)), list.get(3), list.get(4), this.getBooleanVal((String)list.get(5)));
        } else if (literal.getRelation().equals(ONE_VALUE)) {
            listenerTemplate = new OneWayTripleTemplate(list.get(0), list.get(1), this.getBooleanVal((String)list.get(2)), list.get(3));
        } else if (literal.getRelation().equals(TRIPLE)) {
            listenerTemplate = new TripleTemplate(list.get(0), list.get(1), list.get(2));
        } else {
            throw new RuntimeException("Consequent's relation is not recognized: " + literal.getRelation());
        }
        ReasoningStepIterator reasoningStepIterator = this.getTellingReasoner().process(new VCListenerCreationReasoningStep(string, vCTemplateArray, listenerTemplate, collection, uRL));
        while (reasoningStepIterator.next() != null) {
        }
    }

    protected void addLink(Literal literal, Literal literal2) throws ReasoningException {
        List list = literal2.getArgs();
        List list2 = literal.getArgs();
        ValueLinkCreationReasoningStep valueLinkCreationReasoningStep = new ValueLinkCreationReasoningStep(null, (Symbol)list.get(0), list.get(1), this.getBooleanVal((String)list.get(2)), null, (Symbol)list2.get(0), list2.get(1), this.getBooleanVal((String)list2.get(2)), new Variable("x"), Collections.EMPTY_LIST);
        ReasoningStepIterator reasoningStepIterator = this.getTellingReasoner().process(valueLinkCreationReasoningStep);
        while (reasoningStepIterator.next() != null) {
        }
    }

    private boolean getBooleanVal(String string) {
        Boolean bl = new Boolean(string);
        return bl;
    }

    public void addRule(Clause clause, String string) throws ReasoningException {
        Literal literal = null;
        Literal[] literalArray = new Literal[clause.literals().size() - 1];
        int n = 0;
        Iterator iterator = clause.literals().iterator();
        while (iterator.hasNext()) {
            Literal literal2 = (Literal)iterator.next();
            if (literal2.isPositive()) {
                if (literal != null) {
                    throw new IllegalArgumentException("Rule must be a Horn clause with exactly one positive literal. Rule named '" + string + "' is invalid: " + clause);
                }
                literal = literal2;
                continue;
            }
            literalArray[n++] = literal2;
        }
        this.addRule(this.orderLiterals(literalArray), literal, string);
    }

    protected Literal[] orderLiterals(Literal[] literalArray) {
        LinkedList<Literal> linkedList = new LinkedList<Literal>();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < literalArray.length) {
            int n4;
            Literal literal = literalArray[n3];
            if (literal.getRelation().equals(StandardFrames.HOLDS) && !(literal.getArgs().get(0) instanceof Unifyable)) {
                literal = new DefaultLiteral((Symbol)literal.getArgs().get(0), literal.getArgs().subList(0, literal.getArgs().size()), literal.isPositive());
            }
            int n5 = n4 = literal.getRelation().equals(StandardFrames.HOLDS) ? 1 : 0;
            if (literal.getArgs().size() - n4 != 2) {
                throw new IllegalArgumentException("Invalid rule literal: " + literal);
            }
            if (literal.getRelation().equals(StandardFrames.HOLDS)) {
                linkedList.add(literal);
            } else if (!(literal.getArgs().get(0) instanceof Unifyable) || !(literal.getArgs().get(1) instanceof Unifyable)) {
                linkedList.add(n++, literal);
                ++n2;
            } else {
                linkedList.add(n2++, literal);
            }
            ++n3;
        }
        return linkedList.toArray(literalArray);
    }

    protected void addRule(Literal[] literalArray, Literal literal, String string) throws ReasoningException {
        this.boundObjects.clear();
        VCTemplate[] vCTemplateArray = this.createVCTemplates(literalArray, this.boundObjects);
        int n = literal.getArgs().size() == 2 ? 0 : 1;
        Symbol symbol = n == 0 ? literal.getRelation() : literal.getArgs().get(0);
        Object e = literal.getArgs().get(0 + n);
        Object e2 = literal.getArgs().get(1 + n);
        if (!(this.isBound(symbol, this.boundObjects) && this.isBound(e, this.boundObjects) && this.isBound(e2, this.boundObjects))) {
            throw new IllegalArgumentException("Consequent should have no variables that are not bound in antecedents: " + literal);
        }
        ReasoningStepIterator reasoningStepIterator = this.getTellingReasoner().process(new VCListenerCreationReasoningStep(string, vCTemplateArray, new TripleTemplate(symbol, e, e2)));
        while (reasoningStepIterator.next() != null) {
        }
    }

    VCTemplate[] createVCTemplates(Literal[] literalArray, Set set) {
        Literal literal;
        VCTemplate[] vCTemplateArray;
        LinkedList<VCTemplate[]> linkedList = new LinkedList<VCTemplate[]>();
        LinkedList<VCTemplate> linkedList2 = new LinkedList<VCTemplate>();
        int n = 0;
        while (n < literalArray.length) {
            vCTemplateArray = literalArray[n];
            int n2 = vCTemplateArray.getArgs().size() == 2 ? 0 : 1;
            Symbol symbol = n2 == 0 ? vCTemplateArray.getRelation() : vCTemplateArray.getArgs().get(0);
            Object e = vCTemplateArray.getArgs().get(0 + n2);
            literal = vCTemplateArray.getArgs().get(1 + n2);
            if (((Object)symbol).equals(this.INEQUAL)) {
                linkedList.add(vCTemplateArray);
            } else {
                if (!(this.isBound(symbol, set) || this.isBound(e, set) || this.isBound(literal, set))) {
                    throw new IllegalArgumentException("Need to bind at least one of property, subject, or object in each rule literal: " + vCTemplateArray);
                }
                if (!this.isBound(e, set) && !this.isBound(literal, set)) {
                    linkedList2.add(new VCTemplate(StandardFrames.HAS_SLOT, symbol, e, true));
                    linkedList2.add(new VCTemplate(symbol, e, literal, false));
                    this.addBoundVariable(e, set);
                    this.addBoundVariable(literal, set);
                } else if (!this.isBound(symbol, set)) {
                    if (this.isBound(e, set)) {
                        linkedList2.add(new VCTemplate(StandardFrames.HAS_SLOT, e, symbol, false));
                        linkedList2.add(new VCTemplate(symbol, e, literal, false));
                        this.addBoundVariable(literal, set);
                    } else if (this.isBound(literal, set)) {
                        linkedList2.add(new VCTemplate(StandardFrames.HAS_INVERSE_SLOT, literal, symbol, false));
                        linkedList2.add(new VCTemplate(symbol, literal, e, true));
                        this.addBoundVariable(e, set);
                    }
                    this.addBoundVariable(symbol, set);
                } else if (this.isBound(e, set)) {
                    linkedList2.add(new VCTemplate(symbol, e, literal, false));
                    this.addBoundVariable(literal, set);
                } else if (this.isBound(literal, set)) {
                    linkedList2.add(new VCTemplate(symbol, literal, e, true));
                    this.addBoundVariable(e, set);
                } else {
                    throw new IllegalArgumentException("Can't figure out what to do with this rule literal: " + vCTemplateArray);
                }
            }
            ++n;
        }
        vCTemplateArray = linkedList2.toArray(new VCTemplate[0]);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            boolean bl = false;
            boolean bl2 = false;
            literal = (Literal)iterator.next();
            Object e = literal.getArgs().get(0);
            Object e2 = literal.getArgs().get(1);
            if (!(e instanceof Unifyable)) {
                bl = true;
            }
            if (!(e2 instanceof Unifyable)) {
                bl2 = true;
            }
            int n3 = 0;
            while (!(n3 >= vCTemplateArray.length || bl && bl2)) {
                VCTemplate vCTemplate = vCTemplateArray[n3];
                if (!bl && vCTemplate.val.equals(e)) {
                    bl = true;
                    if (bl2) {
                        vCTemplate.comparisonSign = Symbol.newSymbol("/=");
                        vCTemplate.comparisonVal = e2;
                    }
                }
                if (!bl2 && vCTemplate.val.equals(e2)) {
                    bl2 = true;
                    if (bl) {
                        vCTemplate.comparisonSign = Symbol.newSymbol("/=");
                        vCTemplate.comparisonVal = e;
                    }
                }
                ++n3;
            }
        }
        return vCTemplateArray;
    }

    boolean isBound(Object object, Set set) {
        return !(object instanceof Unifyable) || set.contains(object);
    }

    void addBoundVariable(Object object, Set set) {
        if (object instanceof Unifyable) {
            set.add(object);
        }
    }
}

