/*
 * Decompiled with CFR 0.152.
 */
package jtp.frame.fc;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import jtp.Dispatcher;
import jtp.Reasoner;
import jtp.ReasoningException;
import jtp.ReasoningStepIterator;
import jtp.disp.DispatcherUtils;
import jtp.fol.Clause;
import jtp.fol.DefaultLiteral;
import jtp.fol.Literal;
import jtp.fol.SubstUtils;
import jtp.fol.Symbol;
import jtp.frame.fc.BackwardChainingStorage;
import jtp.frame.fc.BlendingRuleAction;
import jtp.frame.fc.RuleInstallationProofStep;
import jtp.frame.fc.RuleInstantiator;
import jtp.frame.fc.RuleTriggeringProofStep;
import jtp.frame.fc.TriggerValidator;
import jtp.gmp.ClauseOrientation;
import jtp.rs.ArrayReasoningStepIterator;
import jtp.rs.SecondaryProofStorageWriter;
import jtp.util.PropertyImporter;

public class RuleClauseAndTriggerInstaller
extends PropertyImporter
implements Reasoner {
    HashSet actions = new HashSet();
    transient BackwardChainingStorage backwardStorage;
    transient RuleInstantiator ruleInstantiator;
    transient Dispatcher tellingDispatcher;
    transient UndoManager undoManager;

    protected void initializeBeanContextResources() {
        super.initializeBeanContextResources();
    }

    public BackwardChainingStorage getBackwardStorage() {
        return this.backwardStorage;
    }

    public void setBackwardStorage(BackwardChainingStorage backwardChainingStorage) {
        this.backwardStorage = backwardChainingStorage;
    }

    public RuleInstantiator getRuleInstantiator() {
        return this.ruleInstantiator;
    }

    public void setRuleInstantiator(RuleInstantiator ruleInstantiator) {
        this.ruleInstantiator = ruleInstantiator;
    }

    public Dispatcher getTellingDispatcher() {
        return this.tellingDispatcher;
    }

    public void setTellingDispatcher(Dispatcher dispatcher) {
        this.tellingDispatcher = dispatcher;
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public void setUndoManager(UndoManager undoManager) {
        this.undoManager = undoManager;
    }

    public Collection getActions() {
        return this.actions;
    }

    public RuleClauseAndTriggerInstaller() {
        this.setImportedProperties(new String[]{"ruleInstantiator", "backwardStorage", "tellingDispatcher", "undoManager"});
    }

    public boolean acceptable(Object object) {
        return object instanceof RuleTriggeringProofStep;
    }

    public ReasoningStepIterator process(Object object) throws ReasoningException {
        RuleTriggeringProofStep ruleTriggeringProofStep = (RuleTriggeringProofStep)object;
        return this.addRule(ruleTriggeringProofStep.getAction()) ? new ArrayReasoningStepIterator(new RuleInstallationProofStep(ruleTriggeringProofStep.getTargetLiteral(), ruleTriggeringProofStep.getAction(), Arrays.asList(ruleTriggeringProofStep))) : ArrayReasoningStepIterator.empty;
    }

    public boolean addRule(BlendingRuleAction blendingRuleAction) {
        this.installTriggers(blendingRuleAction.getTriggerLiterals(), blendingRuleAction.getRuleLiteral(), blendingRuleAction);
        this.installClause(blendingRuleAction);
        return this.installAction(blendingRuleAction);
    }

    public boolean removeRule(BlendingRuleAction blendingRuleAction) {
        boolean bl = this.uninstallTriggers(blendingRuleAction.getTriggerLiterals(), blendingRuleAction.getRelation());
        bl = this.uninstallClause(blendingRuleAction.getRelation()) || bl;
        return this.uninstallAction(blendingRuleAction) || bl;
    }

    private void installTriggers(List list, Literal literal, TriggerValidator triggerValidator) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Literal literal2 = (Literal)iterator.next();
            this.ruleInstantiator.addTrigger(new DefaultLiteral(literal2.getRelation(), literal2.getArgs(), true), literal, triggerValidator);
        }
    }

    private void installClause(BlendingRuleAction blendingRuleAction) {
        Clause clause = (Clause)SubstUtils.replaceVariables(blendingRuleAction.getRuleClause());
        this.backwardStorage.addRule(new ClauseOrientation(clause, (Literal)clause.literals().iterator().next()));
    }

    protected boolean installAction(Reasoner reasoner) {
        if (reasoner == null) {
            throw new NullPointerException();
        }
        if (!this.actions.add(reasoner)) {
            return false;
        }
        DispatcherUtils.addToDispatcher(reasoner, this.getTellingDispatcher());
        if (this.getUndoManager() != null) {
            this.getUndoManager().addEdit(new Undo(reasoner, true));
        }
        return true;
    }

    private boolean uninstallTriggers(List list, Symbol symbol) {
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            boolean bl2 = bl = this.ruleInstantiator.removeTrigger((Literal)iterator.next(), symbol) || bl;
        }
        return bl;
    }

    private boolean uninstallClause(Symbol symbol) {
        return this.backwardStorage.removeRule(symbol);
    }

    private boolean uninstallAction(Reasoner reasoner) {
        if (!this.actions.remove(reasoner)) {
            return false;
        }
        boolean bl = DispatcherUtils.removeFromDispatcher(reasoner, this.getTellingDispatcher());
        if (bl && this.getUndoManager() != null) {
            this.getUndoManager().addEdit(new Undo(reasoner, false));
        }
        return bl;
    }

    public void stripProofs(SecondaryProofStorageWriter secondaryProofStorageWriter) throws IOException {
        Iterator iterator = this.getActions().iterator();
        while (iterator.hasNext()) {
            ((BlendingRuleAction)iterator.next()).stripProofs(secondaryProofStorageWriter);
        }
    }

    class Undo
    extends AbstractUndoableEdit {
        Reasoner r;
        boolean added;

        public Undo(Reasoner reasoner, boolean bl) {
            this.r = reasoner;
            this.added = bl;
        }

        private void addOrRemove(boolean bl) {
            if (bl) {
                DispatcherUtils.addToDispatcher(this.r, RuleClauseAndTriggerInstaller.this.getTellingDispatcher());
                RuleClauseAndTriggerInstaller.this.actions.add(this.r);
            } else {
                DispatcherUtils.removeFromDispatcher(this.r, RuleClauseAndTriggerInstaller.this.getTellingDispatcher());
                RuleClauseAndTriggerInstaller.this.actions.remove(this.r);
            }
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.addOrRemove(!this.added);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.addOrRemove(this.added);
        }
    }
}

