/*
 * Decompiled with CFR 0.152.
 */
package jtp.frame.fc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import jtp.DirectAssertion;
import jtp.Reasoner;
import jtp.ReasoningStep;
import jtp.ReasoningStepIterator;
import jtp.demod.DemodUtils;
import jtp.fol.DefaultLiteral;
import jtp.fol.Literal;
import jtp.fol.SubstUtils;
import jtp.fol.Symbol;
import jtp.fol.Unifyable;
import jtp.frame.vocab.StandardFrames;
import jtp.gmp.ClauseOrientation;
import jtp.gmp.Utils;
import jtp.rs.ArrayReasoningStepIterator;
import jtp.util.DevNullCollection;
import jtp.util.PropertyImporter;

public class BackwardChainingStorage
extends PropertyImporter
implements Reasoner {
    Map ruleBase = new HashMap();
    List stack = new ArrayList();
    Collection vars = new HashSet(20);
    transient UndoManager undoManager;
    private static HashSet functionSyms = new HashSet<Object>(Arrays.asList(Symbol.newSymbol("/="), Symbol.newSymbol("="), Symbol.newSymbol("<"), Symbol.newSymbol(">")));

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public void setUndoManager(UndoManager undoManager) {
        this.undoManager = undoManager;
    }

    public BackwardChainingStorage() {
        this.setImportedProperties(new String[]{"undoManager"});
    }

    public void addRule(ClauseOrientation clauseOrientation) {
        Symbol symbol = clauseOrientation.getHead().getRelation();
        if (this.ruleBase.containsKey(symbol)) {
            throw new IllegalStateException("Trying to redefine rule " + symbol);
        }
        this.ruleBase.put(symbol, clauseOrientation);
        if (this.undoManager != null) {
            this.undoManager.addEdit(new Undo(clauseOrientation, true));
        }
    }

    public boolean removeRule(Symbol symbol) {
        ClauseOrientation clauseOrientation = (ClauseOrientation)this.ruleBase.remove(symbol);
        if (clauseOrientation == null) {
            return false;
        }
        if (this.undoManager != null) {
            this.undoManager.addEdit(new Undo(clauseOrientation, false));
        }
        return true;
    }

    public boolean acceptable(Object object) {
        return object instanceof Literal && ((Literal)object).isPositive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReasoningStepIterator process(Object object) {
        Literal literal = (Literal)object;
        ClauseOrientation clauseOrientation = (ClauseOrientation)this.ruleBase.get(literal.getRelation());
        if (clauseOrientation == null) {
            return ArrayReasoningStepIterator.empty;
        }
        try {
            if (!Utils.unify(literal, clauseOrientation, this.vars, this.stack)) {
                ReasoningStepIterator reasoningStepIterator = ArrayReasoningStepIterator.empty;
                return reasoningStepIterator;
            }
            ArrayReasoningStepIterator arrayReasoningStepIterator = new ArrayReasoningStepIterator(new SortedProofStep(literal, clauseOrientation, this.stack));
            return arrayReasoningStepIterator;
        }
        finally {
            if (!this.vars.isEmpty()) {
                Utils.restoreVariableSet(this.vars);
            }
            this.stack.clear();
        }
    }

    public void substitute(Map map) {
        Object object;
        Map.Entry entry;
        ArrayList<ClauseOrientation> arrayList = new ArrayList<ClauseOrientation>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        Iterator iterator = this.ruleBase.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            object = (ClauseOrientation)entry.getValue();
            ClauseOrientation clauseOrientation = DemodUtils.substituteClauseOrientation((ClauseOrientation)object, map, DevNullCollection.instance);
            if (clauseOrientation == object) continue;
            arrayList2.add(object);
            arrayList.add(clauseOrientation);
        }
        entry = arrayList2.iterator();
        while (entry.hasNext()) {
            this.removeRule(((ClauseOrientation)entry.next()).getHead().getRelation());
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            this.addRule((ClauseOrientation)object.next());
        }
    }

    public void addFunctionSymbol(Symbol symbol) {
        functionSyms.add(symbol);
    }

    private class Undo
    extends AbstractUndoableEdit {
        ClauseOrientation co;
        boolean added;

        public Undo(ClauseOrientation clauseOrientation, boolean bl) {
            this.co = clauseOrientation;
            this.added = bl;
        }

        private void addOrRemove(boolean bl) {
            if (bl) {
                BackwardChainingStorage.this.ruleBase.put(this.co.getHead().getRelation(), this.co);
            } else {
                BackwardChainingStorage.this.ruleBase.remove(this.co.getHead().getRelation());
            }
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.addOrRemove(!this.added);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.addOrRemove(this.added);
        }
    }

    static class LeastVarsLiteralComparator
    implements Comparator {
        public static LeastVarsLiteralComparator instance = new LeastVarsLiteralComparator();

        private LeastVarsLiteralComparator() {
        }

        public int compare(Object object, Object object2) {
            if (!(object instanceof Literal)) {
                return -1;
            }
            if (!(object2 instanceof Literal)) {
                return 1;
            }
            if (functionSyms.contains(((Literal)object).getRelation())) {
                return 1;
            }
            if (functionSyms.contains(((Literal)object2).getRelation())) {
                return -1;
            }
            return this.countUnifiables((Literal)object) - this.countUnifiables((Literal)object2);
        }

        public int countUnifiables(Literal literal) {
            List list = literal.getArgs();
            int n = 0;
            int n2 = 0;
            while (n2 < list.size()) {
                if (list.get(n2) instanceof Unifyable) {
                    ++n;
                }
                ++n2;
            }
            return n;
        }
    }

    static class SortedProofStep
    extends ReasoningStep {
        SortedProofStep(Literal literal, ClauseOrientation clauseOrientation, List list) {
            this.goal = literal;
            this.bindings = SubstUtils.variableStackToMap(list, null);
            this.subGoals = SortedProofStep.prepareSubgoals(clauseOrientation);
            if (!this.subGoals.isEmpty()) {
                this.getSubProofs().add(new DirectAssertion(clauseOrientation.getClause()));
            }
        }

        private static List prepareSubgoals(ClauseOrientation clauseOrientation) {
            List list = clauseOrientation.createSubGoals(null);
            ListIterator<DefaultLiteral> listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                Literal literal;
                Object e = listIterator.next();
                if (!(e instanceof Literal) || (literal = (Literal)e).getRelation() != StandardFrames.HOLDS || !(literal.getArgs().get(0) instanceof Symbol)) continue;
                List list2 = literal.getArgs();
                DefaultLiteral defaultLiteral = new DefaultLiteral((Symbol)list2.get(0), list2.subList(1, list2.size()), literal.isPositive());
                listIterator.set(defaultLiteral);
            }
            Collections.sort(list, LeastVarsLiteralComparator.instance);
            return list;
        }

        public String tracePrint() {
            return "Frame rule instantiated: " + SubstUtils.deReferenceLiteral((Literal)this.goal);
        }
    }
}

