/*
 * Decompiled with CFR 0.152.
 */
package jtp.frame;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import jtp.fol.DefaultLiteral;
import jtp.fol.Literal;
import jtp.fol.Symbol;
import jtp.fol.Unifyable;
import jtp.frame.vc.ValueCollection;
import jtp.frame.vc.ValueLink;

public class SlotValueCollection
extends ValueCollection {
    protected Symbol facet;
    protected Symbol slot;
    protected Object frame;
    protected Collection links;
    protected Collection outLinks;
    protected boolean inverse;
    static final Class EMPTY_SET_CLASS = Collections.EMPTY_SET.getClass();

    public SlotValueCollection(Symbol symbol, Symbol symbol2, Object object, boolean bl) {
        this.facet = symbol;
        this.slot = symbol2;
        this.frame = object;
        this.inverse = bl;
        this.links = this.outLinks = Collections.EMPTY_SET;
    }

    public Symbol getSlot() {
        return this.slot;
    }

    public Object getFrame() {
        return this.frame;
    }

    public Symbol getFacet() {
        return this.facet;
    }

    public boolean isInverse() {
        return this.inverse;
    }

    public String toString() {
        if (this.facet == null) {
            return this.toStringWithNoFacet();
        }
        if (this.inverse) {
            return "Collection of frames having value '" + this.frame + "' for facet '" + this.facet + "' of slot '" + this.slot + '\'';
        }
        return "Collection of values for facet '" + this.facet + "' of slot '" + this.slot + "' on frame '" + this.frame + '\'';
    }

    private String toStringWithNoFacet() {
        if (this.inverse) {
            return "Collection of frames having value '" + this.frame + "' for slot '" + this.slot + '\'';
        }
        return "Collection of values for slot '" + this.slot + "' on frame '" + this.frame + '\'';
    }

    public Collection getInputLinks() {
        return this.links;
    }

    public void setInputLinks(Collection collection) {
        this.links = collection;
    }

    public Collection getOutputLinks() {
        return this.outLinks;
    }

    public void setOutputLinks(Collection collection) {
        this.outLinks = collection;
    }

    public String getMembershipString(Object object) {
        Object object2;
        if (this.facet == null) {
            return this.getMembershipStringWithNoFacet(object);
        }
        Object object3 = object2 = this.inverse ? object : this.frame;
        if (this.inverse) {
            object = this.frame;
        }
        return "Facet ''" + this.facet + "' of slot '" + this.slot + "' has a value '" + object + "' on frame '" + object2 + '\'';
    }

    private String getMembershipStringWithNoFacet(Object object) {
        Object object2;
        if (object instanceof Unifyable) {
            object = ((Unifyable)object).deReferenceVariables();
        }
        Object object3 = object2 = this.inverse ? object : this.frame;
        if (this.inverse) {
            object = this.frame;
        }
        return "Slot '" + this.slot + "' has a value '" + object + "' on frame '" + object2 + '\'';
    }

    public Object getMembershipGoal(Object object) {
        return SlotValueCollection.formLiteral(this.getFacet(), this.getSlot(), this.getFrame(), object, this.isInverse());
    }

    public static Literal formLiteral(Symbol symbol, Symbol symbol2, Object object, Object object2, boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        Symbol symbol3 = symbol2;
        if (symbol != null) {
            symbol3 = symbol;
            arrayList.add(symbol2);
        }
        if (bl) {
            arrayList.add(object2);
            arrayList.add(object);
        } else {
            arrayList.add(object);
            arrayList.add(object2);
        }
        return new DefaultLiteral(symbol3, arrayList, true);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Iterator iterator = this.getOutputLinks().iterator();
        while (iterator.hasNext()) {
            ((ValueLink)iterator.next()).source = this;
        }
        Iterator iterator2 = this.getInputLinks().iterator();
        while (iterator2.hasNext()) {
            ((ValueLink)iterator2.next()).target = this;
        }
        if (this.links.getClass() == EMPTY_SET_CLASS) {
            this.links = Collections.EMPTY_SET;
        }
        if (this.outLinks.getClass() == EMPTY_SET_CLASS) {
            this.outLinks = Collections.EMPTY_SET;
        }
    }
}

