/*
 * Decompiled with CFR 0.152.
 */
package jtp.frame;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import jtp.Reasoner;
import jtp.ReasoningStepIterator;
import jtp.fol.Literal;
import jtp.fol.SubstUtils;
import jtp.fol.Symbol;
import jtp.fol.Unifyable;
import jtp.fol.Variable;
import jtp.frame.FrameKB;
import jtp.frame.SlotValueCollection;
import jtp.frame.ValueLinkCreationReasoningStep;
import jtp.frame.ValuePropagationReasoningStepIterator;
import jtp.frame.vc.ValueCollection;
import jtp.frame.vc.ValueLink;
import jtp.frame.vocab.StandardFrames;
import jtp.rs.DefaultReasoningStepCollector;
import jtp.rs.ReasoningStepCollector;
import jtp.util.PropertyImporter;

public class LinkAsserter
extends PropertyImporter
implements Reasoner {
    protected static boolean VERBOSE = Boolean.getBoolean("jtp.frame.LinkAsserter.verbose");
    int redundancyCheckDepth = Integer.MAX_VALUE;
    transient UndoManager undoMgr;
    private FrameKB fkb;
    private static Set temphistory = new HashSet(20);

    public UndoManager getUndoManager() {
        return this.undoMgr;
    }

    public void setUndoManager(UndoManager undoManager) {
        this.undoMgr = undoManager;
    }

    public FrameKB getFrameKB() {
        return this.fkb;
    }

    public void setFrameKB(FrameKB frameKB) {
        this.fkb = frameKB;
    }

    public int getRedundancyCheckDepth() {
        return this.redundancyCheckDepth;
    }

    public void setRedundancyCheckDepth(int n) {
        this.redundancyCheckDepth = n;
    }

    public LinkAsserter() {
        this.setImportedProperties(new String[]{"undoManager", "frameKB"});
    }

    public boolean acceptable(Object object) {
        return object instanceof ValueLinkCreationReasoningStep;
    }

    public ReasoningStepIterator process(Object object) {
        DefaultReasoningStepCollector defaultReasoningStepCollector = new DefaultReasoningStepCollector();
        ValueLink valueLink = this.prepareValueLink((ValueLinkCreationReasoningStep)object, defaultReasoningStepCollector);
        this.processInsertion(valueLink, defaultReasoningStepCollector);
        return defaultReasoningStepCollector;
    }

    protected ValueLink prepareValueLink(ValueLinkCreationReasoningStep valueLinkCreationReasoningStep) {
        return new ValueLink(this.instantiateVCTemplate(valueLinkCreationReasoningStep.from, valueLinkCreationReasoningStep.linkVar, null), this.instantiateVCTemplate(valueLinkCreationReasoningStep.to, valueLinkCreationReasoningStep.linkVar, null), valueLinkCreationReasoningStep);
    }

    protected ValueLink prepareValueLink(ValueLinkCreationReasoningStep valueLinkCreationReasoningStep, ReasoningStepCollector reasoningStepCollector) {
        return new ValueLink(this.instantiateVCTemplate(valueLinkCreationReasoningStep.from, valueLinkCreationReasoningStep.linkVar, reasoningStepCollector), this.instantiateVCTemplate(valueLinkCreationReasoningStep.to, valueLinkCreationReasoningStep.linkVar, reasoningStepCollector), valueLinkCreationReasoningStep);
    }

    private SlotValueCollection instantiateVCTemplate(Literal literal, Variable variable, ReasoningStepCollector reasoningStepCollector) {
        literal = SubstUtils.deReferenceLiteral(literal);
        List list = literal.getArgs();
        int n = 0;
        Symbol symbol = literal.getRelation();
        if (StandardFrames.HOLDS == symbol) {
            if (!(list.get(0) instanceof Symbol)) {
                throw new IllegalArgumentException("non-symbol relation");
            }
            symbol = (Symbol)list.get(0);
            n = 1;
        }
        boolean bl = literal.getArgs().get(1 + n) == variable;
        Object e = literal.getArgs().get(bl ? n : n + 1);
        if (e instanceof Unifyable) {
            throw new IllegalArgumentException("Unifyable frame");
        }
        return this.fkb.getValueCollection(null, symbol, e, !bl, reasoningStepCollector);
    }

    private static Collection getDownstreamCollections(ValueCollection valueCollection) {
        LinkedList<ValueCollection> linkedList = new LinkedList<ValueCollection>();
        HashSet<ValueCollection> hashSet = new HashSet<ValueCollection>();
        linkedList.add(valueCollection);
        while (!linkedList.isEmpty()) {
            ValueCollection valueCollection2 = (ValueCollection)linkedList.remove(0);
            hashSet.add(valueCollection2);
            Iterator iterator = valueCollection2.getOutputLinks().iterator();
            while (iterator.hasNext()) {
                ValueCollection valueCollection3 = ((ValueLink)iterator.next()).getTarget();
                if (hashSet.contains(valueCollection3)) continue;
                linkedList.add(valueCollection3);
            }
        }
        return hashSet;
    }

    private static Collection getUpstreamValues(ValueCollection valueCollection) {
        LinkedList<ValueCollection> linkedList = new LinkedList<ValueCollection>();
        HashSet<ValueCollection> hashSet = new HashSet<ValueCollection>();
        HashSet hashSet2 = new HashSet();
        linkedList.add(valueCollection);
        while (!linkedList.isEmpty()) {
            ValueCollection valueCollection2 = (ValueCollection)linkedList.remove(0);
            hashSet.add(valueCollection2);
            hashSet2.addAll(valueCollection2.directValues());
            Iterator iterator = valueCollection2.getInputLinks().iterator();
            while (iterator.hasNext()) {
                ValueCollection valueCollection3 = ((ValueLink)iterator.next()).getSource();
                if (hashSet.contains(valueCollection3)) continue;
                linkedList.add(valueCollection3);
            }
        }
        return hashSet2;
    }

    public static ReasoningStepIterator propagateAssertedValue(ValueCollection valueCollection, Object object) {
        Collection collection = LinkAsserter.getDownstreamCollections(valueCollection);
        collection.remove(valueCollection);
        return new ValuePropagationReasoningStepIterator(collection, object);
    }

    public static ReasoningStepIterator propagateLinkResults(ValueLink valueLink) {
        Collection collection = LinkAsserter.getUpstreamValues(valueLink.getSource());
        Collection collection2 = LinkAsserter.getDownstreamCollections(valueLink.getTarget());
        return new ValuePropagationReasoningStepIterator(collection2, collection);
    }

    public static ReasoningStepIterator propagateResultsForTarget(ValueLink valueLink) {
        Collection collection = LinkAsserter.getUpstreamValues(valueLink.getSource());
        return new ValuePropagationReasoningStepIterator(Collections.singleton(valueLink.getTarget()), collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkLinkRedundancy(ValueCollection valueCollection, ValueCollection valueCollection2, int n) {
        try {
            boolean bl = LinkAsserter.checkLinkRedundancyInternal(valueCollection, valueCollection2, n, temphistory);
            Object var5_4 = null;
            temphistory.clear();
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            temphistory.clear();
            throw throwable;
        }
    }

    private static boolean checkLinkRedundancyInternal(ValueCollection valueCollection, ValueCollection valueCollection2, int n, Set set) {
        if (set.contains(valueCollection2)) {
            return false;
        }
        set.add(valueCollection2);
        if (valueCollection2 == valueCollection) {
            return true;
        }
        Collection collection = valueCollection2.getInputLinks();
        if (collection.isEmpty()) {
            return false;
        }
        if (n < 1) {
            return false;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!LinkAsserter.checkLinkRedundancyInternal(valueCollection, ((ValueLink)iterator.next()).getSource(), n - 1, set)) continue;
            return true;
        }
        return false;
    }

    public static void insertLink(ValueLink valueLink) {
        Collection<ValueLink> collection = valueLink.getTarget().getInputLinks();
        if (collection == Collections.EMPTY_SET) {
            collection = new ArrayList<ValueLink>();
            valueLink.getTarget().setInputLinks(collection);
        }
        collection.add(valueLink);
        collection = valueLink.getSource().getOutputLinks();
        if (collection == Collections.EMPTY_SET) {
            collection = new ArrayList();
            valueLink.getSource().setOutputLinks(collection);
        }
        collection.add(valueLink);
        if (VERBOSE) {
            System.out.println("Creating link from " + valueLink.getTarget() + " to " + valueLink.getSource());
            System.out.println("LINKS NOW:");
            Iterator iterator = valueLink.getTarget().getInputLinks().iterator();
            while (iterator.hasNext()) {
                ValueLink valueLink2 = (ValueLink)iterator.next();
                System.out.println("   " + valueLink2.getSource());
            }
        }
    }

    public void processInsertion(ValueLink valueLink) {
        if (LinkAsserter.checkLinkRedundancy(valueLink.getSource(), valueLink.getTarget(), this.getRedundancyCheckDepth())) {
            if (VERBOSE) {
                System.out.println("Skipping redundant link: " + valueLink + "; tgt=" + valueLink.getTarget());
            }
            return;
        }
        LinkAsserter.insertLink(valueLink);
        if (this.undoMgr != null) {
            this.undoMgr.addEdit(new UndoInsert(valueLink));
        }
    }

    public void processInsertion(ValueLink valueLink, DefaultReasoningStepCollector defaultReasoningStepCollector) {
        if (LinkAsserter.checkLinkRedundancy(valueLink.getSource(), valueLink.getTarget(), this.getRedundancyCheckDepth())) {
            if (VERBOSE) {
                System.out.println("Skipping redundant link: " + valueLink + "; tgt=" + valueLink.getTarget());
            }
            return;
        }
        LinkAsserter.insertLink(valueLink);
        if (this.undoMgr != null) {
            this.undoMgr.addEdit(new UndoInsert(valueLink));
        }
        if (valueLink.getTarget().getVCListener() != null) {
            valueLink.getTarget().getVCListener().inputLinkAdded(valueLink, defaultReasoningStepCollector);
        }
    }

    public void processRemoval(ValueLink valueLink) {
        LinkAsserter.removeLink(valueLink);
        if (this.undoMgr != null) {
            this.undoMgr.addEdit(new UndoRemove(valueLink));
        }
    }

    public static void removeLink(ValueLink valueLink) {
        valueLink.getTarget().getInputLinks().remove(valueLink);
        valueLink.getSource().getOutputLinks().remove(valueLink);
    }

    protected static class UndoRemove
    extends AbstractUndoableEdit {
        ValueLink link;

        public UndoRemove(ValueLink valueLink) {
            this.link = valueLink;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            LinkAsserter.insertLink(this.link);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            LinkAsserter.removeLink(this.link);
        }
    }

    protected static class UndoInsert
    extends AbstractUndoableEdit {
        ValueLink link;

        public UndoInsert(ValueLink valueLink) {
            this.link = valueLink;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            LinkAsserter.removeLink(this.link);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            LinkAsserter.insertLink(this.link);
        }
    }
}

