/*
 * Decompiled with CFR 0.152.
 */
package jtp.frame;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import jtp.ReasoningStep;
import jtp.fol.Symbol;
import jtp.frame.LinkAsserter;
import jtp.frame.SlotValueCollection;
import jtp.frame.vocab.StandardFrames;
import jtp.rs.ReasoningStepCollector;
import jtp.rs.SecondaryProofStorageWriter;
import jtp.util.PropertyImporter;

public class FrameKB
extends PropertyImporter {
    static int INITIAL_HASH_SIZE = 500;
    LinkAsserter la;
    Map direct = new HashMap(INITIAL_HASH_SIZE);
    Map templates = new HashMap(INITIAL_HASH_SIZE);
    Map inverse = new HashMap(INITIAL_HASH_SIZE);
    ArrayList key;
    transient UndoManager undoManager;

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public void setUndoManager(UndoManager undoManager) {
        this.undoManager = undoManager;
        this.la.setUndoManager(undoManager);
    }

    public FrameKB() {
        this.setImportedProperties(new String[]{"undoManager"});
        this.key = new ArrayList(3);
        int n = 0;
        while (n < 3) {
            this.key.add(null);
            ++n;
        }
        this.initFrames();
        this.la = new LinkAsserter();
    }

    public void putValue(Symbol symbol, Symbol symbol2, Object object, Object object2, ReasoningStep reasoningStep, ReasoningStepCollector reasoningStepCollector) {
        SlotValueCollection slotValueCollection;
        SlotValueCollection slotValueCollection2 = this.getValueCollection(symbol, symbol2, object, false, reasoningStepCollector);
        if (FrameKB.addValue(slotValueCollection2, slotValueCollection = this.getValueCollection(symbol, symbol2, object2, true, reasoningStepCollector), object, object2, reasoningStep)) {
            if (this.undoManager != null) {
                this.undoManager.addEdit(new UndoAdd(slotValueCollection2, slotValueCollection, object, object2, reasoningStep));
            }
            if (reasoningStepCollector != null) {
                if (slotValueCollection2.getVCListener() != null) {
                    slotValueCollection2.getVCListener().directValueAdded(object2, reasoningStep, reasoningStepCollector);
                }
                if (slotValueCollection.getVCListener() != null) {
                    slotValueCollection.getVCListener().directValueAdded(object, reasoningStep, reasoningStepCollector);
                }
            }
        }
    }

    public void putValue(Symbol symbol, Symbol symbol2, Object object, Object object2, ReasoningStepCollector reasoningStepCollector) {
        this.putValue(symbol, symbol2, object, object2, null, reasoningStepCollector);
    }

    public void putValue(Symbol symbol, Symbol symbol2, Object object, Object object2, ReasoningStep reasoningStep) {
        this.putValue(symbol, symbol2, object, object2, reasoningStep, null);
    }

    public void putValue(Symbol symbol, Symbol symbol2, Object object, Object object2) {
        this.putValue(symbol, symbol2, object, object2, null, null);
    }

    public void putValue(Symbol symbol, Symbol symbol2, Object object, Object object2, boolean bl, ReasoningStep reasoningStep, ReasoningStepCollector reasoningStepCollector) {
        SlotValueCollection slotValueCollection = this.getValueCollection(symbol, symbol2, object, bl, reasoningStepCollector);
        if (FrameKB.addValue(slotValueCollection, object2, reasoningStep)) {
            if (this.undoManager != null) {
                this.undoManager.addEdit(new UndoSingleAdd(slotValueCollection, object2, reasoningStep));
            }
            if (reasoningStepCollector != null && slotValueCollection.getVCListener() != null) {
                slotValueCollection.getVCListener().directValueAdded(object2, reasoningStep, reasoningStepCollector);
            }
        }
    }

    public void removeValue(Symbol symbol, Symbol symbol2, Object object, Object object2) {
        ReasoningStep reasoningStep;
        SlotValueCollection slotValueCollection = this.getValueCollection(symbol, symbol2, object, false, null);
        SlotValueCollection slotValueCollection2 = this.getValueCollection(symbol, symbol2, object2, true, null);
        ReasoningStep reasoningStep2 = reasoningStep = slotValueCollection.valueIsInferred(object2) ? slotValueCollection.getProof(object2) : null;
        if (FrameKB.removeValue(slotValueCollection, slotValueCollection2, object, object2) && this.undoManager != null) {
            this.undoManager.addEdit(new UndoRemove(slotValueCollection, slotValueCollection2, object, object2, reasoningStep));
        }
    }

    public SlotValueCollection findValueCollection(Symbol symbol, Symbol symbol2, Object object, boolean bl) {
        Map map = bl ? this.inverse : this.direct;
        this.key.set(0, symbol);
        this.key.set(1, symbol2);
        this.key.set(2, object);
        return (SlotValueCollection)map.get(this.key);
    }

    public SlotValueCollection getValueCollection(Symbol symbol, Symbol symbol2, Object object, boolean bl) {
        return this.getValueCollection(symbol, symbol2, object, bl, null);
    }

    public SlotValueCollection getValueCollection(Symbol symbol, Symbol symbol2, Object object, boolean bl, ReasoningStepCollector reasoningStepCollector) {
        Map map = bl ? this.inverse : this.direct;
        this.key.set(0, symbol);
        this.key.set(1, symbol2);
        this.key.set(2, object);
        SlotValueCollection slotValueCollection = (SlotValueCollection)map.get(this.key);
        if (slotValueCollection == null) {
            ArrayList arrayList = new ArrayList(3);
            arrayList.addAll(this.key);
            slotValueCollection = this.createValueCollection(symbol, symbol2, object, map == this.inverse);
            map.put(arrayList, slotValueCollection);
        }
        if (symbol2 != StandardFrames.HAS_SLOT && symbol2 != StandardFrames.HAS_INVERSE_SLOT && symbol2 != StandardFrames.INSTANCE_OF) {
            if (bl) {
                this.putValue(null, StandardFrames.HAS_INVERSE_SLOT, object, (Object)symbol2, reasoningStepCollector);
            } else {
                this.putValue(null, StandardFrames.HAS_SLOT, object, (Object)symbol2, reasoningStepCollector);
                this.putValue(null, StandardFrames.INSTANCE_OF, object, (Object)StandardFrames.FRAME, reasoningStepCollector);
                this.putValue(null, StandardFrames.INSTANCE_OF, (Object)symbol2, (Object)StandardFrames.SLOT, reasoningStepCollector);
            }
        }
        if (symbol != null && symbol != StandardFrames.HAS_FACET && !bl) {
            this.putValue(StandardFrames.HAS_FACET, symbol2, object, (Object)symbol, reasoningStepCollector);
        }
        return slotValueCollection;
    }

    protected SlotValueCollection createValueCollection(Symbol symbol, Symbol symbol2, Object object, boolean bl) {
        return new SlotValueCollection(symbol, symbol2, object, bl);
    }

    public void initFrames() {
    }

    public void stripProofs(SecondaryProofStorageWriter secondaryProofStorageWriter) throws IOException {
        Iterator iterator = this.direct.values().iterator();
        while (iterator.hasNext()) {
            SlotValueCollection slotValueCollection = (SlotValueCollection)iterator.next();
            Iterator iterator2 = slotValueCollection.directValues().iterator();
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                if (!slotValueCollection.valueIsInferred(e)) continue;
                ReasoningStep reasoningStep = slotValueCollection.getProof(e);
                SlotValueCollection slotValueCollection2 = this.findValueCollection(slotValueCollection.getFacet(), slotValueCollection.getSlot(), e, true);
                if (!secondaryProofStorageWriter.storeProof(reasoningStep)) continue;
                slotValueCollection.setProof(e, null);
                slotValueCollection2.setProof(slotValueCollection.getFrame(), null);
            }
        }
    }

    static boolean addValue(SlotValueCollection slotValueCollection, SlotValueCollection slotValueCollection2, Object object, Object object2) {
        return FrameKB.addValue(slotValueCollection, slotValueCollection2, object, object2, null);
    }

    static boolean addValue(SlotValueCollection slotValueCollection, SlotValueCollection slotValueCollection2, Object object, Object object2, ReasoningStep reasoningStep) {
        boolean bl = slotValueCollection.add(object2, reasoningStep);
        return slotValueCollection2.add(object, reasoningStep) || bl;
    }

    static boolean addValue(SlotValueCollection slotValueCollection, Object object) {
        return FrameKB.addValue(slotValueCollection, object, null);
    }

    static boolean addValue(SlotValueCollection slotValueCollection, Object object, ReasoningStep reasoningStep) {
        return slotValueCollection.add(object, reasoningStep);
    }

    static boolean removeValue(SlotValueCollection slotValueCollection, SlotValueCollection slotValueCollection2, Object object, Object object2) {
        boolean bl = slotValueCollection.remove(object2);
        return slotValueCollection2.remove(object) || bl;
    }

    static boolean removeValue(SlotValueCollection slotValueCollection, Object object) {
        return slotValueCollection.remove(object);
    }

    static class UndoRemove
    extends Undo {
        public UndoRemove(SlotValueCollection slotValueCollection, SlotValueCollection slotValueCollection2, Object object, Object object2, ReasoningStep reasoningStep) {
            super(slotValueCollection, slotValueCollection2, object, object2, reasoningStep);
        }

        public void undo() throws CannotUndoException {
            super.undo();
            FrameKB.addValue(this.valueCollection, this.inverseValueCollection, this.frame, this.value, this.proof);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            FrameKB.removeValue(this.valueCollection, this.inverseValueCollection, this.frame, this.value);
        }
    }

    static class UndoSingleAdd
    extends Undo {
        public UndoSingleAdd(SlotValueCollection slotValueCollection, Object object, ReasoningStep reasoningStep) {
            super(slotValueCollection, null, null, object, reasoningStep);
        }

        public void undo() throws CannotUndoException {
            super.undo();
            FrameKB.removeValue(this.valueCollection, this.value);
        }

        public void redo() throws CannotUndoException {
            super.redo();
            FrameKB.addValue(this.valueCollection, this.value, this.proof);
        }
    }

    static class UndoAdd
    extends Undo {
        public UndoAdd(SlotValueCollection slotValueCollection, SlotValueCollection slotValueCollection2, Object object, Object object2, ReasoningStep reasoningStep) {
            super(slotValueCollection, slotValueCollection2, object, object2, reasoningStep);
        }

        public void undo() throws CannotUndoException {
            super.undo();
            FrameKB.removeValue(this.valueCollection, this.inverseValueCollection, this.frame, this.value);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            FrameKB.addValue(this.valueCollection, this.inverseValueCollection, this.frame, this.value, this.proof);
        }
    }

    private static abstract class Undo
    extends AbstractUndoableEdit {
        SlotValueCollection valueCollection;
        SlotValueCollection inverseValueCollection;
        Object frame;
        Object value;
        ReasoningStep proof;

        public Undo(SlotValueCollection slotValueCollection, SlotValueCollection slotValueCollection2, Object object, Object object2, ReasoningStep reasoningStep) {
            this.valueCollection = slotValueCollection;
            this.inverseValueCollection = slotValueCollection2;
            this.frame = object;
            this.value = object2;
            this.proof = reasoningStep;
        }
    }
}

