/*
 * Decompiled with CFR 0.152.
 */
package jtp.fol.rdf;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import jtp.fol.Clause;
import jtp.fol.Literal;
import jtp.fol.parser.ClauseIterator;
import jtp.fol.parser.FirstOrderLogicParser;
import jtp.fol.rdf.JenaObjectConverter;
import jtp.util.UnexpectedException;
import org.xml.sax.InputSource;

public class RDFParser
extends JenaObjectConverter
implements FirstOrderLogicParser {
    Selector damlFirstStmtSelector = new SimpleSelector(null, DAML_OIL.first, (RDFNode)null);
    Selector damlRestStmtSelector = new SimpleSelector(null, DAML_OIL.rest, (RDFNode)null);
    Selector damlItemStmtSelector = new SimpleSelector(null, DAML_OIL.item, (RDFNode)null);
    Selector rdfFirstStmtSelector = new SimpleSelector(null, RDF.first, (RDFNode)null);
    Selector rdfRestStmtSelector = new SimpleSelector(null, RDF.rest, (RDFNode)null);
    boolean polarity = true;

    public RDFParser() {
        System.setProperty("org.xml.sax.parser", "org.apache.xerces.parsers.SAXParser");
    }

    public boolean acceptable(Object object) {
        return object instanceof Reader || object instanceof URL;
    }

    public ClauseIterator parse(Reader reader) {
        InputSource inputSource = new InputSource();
        inputSource.setCharacterStream(reader);
        return this.parse(inputSource);
    }

    public ClauseIterator parse(Reader reader, URL uRL) {
        InputSource inputSource = new InputSource();
        inputSource.setCharacterStream(reader);
        inputSource.setSystemId(uRL.toString());
        return this.parse(inputSource);
    }

    public ClauseIterator parse(URL uRL, URL uRL2) {
        InputSource inputSource = new InputSource();
        try {
            inputSource.setCharacterStream(new BufferedReader(new InputStreamReader(uRL.openStream())));
        }
        catch (IOException iOException) {
            throw new UnexpectedException(iOException);
        }
        inputSource.setSystemId(uRL2.toString());
        return this.parse(inputSource);
    }

    public ClauseIterator parse(URL uRL) {
        InputSource inputSource = new InputSource();
        inputSource.setSystemId(uRL.toString());
        try {
            inputSource.setCharacterStream(new BufferedReader(new InputStreamReader(uRL.openStream())));
        }
        catch (IOException iOException) {
            throw new UnexpectedException(iOException);
        }
        return this.parse(inputSource);
    }

    public ClauseIterator parse(InputSource inputSource) {
        Model model = ModelFactory.createDefaultModel();
        model.read(inputSource.getCharacterStream(), inputSource.getSystemId() == null ? "" : inputSource.getSystemId());
        return this.parse(model);
    }

    public ClauseIterator parse(Model model) {
        Model model2 = ModelFactory.createDefaultModel();
        model2.add(model.listStatements(this.damlFirstStmtSelector));
        model2.add(model.listStatements(this.rdfFirstStmtSelector));
        model2.add(model.listStatements(this.damlItemStmtSelector));
        model2.add(model.listStatements(this.damlRestStmtSelector));
        model2.add(model.listStatements(this.rdfRestStmtSelector));
        Model model3 = model.difference(model2);
        RDFParser.addContainerMembershipPropertyTypeStatements(model3);
        final int n = (int)(model2.size() + model3.size());
        final StmtIterator stmtIterator = model2.listStatements();
        final StmtIterator stmtIterator2 = model3.listStatements();
        return new ClauseIterator(){
            int i = 0;
            boolean printDebug = Boolean.getBoolean("jtp.fol.daml.DAMLParser.printDebugTriples") || Boolean.getBoolean("jtp.fol.rdf.RDFParser.printDebugTriples");

            public boolean hasNext() {
                return stmtIterator.hasNext() || stmtIterator2.hasNext();
            }

            public Clause next() {
                Statement statement = stmtIterator.hasNext() ? stmtIterator.nextStatement() : stmtIterator2.nextStatement();
                Literal literal = RDFParser.this.makeLiteral(statement);
                if (this.printDebug) {
                    System.out.println("[" + ++this.i + " of " + n + "] " + literal);
                }
                return literal;
            }
        };
    }

    public boolean getPolarity() {
        return this.polarity;
    }

    public void setPolarity(boolean bl) {
        this.polarity = bl;
    }

    public String getLanguage() {
        return "RDF";
    }

    protected static void addContainerMembershipPropertyTypeStatements(Model model) {
        int n = 0;
        StmtIterator stmtIterator = model.listStatements();
        while (stmtIterator.hasNext()) {
            Property property = stmtIterator.nextStatement().getPredicate();
            if (property.getOrdinal() <= n) continue;
            n = property.getOrdinal();
        }
        int n2 = 1;
        while (n2 <= n) {
            RDFParser.addContainerMembershipPropertyTypeStatement(n2, model);
            ++n2;
        }
    }

    protected static void addContainerMembershipPropertyTypeStatement(int n, Model model) {
        Property property = model.getProperty(RDF.getURI(), "_" + n);
        model.add(model.createStatement((Resource)property, RDF.type, (RDFNode)RDFS.ContainerMembershipProperty));
    }
}

